/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import rnadesign.designapp.rnagui.FileExtensionException;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.PdbJunctionControllerParameters;
import rnadesign.rnamodel.CorridorDescriptor;

public class JunctionParameterWizard
implements GeneralWizard {
    private static final String SLASH = File.separator;
    private static final int COL_SIZE_DOUBLE = 8;
    private static final int COL_SIZE_INT = 5;
    private static final int COL_SIZE_NAME = 20;
    private static final int COL_SIZE_FILENAME = 50;
    private boolean finished = false;
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private JFrame frame = null;
    private JTextField corridorRadiusField;
    private JTextField corridorStartField;
    private JTextField offsetField;
    private JTextField orderMaxField;
    private JTextField fileNameField;
    private JTextField writeNameField;
    private JCheckBox writeBox;
    private boolean noWriteFlag = true;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    private boolean rnaMode = true;
    private int branchDescriptorOffset = 2;
    private double corridorRadius = 5.0;
    private double corridorStart = 5.0;
    private int loopLengthSumMax = 50;
    private int orderMax = 5;
    private String name = "pdb";
    private String fileName;
    private int stemLengthMin = 3;
    private String writeName;
    private String usedDirectory;
    private String writeDir;
    public static final String FRAME_TITLE = "Junction Parameter Wizard";
    public static final String NAMES_EXTENSION = ".names";
    public static final String NTL_EXTENSION = ".ntl";

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 1));
        JPanel topPanel = new JPanel();
        JPanel sPanel = new JPanel();
        JPanel checkPanel = new JPanel();
        this.orderMaxField = new JTextField("" + this.orderMax, 1);
        this.offsetField = new JTextField("" + this.branchDescriptorOffset, 1);
        this.corridorRadiusField = new JTextField("" + this.corridorRadius, 8);
        this.corridorStartField = new JTextField("" + this.corridorStart, 8);
        this.fileNameField = new JTextField(this.fileName, 50);
        this.writeNameField = new JTextField(this.writeName, 50);
        JPanel filePanel = new JPanel();
        filePanel.add(new JLabel("Filename:"));
        filePanel.add(this.fileNameField);
        JButton button = new JButton("Browse");
        button.addActionListener(new FileBrowseActionListener());
        filePanel.add(button);
        center.add(filePanel);
        JPanel writePanel = new JPanel();
        writePanel.add(new JLabel("Write to:"));
        writePanel.add(this.writeNameField);
        button = new JButton("Browse");
        button.addActionListener(new WriteBrowseActionListener());
        writePanel.add(button);
        center.add(writePanel);
        JPanel noWritePanel = new JPanel();
        this.writeBox = new JCheckBox("Write junctions to file", !this.noWriteFlag);
        noWritePanel.add(this.writeBox);
        center.add(noWritePanel);
        sPanel.add(new JLabel("Max. Order:"));
        sPanel.add(this.orderMaxField);
        sPanel.add(new JLabel(" Offset:"));
        sPanel.add(this.offsetField);
        sPanel.add(new JLabel(" Corridor radius:"));
        sPanel.add(this.corridorRadiusField);
        sPanel.add(new JLabel(" Corridor start:"));
        sPanel.add(this.corridorStartField);
        center.add(sPanel);
        center.add(checkPanel);
        JPanel bottomPanel = new JPanel();
        button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        f.add((Component)topPanel, "North");
        f.add((Component)bottomPanel, "South");
        f.add((Component)center, "Center");
    }

    private void readOutValues() throws FileExtensionException {
        this.orderMax = Integer.parseInt(this.orderMaxField.getText().trim()) + 1;
        this.branchDescriptorOffset = Integer.parseInt(this.offsetField.getText().trim());
        this.corridorRadius = Double.parseDouble(this.corridorRadiusField.getText().trim());
        this.corridorStart = Double.parseDouble(this.corridorStartField.getText().trim());
        this.fileName = this.fileNameField.getText().trim();
        this.writeDir = this.writeNameField.getText().trim();
        boolean bl = this.noWriteFlag = !this.writeBox.isSelected();
        if (!this.fileName.endsWith(NAMES_EXTENSION)) {
            throw new FileExtensionException(NAMES_EXTENSION);
        }
    }

    private class WriteBrowseActionListener
    implements ActionListener {
        private WriteBrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            DirFileFilter filter = new DirFileFilter();
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(filter);
            String cwdName = JunctionParameterWizard.this.graphController.getLastReadDirectory();
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showOpenDialog(JunctionParameterWizard.this.frame);
            if (returnVal == 0) {
                JunctionParameterWizard.this.writeName = chooser.getCurrentDirectory() + SLASH + chooser.getSelectedFile().getName();
                JunctionParameterWizard.this.writeNameField.setText(JunctionParameterWizard.this.writeName);
                try {
                    JunctionParameterWizard.this.writeDir = chooser.getCurrentDirectory().getCanonicalPath();
                }
                catch (IOException ioe) {
                    log.severe("getCanonicalPath threw: " + ioe);
                }
                log.info("You chose this file: " + JunctionParameterWizard.this.writeName);
            }
        }
    }

    private class FileBrowseActionListener
    implements ActionListener {
        private FileBrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            NamesFileFilter filter = new NamesFileFilter();
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(filter);
            String cwdName = JunctionParameterWizard.this.graphController.getLastReadDirectory();
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showOpenDialog(JunctionParameterWizard.this.frame);
            if (returnVal == 0) {
                JunctionParameterWizard.this.fileName = chooser.getCurrentDirectory() + SLASH + chooser.getSelectedFile().getName();
                JunctionParameterWizard.this.fileNameField.setText(JunctionParameterWizard.this.fileName);
                try {
                    JunctionParameterWizard.this.writeName = JunctionParameterWizard.this.fileName.substring(0, JunctionParameterWizard.this.fileName.indexOf("rnano4")) + "rnano4" + SLASH + "db" + SLASH + "nanotiler" + SLASH;
                }
                catch (StringIndexOutOfBoundsException se) {
                    JunctionParameterWizard.this.writeName = "";
                }
                JunctionParameterWizard.this.writeNameField.setText(JunctionParameterWizard.this.writeName);
                try {
                    JunctionParameterWizard.this.usedDirectory = chooser.getCurrentDirectory().getCanonicalPath();
                }
                catch (IOException ioe) {
                    log.severe("getCanonicalPath threw: " + ioe);
                }
                log.info("You chose this file: " + JunctionParameterWizard.this.fileName);
            }
        }
    }

    class DirFileFilter
    extends FileFilter {
        DirFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "directories";
        }
    }

    class NamesFileFilter
    extends FileFilter {
        NamesFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(JunctionParameterWizard.NAMES_EXTENSION);
        }

        @Override
        public String getDescription() {
            return ".names files";
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JunctionParameterWizard.this.frame.setVisible(false);
            JunctionParameterWizard.this.frame = null;
            JunctionParameterWizard.this.finished = true;
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JunctionParameterWizard.this.readOutValues();
                PdbJunctionControllerParameters prm = new PdbJunctionControllerParameters(JunctionParameterWizard.this.orderMax, JunctionParameterWizard.this.fileName, JunctionParameterWizard.this.usedDirectory, JunctionParameterWizard.this.writeDir, JunctionParameterWizard.this.noWriteFlag, JunctionParameterWizard.this.rnaMode, JunctionParameterWizard.this.branchDescriptorOffset, JunctionParameterWizard.this.stemLengthMin, new CorridorDescriptor(JunctionParameterWizard.this.corridorRadius, JunctionParameterWizard.this.corridorStart), JunctionParameterWizard.this.loopLengthSumMax);
                JunctionParameterWizard.this.graphController.resetJunctionController(prm);
                JunctionParameterWizard.this.frame.setVisible(false);
                JunctionParameterWizard.this.frame = null;
                JunctionParameterWizard.this.finished = true;
                JunctionParameterWizard.this.graphController.setLastReadDirectory(JunctionParameterWizard.this.usedDirectory);
            }
            catch (FileExtensionException fee) {
                log.severe("Threw a FileExtensionException");
            }
        }
    }
}

