/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.Wizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3D;

public class SynthWizard
implements Wizard {
    public static final int COL_SIZE_SELECTION = 20;
    public static final int COL_SIZE_COORDINATE = 6;
    private boolean finished = false;
    private JFrame frame = null;
    private Container container = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    public static final String FRAME_TITLE = "Synth Wizard";
    private JTextField selectionField;
    private JTextField nameField;
    private JTextField xField;
    private JTextField yField;
    private JTextField zField;
    private JRadioButton simpleButton;
    private CommandApplication application;
    private Vector<String> tree;
    private String[] allowedNames;
    private String[] forbiddenNames;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JScrollPane treeScroll;
    private JLabel label;

    public SynthWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    private void addAllowedName(String type) {
        if (this.allowedNames == null) {
            this.allowedNames = new String[1];
            this.allowedNames[0] = type;
        } else {
            boolean contains = false;
            for (int i = 0; i < this.allowedNames.length; ++i) {
                if (this.allowedNames[i] == null || !this.allowedNames[i].equals(type)) continue;
                contains = true;
                i = this.allowedNames.length;
            }
            if (!contains) {
                String[] tmp = this.allowedNames;
                this.allowedNames = new String[this.allowedNames.length + 1];
                for (int i = 0; i < tmp.length; ++i) {
                    this.allowedNames[i] = tmp[i];
                }
                this.allowedNames[this.allowedNames.length - 1] = type;
            }
        }
    }

    public void addComponents() {
        Container f = new Container();
        f.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        this.treeButton = new JButton("View tree");
        this.treeButton.addActionListener(new TreeListener());
        top.add(this.treeButton);
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        this.label = new JLabel("Parent Object: ");
        left.add(this.label);
        this.label = new JLabel("Object Type: ");
        left.add(this.label);
        this.label = new JLabel(" ");
        left.add(this.label);
        this.label = new JLabel("Object Name: ");
        left.add(this.label);
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 1));
        this.selectionField = new JTextField(this.getSelectionText(), 20);
        center.add((Component)this.selectionField, "Center");
        this.simpleButton = new JRadioButton("Simple", true);
        center.add(this.simpleButton);
        this.nameField = new JTextField(20);
        center.add(this.nameField);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JPanel southBottomPanel = new JPanel();
        JButton button = new JButton("Close");
        button.addActionListener(new CancelListener());
        southBottomPanel.add(button);
        button = new JButton("Synth Object");
        button.addActionListener(new DoneListener());
        southBottomPanel.add(button);
        bottomPanel.add((Component)southBottomPanel, "South");
        JPanel northBottomPanel = new JPanel();
        this.label = new JLabel("x: ");
        northBottomPanel.add(this.label);
        this.xField = new JTextField(6);
        this.xField.setText("0.0");
        northBottomPanel.add(this.xField);
        this.label = new JLabel("y: ");
        northBottomPanel.add(this.label);
        this.yField = new JTextField(6);
        this.yField.setText("0.0");
        northBottomPanel.add(this.yField);
        this.label = new JLabel("z: ");
        northBottomPanel.add(this.label);
        this.zField = new JTextField(6);
        this.zField.setText("0.0");
        northBottomPanel.add(this.zField);
        bottomPanel.add((Component)northBottomPanel, "North");
        f.add((Component)left, "West");
        f.add((Component)top, "North");
        f.add((Component)center, "Center");
        f.add((Component)bottomPanel, "South");
        this.container.add(f);
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    private void addForbiddenName(String type) {
        if (this.forbiddenNames == null) {
            this.forbiddenNames = new String[1];
            this.forbiddenNames[0] = type;
        } else {
            boolean contains = false;
            for (int i = 0; i < this.forbiddenNames.length; ++i) {
                if (this.forbiddenNames[i] == null || !this.forbiddenNames[i].equals(type)) continue;
                contains = true;
                i = this.forbiddenNames.length;
            }
            if (!contains) {
                String[] tmp = this.forbiddenNames;
                this.forbiddenNames = new String[this.forbiddenNames.length + 1];
                for (int i = 0; i < tmp.length; ++i) {
                    this.forbiddenNames[i] = tmp[i];
                }
                this.forbiddenNames[this.forbiddenNames.length - 1] = type;
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        this.container = this.frame.getContentPane();
        this.container.setLayout(new FlowLayout());
        this.addComponents();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void removeAllowedName(String type) {
        if (this.allowedNames == null) {
            this.allowedNames = new String[1];
            this.allowedNames[0] = type;
        } else {
            boolean contains = false;
            for (int i = 0; i < this.allowedNames.length; ++i) {
                if (this.allowedNames[i] == null || !this.allowedNames[i].equals(type)) continue;
                contains = true;
                i = this.allowedNames.length;
            }
            if (contains) {
                String[] tmp = this.allowedNames;
                this.allowedNames = new String[this.allowedNames.length - 1];
                for (int i = 0; i < this.allowedNames.length; ++i) {
                    if (tmp[i] == null || tmp[i].equals(type)) continue;
                    this.allowedNames[i] = tmp[i];
                }
            }
        }
    }

    private void removeForbiddenName(String type) {
        if (this.forbiddenNames == null) {
            this.forbiddenNames = new String[1];
            this.forbiddenNames[0] = type;
        } else {
            boolean contains = false;
            for (int i = 0; i < this.forbiddenNames.length; ++i) {
                if (this.forbiddenNames[i] == null || !this.forbiddenNames[i].equals(type)) continue;
                contains = true;
                i = this.forbiddenNames.length;
            }
            if (contains) {
                String[] tmp = this.forbiddenNames;
                this.forbiddenNames = new String[this.forbiddenNames.length - 1];
                for (int i = 0; i < this.forbiddenNames.length; ++i) {
                    if (tmp[i] == null || tmp[i].equals(type)) continue;
                    this.forbiddenNames[i] = tmp[i];
                }
            }
        }
    }

    private void setAllowedNames() {
        String type = this.tree.get(0);
        int spaceIndex = type.indexOf(" ") + 1;
        spaceIndex = type.indexOf(" ", spaceIndex) + 1;
        spaceIndex = type.indexOf(" ", spaceIndex) + 1;
        type = type.substring(spaceIndex, type.indexOf(" ", spaceIndex));
        this.setAllowedNames(type);
    }

    private void setAllowedNames(String allowedType) {
        int i;
        String[] oldAllowedNames = this.allowedNames;
        Vector<String> allowed = new Vector<String>();
        allowed.add(allowedType);
        for (i = 0; i < this.tree.size(); ++i) {
            String line = this.tree.get(i);
            int spaceIndex = line.indexOf(" ") + 1;
            spaceIndex = line.indexOf(" ", spaceIndex) + 1;
            if (allowed.contains(line = line.substring(spaceIndex = line.indexOf(" ", spaceIndex) + 1, line.indexOf(" ", spaceIndex))) || line == null || line == "null") continue;
            allowed.add(line);
        }
        this.allowedNames = new String[allowed.size()];
        for (i = 0; i < allowed.size(); ++i) {
            this.allowedNames[i] = (String)allowed.get(i);
        }
        if (this.allowedNames != null && oldAllowedNames != null && this.allowedNames.length != oldAllowedNames.length) {
            for (i = 0; i < oldAllowedNames.length; ++i) {
                if (oldAllowedNames[i] == null || allowed.contains(oldAllowedNames[i]) || oldAllowedNames[i] == allowedType || oldAllowedNames[i] == null || oldAllowedNames[i] == "null") continue;
                this.addForbiddenName(oldAllowedNames[i]);
            }
        }
    }

    private class TreeListener
    implements ActionListener {
        private TreeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SynthWizard.this.treeButton.getText().equals("View tree")) {
                SynthWizard.this.treeButton.setText("Hide tree");
                Object3DGraphController controller = ((AbstractDesigner)SynthWizard.this.application).getGraphController();
                SynthWizard.this.tree = controller.getGraph().getTree(SynthWizard.this.allowedNames, SynthWizard.this.forbiddenNames);
                SynthWizard.this.setAllowedNames();
                Container j = new Container();
                j.setLayout(new BorderLayout());
                JPanel allowedPanel = new JPanel();
                allowedPanel.setLayout(new BoxLayout(allowedPanel, 1));
                allowedPanel.add(new JLabel("Allowed types:"));
                if (SynthWizard.this.allowedNames != null) {
                    for (int i = 0; i < SynthWizard.this.allowedNames.length; ++i) {
                        JCheckBox checkBox = new JCheckBox(SynthWizard.this.allowedNames[i], true);
                        checkBox.addActionListener(new CheckListener());
                        allowedPanel.add(checkBox);
                    }
                    j.add((Component)allowedPanel, "North");
                }
                SynthWizard.this.treePanel = new JPanel();
                SynthWizard.this.treeList = new JList(SynthWizard.this.tree);
                SynthWizard.this.treeList.addListSelectionListener(new SelectionListener());
                SynthWizard.this.treeScroll = new JScrollPane(SynthWizard.this.treeList);
                SynthWizard.this.treePanel.add(SynthWizard.this.treeScroll);
                j.add((Component)SynthWizard.this.treePanel, "South");
                SynthWizard.this.frame.getContentPane().add(j);
                SynthWizard.this.frame.pack();
            } else {
                SynthWizard.this.frame.getContentPane().remove(1);
                SynthWizard.this.treeButton.setText("View tree");
                SynthWizard.this.frame.pack();
            }
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)SynthWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(SynthWizard.this.selectionField.getText())) {
                    text = (String)SynthWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                SynthWizard.this.selectionField.setText(text);
            }
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = "synth simple  " + SynthWizard.this.nameField.getText().trim() + " " + SynthWizard.this.selectionField.getText().trim() + " " + SynthWizard.this.xField.getText().trim() + " " + SynthWizard.this.yField.getText().trim() + " " + SynthWizard.this.zField.getText().trim();
            try {
                SynthWizard.this.application.runScriptLine(command);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(SynthWizard.this.frame, "Error executing command: " + command + " : " + ce.getMessage());
            }
        }
    }

    public class CheckListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            String checkedType = checkBox.getText();
            if (!checkBox.isSelected()) {
                SynthWizard.this.removeAllowedName(checkedType);
                SynthWizard.this.addForbiddenName(checkedType);
                SynthWizard.this.setAllowedNames();
            } else {
                SynthWizard.this.addAllowedName(checkedType);
                SynthWizard.this.removeForbiddenName(checkedType);
                SynthWizard.this.setAllowedNames(checkedType);
            }
            Object3DGraphController controller = ((AbstractDesigner)SynthWizard.this.application).getGraphController();
            SynthWizard.this.tree = controller.getGraph().getTree(SynthWizard.this.allowedNames, SynthWizard.this.forbiddenNames);
            SynthWizard.this.treeList = new JList(SynthWizard.this.tree);
            SynthWizard.this.treeList.addListSelectionListener(new SelectionListener());
            SynthWizard.this.treePanel.remove(SynthWizard.this.treeScroll);
            SynthWizard.this.treeScroll = new JScrollPane(SynthWizard.this.treeList);
            SynthWizard.this.treePanel.add(SynthWizard.this.treeScroll);
            SynthWizard.this.frame.pack();
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SynthWizard.this.frame.setVisible(false);
            SynthWizard.this.frame = null;
            SynthWizard.this.finished = true;
        }
    }
}

