/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;

public class ViewTreeWizard
implements GeneralWizard {
    public static final String FRAME_TITLE = "Tree";
    private CommandApplication application;
    private int defaultWidth = 400;
    private int defaultHeight = 300;
    private JList list = new JList();
    private JPanel queryPanel;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private boolean finished = false;
    private Object3DGraphController graphController;
    private JFrame frame;
    private JPanel simpleQueryPanel;
    private JPanel advancedQueryPanel;
    private ListWriter writer = new ListWriter();

    public ViewTreeWizard(CommandApplication application) {
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ViewTreeWizard.this.finished = true;
            }
        });
        this.setupQueryPanels();
        this.queryPanel = new JPanel();
        this.queryPanel.setLayout(new BoxLayout(this.queryPanel, 1));
        JPanel modePanel = new JPanel();
        modePanel.add(new JLabel("Mode:"));
        ButtonGroup modeButtons = new ButtonGroup();
        JRadioButton simpleButton = new JRadioButton("Simple");
        simpleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewTreeWizard.this.installSimpleQueryPanel();
            }
        });
        JRadioButton advancedButton = new JRadioButton("Advanced");
        advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewTreeWizard.this.installAdvancedQueryPanel();
            }
        });
        modeButtons.add(simpleButton);
        modeButtons.add(advancedButton);
        modeButtons.setSelected(simpleButton.getModel(), true);
        modePanel.add(simpleButton);
        modePanel.add(advancedButton);
        this.queryPanel.add((Component)modePanel, 0);
        this.queryPanel.add((Component)new JSeparator(0), 1);
        this.queryPanel.add((Component)this.simpleQueryPanel, 2);
        this.queryPanel.add((Component)new JSeparator(0), 3);
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewTreeWizard.this.frame.setVisible(false);
                ViewTreeWizard.this.frame.dispose();
            }
        });
        close.setAlignmentX(0.5f);
        this.queryPanel.add(Box.createVerticalStrut(5), 4);
        this.queryPanel.add((Component)close, 5);
        JSplitPane splitPane = new JSplitPane(1, this.queryPanel, new JScrollPane(this.list));
        this.frame.add(splitPane);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void installSimpleQueryPanel() {
        this.queryPanel.remove(2);
        this.queryPanel.add((Component)this.simpleQueryPanel, 2);
        this.queryPanel.revalidate();
        this.frame.pack();
        this.frame.repaint();
    }

    private void installAdvancedQueryPanel() {
        this.queryPanel.remove(2);
        this.queryPanel.add((Component)this.advancedQueryPanel, 2);
        this.queryPanel.revalidate();
        this.frame.pack();
        this.frame.repaint();
    }

    private void setupQueryPanels() {
        this.simpleQueryPanel = new JPanel();
        this.simpleQueryPanel.setPreferredSize(new Dimension(this.defaultWidth, this.defaultHeight));
        this.simpleQueryPanel.setLayout(new BoxLayout(this.simpleQueryPanel, 1));
        ButtonGroup group = new ButtonGroup();
        JRadioButton all = new JRadioButton("All");
        final JRadioButton strands = new JRadioButton("Strands");
        final JRadioButton atoms = new JRadioButton("Atoms");
        final JRadioButton helixends = new JRadioButton("Helix Ends");
        final JRadioButton residues = new JRadioButton("Residues");
        final JRadioButton junctions = new JRadioButton("Junctions");
        final JRadioButton kissingLoops = new JRadioButton("Kissing Loops");
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet<String> allowedNames = new HashSet<String>();
                if (e.getSource() == atoms) {
                    allowedNames.add("Atom3D");
                } else if (e.getSource() == strands) {
                    allowedNames.add("RnaStrand");
                } else if (e.getSource() == helixends) {
                    allowedNames.add("BranchDescriptor3D");
                } else if (e.getSource() == residues) {
                    allowedNames.add("Nucleotide3D");
                } else if (e.getSource() == junctions) {
                    allowedNames.add("StrandJunction3D");
                } else if (e.getSource() == kissingLoops) {
                    allowedNames.add("KissingLoop3D");
                }
                ViewTreeWizard.this.writer.clear();
                PrintStream ps = new PrintStream(ViewTreeWizard.this.writer);
                ViewTreeWizard.this.graphController.getGraph().printTree(ps, allowedNames, null);
                ViewTreeWizard.this.list.setModel(new AbstractListModel(){
                    private String[] objects;
                    {
                        this.objects = ViewTreeWizard.this.writer.getLines();
                    }

                    @Override
                    public Object getElementAt(int index) {
                        return this.objects[index];
                    }

                    @Override
                    public int getSize() {
                        return this.objects.length;
                    }
                });
                ViewTreeWizard.this.list.revalidate();
            }
        };
        all.addActionListener(listener);
        strands.addActionListener(listener);
        atoms.addActionListener(listener);
        helixends.addActionListener(listener);
        residues.addActionListener(listener);
        junctions.addActionListener(listener);
        kissingLoops.addActionListener(listener);
        all.setAlignmentX(0.0f);
        strands.setAlignmentX(0.0f);
        atoms.setAlignmentX(0.0f);
        helixends.setAlignmentX(0.0f);
        residues.setAlignmentX(0.0f);
        junctions.setAlignmentX(0.0f);
        kissingLoops.setAlignmentX(0.0f);
        group.add(all);
        group.add(strands);
        group.add(atoms);
        group.add(helixends);
        group.add(residues);
        group.add(junctions);
        group.add(kissingLoops);
        this.simpleQueryPanel.add(all);
        this.simpleQueryPanel.add(strands);
        this.simpleQueryPanel.add(atoms);
        this.simpleQueryPanel.add(helixends);
        this.simpleQueryPanel.add(residues);
        this.simpleQueryPanel.add(junctions);
        this.simpleQueryPanel.add(kissingLoops);
        this.advancedQueryPanel = new JPanel();
        this.advancedQueryPanel.setLayout(new BoxLayout(this.advancedQueryPanel, 1));
        this.advancedQueryPanel.add(new JLabel("Allowed:"));
        final JTextField allowedField = new JTextField(20);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(allowedField);
        this.advancedQueryPanel.add(panel);
        this.advancedQueryPanel.add(Box.createVerticalStrut(20));
        this.advancedQueryPanel.add(new JLabel("Forbidden:"));
        final JTextField forbiddenField = new JTextField(20);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(forbiddenField);
        this.advancedQueryPanel.add(panel);
        this.advancedQueryPanel.add(Box.createVerticalStrut(20));
        this.advancedQueryPanel.add(new JLabel("Name:"));
        final JTextField nameField = new JTextField(20);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(nameField);
        this.advancedQueryPanel.add(panel);
        JButton advancedSubmit = new JButton("Submit");
        listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = null;
                HashSet<String> allowedArray = new HashSet<String>();
                HashSet<String> forbiddenArray = new HashSet<String>();
                if (!allowedField.getText().equals("")) {
                    String[] allowedArrayRaw = allowedField.getText().trim().split(",");
                    for (int i = 0; i < allowedArrayRaw.length; ++i) {
                        allowedArray.add(allowedArrayRaw[i]);
                    }
                    allowedField.setText("");
                } else if (!forbiddenField.getText().equals("")) {
                    String[] forbiddenArrayRaw = forbiddenField.getText().trim().split(",");
                    for (int i = 0; i < forbiddenArrayRaw.length; ++i) {
                        forbiddenArray.add(forbiddenArrayRaw[i]);
                    }
                    forbiddenField.setText("");
                } else if (!nameField.getText().equals("")) {
                    name = nameField.getText();
                    nameField.setText("");
                }
                ViewTreeWizard.this.writer.clear();
                PrintStream ps = new PrintStream(ViewTreeWizard.this.writer);
                if (name == null) {
                    ViewTreeWizard.this.graphController.getGraph().printTree(ps, allowedArray, forbiddenArray);
                } else {
                    ViewTreeWizard.this.graphController.getGraph().printTree(ps, name, allowedArray, forbiddenArray);
                }
                ViewTreeWizard.this.list.setModel(new AbstractListModel(){
                    private String[] objects;
                    {
                        this.objects = ViewTreeWizard.this.writer.getLines();
                    }

                    @Override
                    public Object getElementAt(int index) {
                        return this.objects[index];
                    }

                    @Override
                    public int getSize() {
                        return this.objects.length;
                    }
                });
                ViewTreeWizard.this.list.revalidate();
            }
        };
        advancedSubmit.addActionListener(listener);
        advancedSubmit.setAlignmentX(0.0f);
        this.advancedQueryPanel.add(Box.createVerticalStrut(20));
        this.advancedQueryPanel.add(advancedSubmit);
        this.advancedQueryPanel.add(Box.createVerticalStrut(5));
    }

    private class ListWriter
    extends OutputStream {
        private StringBuffer buffer = new StringBuffer();

        private ListWriter() {
        }

        @Override
        public void write(int b) {
            this.buffer.append((char)b);
        }

        public void clear() {
            this.buffer = new StringBuffer();
        }

        public String getString() {
            return this.buffer.toString();
        }

        public String[] getLines() {
            StringTokenizer tokenizer = new StringTokenizer(this.getString(), "\n");
            ArrayList<String> strings = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                strings.add(tokenizer.nextToken());
            }
            String[] ret = new String[strings.size()];
            strings.toArray(ret);
            return ret;
        }
    }
}

