/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import java.util.logging.Logger;
import rnasecondary.Interaction;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureWriter;
import sequence.Residue;
import sequence.Sequence;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;

public class SecondaryStructureBracketWriter
implements SecondaryStructureWriter {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final char NO_BASE_PAIR_CHAR = '.';
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean writeSequenceMode = true;

    public SecondaryStructureBracketWriter() {
    }

    public SecondaryStructureBracketWriter(boolean writeSequenceMode) {
        this.writeSequenceMode = writeSequenceMode;
    }

    private String writeSequence(SecondaryStructure structure, int seqId) {
        Sequence sequence = structure.getSequence(seqId);
        String result = sequence.sequenceString();
        return result;
    }

    public static String sequenceFullName(Sequence seq) {
        String result = seq.getName();
        if (seq.getParentObject() instanceof Object3D) {
            Object3D parent = (Object3D)seq.getParentObject();
            result = Object3DTools.getFullName(parent) + "." + result;
        }
        return result;
    }

    public static String sequenceParentName(Sequence seq) {
        String result = seq.getName();
        if (seq.getParentObject() instanceof Object3D) {
            Object3D parent = (Object3D)seq.getParentObject();
            result = parent.getName() + "." + result;
        }
        return result;
    }

    private int findSequence(Residue res, SecondaryStructure structure) {
        assert (false);
        return -1;
    }

    private void addInteraction(Interaction interaction, Interaction[][] interactionArray, SecondaryStructure structure) {
        Residue res1 = interaction.getResidue1();
        Residue res2 = interaction.getResidue2();
        assert (res1 != null);
        assert (res2 != null);
        int seqId1 = this.findSequence(res1, structure);
        int seqId2 = this.findSequence(res2, structure);
        if (seqId1 >= 0 && seqId2 >= 0) {
            log.fine("Adding interaction(1): " + seqId1 + " " + res1.getPos() + " " + interaction);
            log.fine("Adding interaction(2): " + seqId2 + " " + res2.getPos() + " " + interaction);
            interactionArray[seqId1][res1.getPos()] = interaction;
            interactionArray[seqId2][res2.getPos()] = interaction;
        } else {
            log.warning("could not find: " + res1 + " " + res2);
            for (int i = 0; i < structure.getSequenceCount(); ++i) {
                log.fine("" + (i + 1) + " : " + structure.getSequence(i));
                log.fine(SecondaryStructureBracketWriter.sequenceParentName(structure.getSequence(i)));
            }
        }
    }

    private char incChar(char c) {
        int n = c;
        return (char)(++n);
    }

    private char decChar(char c) {
        int n = c;
        return (char)(--n);
    }

    private void generateCharArray(char[][] charArray, Interaction[][] interactionArray, SecondaryStructure structure) {
        char interactionChar = 'A';
        interactionChar = this.decChar(interactionChar);
        for (int i = 0; i < interactionArray.length; ++i) {
            for (int j = 0; j < interactionArray[i].length; ++j) {
                Interaction interaction = interactionArray[i][j];
                if (interaction == null) {
                    charArray[i][j] = 46;
                    continue;
                }
                Residue res1 = interaction.getResidue1();
                Residue res2 = interaction.getResidue2();
                int pos1 = res1.getPos();
                int pos2 = res2.getPos();
                if (interaction.isIntraSequence()) {
                    if (pos1 < pos2) {
                        charArray[i][pos1] = 40;
                        charArray[i][pos2] = 41;
                        continue;
                    }
                    if (pos1 <= pos2) continue;
                    charArray[i][pos1] = 41;
                    charArray[i][pos2] = 40;
                    continue;
                }
                int seqId1 = this.findSequence(res1, structure);
                int seqId2 = this.findSequence(res2, structure);
                boolean newStemMode = true;
                if (pos1 > 0 && pos2 + 1 < charArray[seqId2].length && charArray[seqId1][pos1 - 1] == charArray[seqId2][pos2 + 1]) {
                    newStemMode = false;
                }
                if (newStemMode) {
                    interactionChar = this.incChar(interactionChar);
                }
                charArray[seqId1][pos1] = interactionChar;
                charArray[seqId2][pos2] = interactionChar;
            }
        }
    }

    @Override
    public String writeString(SecondaryStructure structure) {
        int i;
        Interaction[][] interactionArray = new Interaction[structure.getSequenceCount()][0];
        char[][] charArray = new char[structure.getSequenceCount()][0];
        for (i = 0; i < structure.getSequenceCount(); ++i) {
            interactionArray[i] = new Interaction[structure.getSequence(i).size()];
            charArray[i] = new char[structure.getSequence(i).size()];
        }
        for (i = 0; i < structure.getInteractionCount(); ++i) {
            Interaction interaction = structure.getInteraction(i);
            if (interaction.getInteractionType().getSubTypeId() == 6) continue;
            this.addInteraction(interaction, interactionArray, structure);
        }
        this.generateCharArray(charArray, interactionArray, structure);
        String result = "";
        for (int i2 = 0; i2 < structure.getSequenceCount(); ++i2) {
            if (this.writeSequenceMode) {
                result = result + this.writeSequence(structure, i2) + NEWLINE;
            }
            result = result + new String(charArray[i2]) + NEWLINE;
        }
        return result;
    }
}

