/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import java.awt.geom.Point2D;
import java.text.NumberFormat;
import rnadesign.rnacontrol.CameraController;
import tools3d.Camera;
import tools3d.CameraTools;
import tools3d.Matrix3D;
import tools3d.Matrix3DTools;
import tools3d.SimpleCamera;
import tools3d.Vector3D;

public class SimpleCameraController
implements CameraController {
    public static final String NEWLINE = System.getProperty("line.separator");
    private Camera camera;
    private Vector3D interest;
    private static final Vector3D zFixed = new Vector3D(0.0, 0.0, 1.0);
    private NumberFormat nf = NumberFormat.getInstance();

    public SimpleCameraController() {
        this.camera = new SimpleCamera();
        this.interest = new Vector3D(0.0, 0.0, 0.0);
        this.nf.setMaximumFractionDigits(1);
        this.nf.setMinimumFractionDigits(1);
    }

    public SimpleCameraController(Camera camera) {
        this.camera = camera;
        this.interest = new Vector3D(0.0, 0.0, 0.0);
        this.nf.setMaximumFractionDigits(1);
        this.nf.setMinimumFractionDigits(1);
    }

    @Override
    public void copy(CameraController other) {
        if (other instanceof SimpleCameraController) {
            this.camera.copy(((SimpleCameraController)other).camera);
            this.interest.copy(((SimpleCameraController)other).interest);
            this.nf = ((SimpleCameraController)other).nf;
        }
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public Vector3D getViewDirection() {
        return this.camera.getViewDirection();
    }

    public Vector3D getInterest() {
        return this.interest;
    }

    @Override
    public double getZoom() {
        return this.camera.getZoom();
    }

    @Override
    public void moveCamera(double x, double y) {
        this.camera.translate(x, y);
    }

    @Override
    public Point2D project(Vector3D point) {
        return this.camera.project(point);
    }

    public void rotateCamera(Vector3D rotVec, double angle) {
        Matrix3D orient = this.camera.getOrientation();
        Matrix3D rot = Matrix3DTools.rotationMatrix(rotVec, angle);
        Vector3D pos = this.camera.getPosition();
        pos.copy(rot.multiply(pos));
        Vector3D x = orient.getXRow();
        Vector3D y = orient.getYRow();
        Vector3D z = orient.getZRow();
        x.copy(rot.multiply(x));
        y.copy(rot.multiply(y));
        z.copy(rot.multiply(z));
        this.camera.setOrientation(orient);
    }

    @Override
    public void rotateCameraNorth(double angle) {
        Vector3D rotVec = this.camera.getOrientation().getXRow();
        this.rotateCamera(rotVec, angle);
    }

    @Override
    public void rotateCameraWest(double angle) {
        Vector3D rotVec = this.camera.getOrientation().getYRow();
        this.rotateCamera(rotVec, angle);
    }

    @Override
    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void setInterest(Vector3D interest) {
        this.interest = interest;
    }

    @Override
    public void setOrigin2D(int x, int y) {
        this.camera.setOrigin2D(x, y);
    }

    @Override
    public void tiltCamera(double angle) {
    }

    @Override
    public void updateCameraFromAngles(double theta, double phi, double psi, double dist) {
        CameraTools.updateCameraFromAngles(this.camera, theta, phi, psi, dist, this.interest);
    }

    @Override
    public void setZoom(double zoom) {
        this.camera.setZoom(zoom);
    }
}

