/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ApplicationBugException;
import generaltools.StringTools;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorOptimizer;
import rnadesign.rnamodel.BranchDescriptorOptimizerFactory;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.GeneralPdbWriter;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import rnadesign.rnamodel.SimpleRnaStem3D;
import rnasecondary.SimpleStem;
import sequence.UnknownSymbolException;
import tools3d.CoordinateSystem;
import tools3d.Matrix4D;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class ConnectJunctionTools {
    private static int mcIterMax = 100;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    static int computeBestStemLength(BranchDescriptor3D branch1, BranchDescriptor3D branch2) {
        HelixParameters prm1 = branch1.getHelixParameters();
        HelixParameters prm2 = branch2.getHelixParameters();
        Vector3D branch1NewBase = branch1.getBasePosition();
        Vector3D branch2NewBase = branch2.getBasePosition();
        double dist = branch1NewBase.distance(branch2NewBase);
        int numPairs = (int)((dist - RnaConstants.HELIX_OFFSET) / RnaConstants.HELIX_RISE + 0.5) - 1;
        assert (numPairs >= 0);
        return numPairs;
    }

    public static Object3DLinkSetBundle generateConnectingStem(BranchDescriptor3D branch1, BranchDescriptor3D branch2, char c1, char c2, String baseName, FitParameters fitParameters, Object3D nucleotideDB, int algorithm, int numPairs) {
        assert (branch1 != branch2);
        assert (branch1.isValid());
        assert (branch2.isValid());
        if (numPairs < 0) {
            numPairs = ConnectJunctionTools.computeBestStemLength(branch1, branch2);
        }
        double angleError = Math.PI - branch1.getDirection().angle(branch2.getDirection());
        assert (angleError >= 0.0);
        if (angleError > fitParameters.getAngleLimit()) {
            log.fine("Aborting generateConnectingStem because of too large branch descriptor angle");
            return null;
        }
        Vector3D avgPos = Vector3D.average(branch1.getPosition(), branch2.getPosition());
        assert (branch1.isValid());
        assert (branch2.isValid());
        Vector3D savedDirection1 = branch1.getDirection();
        Vector3D stemDir = branch2.getBasePosition().minus(branch1.getBasePosition());
        assert (stemDir.lengthSquare() > 0.0);
        stemDir.normalize();
        assert (branch1.isValid());
        assert (branch2.isValid());
        Vector3D basePos = branch1.getBasePosition();
        if (numPairs <= 0) {
            log.fine("Aborting generateConnectingStem because the stem length was estimated to be smaller than one.");
            return null;
        }
        String s1 = "";
        String s2 = "";
        assert (branch1.isValid());
        assert (branch2.isValid());
        s1 = StringTools.stringFromChar(c1, numPairs);
        s2 = StringTools.stringFromChar(c2, numPairs);
        String strand1Name = baseName + "_" + "forw";
        String strand2Name = baseName + "_" + "back";
        String stemName = baseName + "_stem";
        SimpleObject3D resultTree = new SimpleObject3D();
        String setName = baseName + "_root";
        resultTree.setName(setName);
        resultTree.setPosition(avgPos);
        SimpleLinkSet resultLinks = new SimpleLinkSet();
        Vector3D pos1 = new Vector3D(0.0, 0.0, 0.0);
        Vector3D dir1 = new Vector3D(0.0, 0.0, 1.0);
        Vector3D pos2 = new Vector3D(10.0, 0.0, 0.0);
        Vector3D dir2 = new Vector3D(1.0, 0.0, 0.0);
        Object3DLinkSetBundle strand1Bundle = null;
        Object3DLinkSetBundle strand2Bundle = null;
        assert (branch1.isValid());
        assert (branch2.isValid());
        try {
            strand1Bundle = Rna3DTools.generateSimpleRnaStrand(strand1Name, s1, pos1, dir1);
            strand2Bundle = Rna3DTools.generateSimpleRnaStrand(strand2Name, s2, pos2, dir2);
        }
        catch (UnknownSymbolException e) {
            log.warning("Internal error in ConnectJunctionTools.generateConnectingStem");
            System.exit(0);
        }
        assert (strand1Bundle.getObject3D() instanceof RnaStrand);
        assert (strand2Bundle.getObject3D() instanceof RnaStrand);
        RnaStrand strand1 = (RnaStrand)strand1Bundle.getObject3D();
        RnaStrand strand2 = (RnaStrand)strand2Bundle.getObject3D();
        resultLinks.merge(strand1Bundle.getLinks());
        resultLinks.merge(strand2Bundle.getLinks());
        assert (branch1.isValid());
        assert (branch2.isValid());
        Object3DLinkSetBundle stemBundle = null;
        BranchDescriptorOptimizer branchDescriptorOptimizer = BranchDescriptorOptimizerFactory.generate(algorithm, fitParameters);
        log.fine("Using optimizer " + branchDescriptorOptimizer.getClassName() + " for interpolating stem!");
        assert (branchDescriptorOptimizer != null);
        stemBundle = ConnectJunctionTools.generateInterpolatedRnaStem3D(strand1, strand2, 0, numPairs - 1, numPairs, 1, true, stemName, branch1, branch2, nucleotideDB, branchDescriptorOptimizer);
        if (stemBundle == null) {
            log.fine("Stem could not be generated!");
            return null;
        }
        assert (stemBundle.getObject3D().size() > 0 && stemBundle.getLinks().size() > 0);
        resultLinks.merge(stemBundle.getLinks());
        resultTree.insertChild(strand1Bundle.getObject3D());
        resultTree.insertChild(strand2Bundle.getObject3D());
        resultTree.insertChild(stemBundle.getObject3D());
        return new SimpleObject3DLinkSetBundle(resultTree, resultLinks);
    }

    public static Object3DLinkSetBundle generateIdealStem(BranchDescriptor3D branch1, char c1, char c2, String baseName, Object3D nucleotideDB, int numPairs) {
        assert (branch1.getCoordinateSystem().isValid());
        Vector3D stemDir = branch1.getDirection();
        assert (stemDir.lengthSquare() > 0.0);
        stemDir.normalize();
        Vector3D basePos = branch1.getBasePosition();
        if (numPairs <= 0) {
            log.fine("Aborting generateConnectingStem because the stem length was estimated to be smaller than one.");
            return null;
        }
        String s1 = "";
        String s2 = "";
        s1 = StringTools.stringFromChar(c1, numPairs);
        s2 = StringTools.stringFromChar(c2, numPairs);
        String strand1Name = baseName + "_" + "forw";
        String strand2Name = baseName + "_" + "back";
        String stemName = baseName + "_stem";
        SimpleObject3D resultTree = new SimpleObject3D();
        String setName = baseName + "_root";
        resultTree.setName(setName);
        resultTree.setPosition(branch1.getPosition());
        SimpleLinkSet resultLinks = new SimpleLinkSet();
        Vector3D pos1 = new Vector3D(0.0, 0.0, 0.0);
        Vector3D dir1 = new Vector3D(0.0, 0.0, 1.0);
        Vector3D pos2 = new Vector3D(10.0, 0.0, 0.0);
        Vector3D dir2 = new Vector3D(1.0, 0.0, 0.0);
        Object3DLinkSetBundle strand1Bundle = null;
        Object3DLinkSetBundle strand2Bundle = null;
        try {
            strand1Bundle = Rna3DTools.generateSimpleRnaStrand(strand1Name, s1, pos1, dir1);
            strand2Bundle = Rna3DTools.generateSimpleRnaStrand(strand2Name, s2, pos2, dir2);
        }
        catch (UnknownSymbolException e) {
            log.warning("Internal error in ConnectJunctionTools.generateConnectingStem");
            System.exit(0);
        }
        assert (strand1Bundle.getObject3D() instanceof RnaStrand);
        assert (strand2Bundle.getObject3D() instanceof RnaStrand);
        RnaStrand strand1 = (RnaStrand)strand1Bundle.getObject3D();
        RnaStrand strand2 = (RnaStrand)strand2Bundle.getObject3D();
        resultLinks.merge(strand1Bundle.getLinks());
        resultLinks.merge(strand2Bundle.getLinks());
        Object3DLinkSetBundle stemBundle = null;
        boolean setEqualMode = true;
        int startPos = 0;
        int stopPos = numPairs - 1;
        int helixOffset = 0;
        stemBundle = Rna3DTools.generateRnaStem3D(strand1, strand2, startPos, stopPos, numPairs, helixOffset, setEqualMode, stemName, branch1, nucleotideDB);
        CoordinateSystem cs = branch1.getCoordinateSystem();
        SimpleBranchDescriptor3D br1 = new SimpleBranchDescriptor3D(strand1, strand2, startPos, stopPos, cs);
        Matrix4D m2 = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(cs.generateMatrix4D(), numPairs);
        CoordinateSystem3D cs2 = new CoordinateSystem3D(m2);
        SimpleBranchDescriptor3D br2 = new SimpleBranchDescriptor3D(strand2, strand1, startPos, stopPos, cs2);
        if (stemBundle == null) {
            log.fine("Stem could not be generated!");
            return null;
        }
        assert (stemBundle.getObject3D().size() > 0 && stemBundle.getLinks().size() > 0);
        resultLinks.merge(stemBundle.getLinks());
        resultTree.insertChild(strand1Bundle.getObject3D());
        resultTree.insertChild(strand2Bundle.getObject3D());
        resultTree.insertChild(stemBundle.getObject3D());
        resultTree.insertChild(br1);
        resultTree.insertChild(br2);
        return new SimpleObject3DLinkSetBundle(resultTree, resultLinks);
    }

    public static Object3DLinkSetBundle generateIdealStem(CoordinateSystem3D cs, HelixParameters prm, char c1, char c2, String baseName, Object3D nucleotideDB, int numPairs) {
        if (prm == null) {
            prm = new HelixParameters();
        }
        Vector3D stemDir = cs.getZ();
        assert (stemDir.lengthSquare() > 0.0);
        stemDir.normalize();
        Vector3D basePos = cs.getPosition();
        if (numPairs <= 0) {
            log.fine("Aborting generateConnectingStem because the stem length was estimated to be smaller than one.");
            return null;
        }
        String s1 = "";
        String s2 = "";
        s1 = StringTools.stringFromChar(c1, numPairs);
        s2 = StringTools.stringFromChar(c2, numPairs);
        String strand1Name = baseName + "_" + "forw";
        String strand2Name = baseName + "_" + "back";
        String stemName = baseName + "_stem";
        SimpleObject3D resultTree = new SimpleObject3D();
        String setName = baseName + "_root";
        resultTree.setName(setName);
        resultTree.setPosition(cs.getPosition());
        SimpleLinkSet resultLinks = new SimpleLinkSet();
        Vector3D pos1 = new Vector3D(0.0, 0.0, 0.0);
        Vector3D dir1 = new Vector3D(0.0, 0.0, 1.0);
        Vector3D pos2 = new Vector3D(10.0, 0.0, 0.0);
        Vector3D dir2 = new Vector3D(1.0, 0.0, 0.0);
        Object3DLinkSetBundle strand1Bundle = null;
        Object3DLinkSetBundle strand2Bundle = null;
        try {
            strand1Bundle = Rna3DTools.generateSimpleRnaStrand(strand1Name, s1, pos1, dir1);
            strand2Bundle = Rna3DTools.generateSimpleRnaStrand(strand2Name, s2, pos2, dir2);
        }
        catch (UnknownSymbolException e) {
            log.warning("Internal error in ConnectJunctionTools.generateConnectingStem");
            System.exit(0);
        }
        assert (strand1Bundle.getObject3D() instanceof RnaStrand);
        assert (strand2Bundle.getObject3D() instanceof RnaStrand);
        RnaStrand strand1 = (RnaStrand)strand1Bundle.getObject3D();
        RnaStrand strand2 = (RnaStrand)strand2Bundle.getObject3D();
        resultLinks.merge(strand1Bundle.getLinks());
        resultLinks.merge(strand2Bundle.getLinks());
        Object3DLinkSetBundle stemBundle = null;
        boolean setEqualMode = true;
        int startPos = 0;
        int stopPos = numPairs - 1;
        int helixOffset = 0;
        SimpleBranchDescriptor3D branch1 = new SimpleBranchDescriptor3D(strand1, strand2, startPos, stopPos, cs);
        Matrix4D m2 = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(cs.generateMatrix4D(), numPairs);
        CoordinateSystem3D cs2 = new CoordinateSystem3D(m2);
        SimpleBranchDescriptor3D branch2 = new SimpleBranchDescriptor3D(strand2, strand1, startPos, stopPos, cs2);
        branch1.setHelixParameters(prm);
        branch2.setHelixParameters(prm);
        stemBundle = Rna3DTools.generateRnaStem3D(strand1, strand2, startPos, stopPos, numPairs, helixOffset, setEqualMode, stemName, branch1, nucleotideDB);
        if (stemBundle == null) {
            log.fine("Stem could not be generated!");
            return null;
        }
        assert (stemBundle.getObject3D().size() > 0 && stemBundle.getLinks().size() > 0);
        resultLinks.merge(stemBundle.getLinks());
        resultTree.insertChild(strand1Bundle.getObject3D());
        resultTree.insertChild(strand2Bundle.getObject3D());
        resultTree.insertChild(stemBundle.getObject3D());
        resultTree.insertChild(branch1);
        resultTree.insertChild(branch2);
        return new SimpleObject3DLinkSetBundle(resultTree, resultLinks);
    }

    @Test(groups={"new"})
    public void testGenerateIdealStem() {
        String methodName = "testGenerateIdealStem";
        String outputPdbName = methodName + ".pdb";
        SimpleBranchDescriptor3D bd = new SimpleBranchDescriptor3D(new CoordinateSystem3D(Vector3D.ZVEC));
        assert (bd.getCoordinateSystem().isValid());
        int numPairs = 10;
        String base = "bd";
        String nucleotideDBFileName = "../resources/nucleotidesDB.pdb";
        try {
            FileInputStream fis = new FileInputStream(nucleotideDBFileName);
            Object3D nucleotideDB = NucleotideDBTools.readNucleotideDB(fis);
            fis.close();
            Object3DLinkSetBundle result = ConnectJunctionTools.generateIdealStem(bd, 'C', 'G', base, nucleotideDB, numPairs);
            System.out.println("Generated stem");
            Object3DTools.printTree(System.out, result.getObject3D());
            Object3D resultRoot = result.getObject3D();
            assert (resultRoot.getIndexOfChild(base + "_back") >= 0);
            assert (resultRoot.getIndexOfChild(base + "_forw") >= 0);
            assert (resultRoot.getChild(base + "_back").size() == numPairs);
            assert (resultRoot.getChild(base + "_forw").size() == numPairs);
            FileOutputStream fos = new FileOutputStream(outputPdbName);
            GeneralPdbWriter writer = new GeneralPdbWriter();
            writer.write((OutputStream)fos, result.getObject3D());
            fos.close();
        }
        catch (IOException ioe) {
            System.out.println("Error in file " + nucleotideDBFileName + " : " + ioe.getMessage());
        }
    }

    @Test(groups={"new"})
    public void testGenerateIdealStem2() {
        String methodName = "testGenerateIdealStem2";
        String outputPdbName = methodName + ".pdb";
        CoordinateSystem3D cs = new CoordinateSystem3D(Vector3D.ZVEC);
        int numPairs = 10;
        String base = "bd";
        String nucleotideDBFileName = "../resources/nucleotidesDB.pdb";
        try {
            FileInputStream fis = new FileInputStream(nucleotideDBFileName);
            Object3D nucleotideDB = NucleotideDBTools.readNucleotideDB(fis);
            fis.close();
            Object3DLinkSetBundle result = ConnectJunctionTools.generateIdealStem(cs, null, 'A', 'U', base, nucleotideDB, numPairs);
            System.out.println("Generated stem");
            Object3DTools.printTree(System.out, result.getObject3D());
            Object3D resultRoot = result.getObject3D();
            assert (resultRoot.getIndexOfChild(base + "_back") >= 0);
            assert (resultRoot.getIndexOfChild(base + "_forw") >= 0);
            assert (resultRoot.getChild(base + "_back").size() == numPairs);
            assert (resultRoot.getChild(base + "_forw").size() == numPairs);
            FileOutputStream fos = new FileOutputStream(outputPdbName);
            GeneralPdbWriter writer = new GeneralPdbWriter();
            writer.write((OutputStream)fos, result.getObject3D());
            fos.close();
        }
        catch (IOException ioe) {
            System.out.println("Error in file " + nucleotideDBFileName + " : " + ioe.getMessage());
        }
    }

    public static Object3DLinkSetBundle generateInterpolatedRnaStem3D(RnaStrand strand1, RnaStrand strand2, int startPos, int stopPos, int length, int helixOffset, boolean setEqualMode, String stemName, BranchDescriptor3D branch1, BranchDescriptor3D branch2, Object3D nucleotideDB, BranchDescriptorOptimizer branchDescriptorOptimizer) {
        assert (branch1.isValid());
        assert (branch2.isValid());
        assert (branchDescriptorOptimizer != null);
        SimpleStem stem = new SimpleStem(startPos, stopPos, length, strand1, strand2);
        if (!stem.isValid()) {
            throw new ApplicationBugException("Invalid stem parameters in RNA3DTools.generateRnaStem3D!");
        }
        SimpleRnaStem3D stem3D = new SimpleRnaStem3D(stem);
        log.fine("Starting optimizing branch descriptors : branch1: " + branch1.getName() + " branch2: " + branch2.getName());
        assert (branch1.isValid());
        assert (branch2.isValid());
        BranchDescriptor3D branch = null;
        try {
            branch = branchDescriptorOptimizer.optimize(stem3D, branch1, branch2);
        }
        catch (FittingException fe) {
            log.fine("Branch Descriptor optimizer " + branchDescriptorOptimizer.getClassName() + " could not find suitable solution!");
            return null;
        }
        if (branch == null) {
            log.fine("Branch Descriptor optimizer " + branchDescriptorOptimizer.getClassName() + " could not find suitable solution!");
            return null;
        }
        Properties bProp = branch.getProperties();
        assert (bProp != null);
        String fitProperty = bProp.getProperty("fit_score");
        assert (fitProperty != null && (double)fitProperty.length() > 0.0);
        log.fine("Resulting optimized branch descriptors : branch: " + branch.getName() + " fit_score: " + fitProperty);
        Object3DLinkSetBundle resultBundle = Rna3DTools.generateRnaStem3D(strand1, strand2, startPos, stopPos, length, 0, setEqualMode, stemName, branch, nucleotideDB);
        Object3D resultTree = resultBundle.getObject3D();
        Object3DSet resultStems = Object3DTools.collectByClassName(resultTree, "RnaStem3D");
        assert (resultStems.size() == 1);
        Object3D resultStem = resultStems.get(0);
        Properties prop = resultStem.getProperties();
        if (prop == null) {
            prop = new Properties();
        }
        prop.setProperty("fit_score", fitProperty);
        resultStem.setProperties(prop);
        return resultBundle;
    }

    public static Object3DLinkSetBundle generateIdealRnaStem3D(RnaStrand strand1, RnaStrand strand2, int startPos, int stopPos, int length, int helixOffset, boolean setEqualMode, String stemName, BranchDescriptor3D branch1, Object3D nucleotideDB) {
        assert (branch1.getCoordinateSystem().isValid());
        SimpleStem stem = new SimpleStem(startPos, stopPos, length, strand1, strand2);
        if (!stem.isValid()) {
            throw new ApplicationBugException("Invalid stem parameters in RNA3DTools.generateRnaStem3D!");
        }
        SimpleRnaStem3D stem3D = new SimpleRnaStem3D(stem);
        log.fine("Starting optimizing branch descriptors : branch1: " + branch1.getName());
        Object3DLinkSetBundle resultBundle = Rna3DTools.generateRnaStem3D(strand1, strand2, startPos, stopPos, length, 0, setEqualMode, stemName, branch1, nucleotideDB);
        Object3D resultTree = resultBundle.getObject3D();
        Object3DSet resultStems = Object3DTools.collectByClassName(resultTree, "RnaStem3D");
        assert (resultStems.size() == 1);
        Object3D resultStem = resultStems.get(0);
        Properties prop = resultStem.getProperties();
        if (prop == null) {
            prop = new Properties();
        }
        resultStem.setProperties(prop);
        return resultBundle;
    }
}

