/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.StringTools;
import rnadesign.rnamodel.DBElementDescriptor;

public class DBElementConnectionDescriptor {
    private DBElementDescriptor descriptor1;
    private DBElementDescriptor descriptor2;
    private String helixendName1;
    private String helixendName2;
    private int basePairCount;
    private int delayStage = 0;

    private void init(DBElementDescriptor descriptor1, DBElementDescriptor descriptor2, String helixendName1, String helixendName2, int basePairCount) {
        if (this.compareTo(descriptor1, helixendName1, descriptor2, helixendName2) > 0) {
            this.init(descriptor2, descriptor1, helixendName2, helixendName1, basePairCount);
        } else {
            this.descriptor1 = descriptor1;
            this.descriptor2 = descriptor2;
            this.helixendName1 = helixendName1;
            this.helixendName2 = helixendName2;
            this.basePairCount = basePairCount;
        }
        assert (this.validate());
    }

    private int compareTo(DBElementDescriptor descriptor1, String helixendName1, DBElementDescriptor descriptor2, String helixendName2) {
        int comp1 = descriptor1.compareTo(descriptor2);
        if (comp1 != 0) {
            return comp1;
        }
        int comp2 = helixendName1.compareTo(helixendName2);
        return comp2;
    }

    public DBElementConnectionDescriptor(DBElementDescriptor descriptor1, DBElementDescriptor descriptor2, String helixendName1, String helixendName2, int basePairCount) {
        this.init(descriptor1, descriptor2, helixendName1, helixendName2, basePairCount);
        assert (this.validate());
    }

    public DBElementConnectionDescriptor(DBElementDescriptor descriptor1, DBElementDescriptor descriptor2, int helixId1, int helixId2, int basePairCount) {
        this(descriptor1, descriptor2, "(hxend)" + (helixId1 + 1), "(hxend)" + (helixId2 + 1), basePairCount);
        assert (this.validate());
    }

    public Object clone() {
        DBElementConnectionDescriptor result = new DBElementConnectionDescriptor((DBElementDescriptor)this.descriptor1.clone(), (DBElementDescriptor)this.descriptor2.clone(), new String(this.helixendName1), new String(this.helixendName2), this.basePairCount);
        result.setDelayStage(this.getDelayStage());
        return result;
    }

    public int getBasePairCount() {
        return this.basePairCount;
    }

    public DBElementDescriptor getDescriptor1() {
        return this.descriptor1;
    }

    public DBElementDescriptor getDescriptor2() {
        return this.descriptor2;
    }

    public int getDelayStage() {
        return this.delayStage;
    }

    public String getHelixendName1() {
        return this.helixendName1;
    }

    public static int getHelixendId(String name) {
        int result = Integer.parseInt(StringTools.getRightDigits(name)) - 1;
        assert (result >= 0);
        return result;
    }

    public int getHelixendId1() {
        return DBElementConnectionDescriptor.getHelixendId(this.helixendName1);
    }

    public String getHelixendName2() {
        return this.helixendName2;
    }

    public int getHelixendId2() {
        return DBElementConnectionDescriptor.getHelixendId(this.helixendName2);
    }

    public void setDelayStage(int delayStage) {
        this.delayStage = delayStage;
    }

    public boolean isSimilar(DBElementConnectionDescriptor other) {
        boolean check2;
        boolean check1;
        boolean bl = check1 = this.descriptor1.isSimilar(this.descriptor1) && this.descriptor2.isSimilar(other.descriptor2) && this.helixendName1.equals(other.helixendName1) && this.helixendName2.equals(other.helixendName2);
        if (check1) {
            return true;
        }
        boolean bl2 = check2 = this.descriptor1.isSimilar(this.descriptor2) && this.descriptor2.isSimilar(other.descriptor1) && this.helixendName1.equals(other.helixendName2) && this.helixendName2.equals(other.helixendName1);
        return check2;
    }

    public boolean equals(Object other) {
        if (other instanceof DBElementConnectionDescriptor) {
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "(DBElementConnectionDescriptor " + this.getDescriptor1() + " " + this.getDescriptor2() + " " + this.getHelixendName1() + " " + this.getHelixendName2() + " " + this.basePairCount + " )";
    }

    public boolean validate() {
        return this.descriptor1 != null && this.descriptor2 != null && this.helixendName1 != null && this.helixendName2 != null && this.basePairCount >= 0 && this.descriptor1.compareTo(this.descriptor2) <= 0;
    }
}

