/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.TestTools;
import graphtools.IntegerList;
import org.testng.annotations.Test;

public class DBElementDescriptor
implements Comparable<DBElementDescriptor> {
    public static final int UNKNOWN_TYPE = 0;
    public static final int JUNCTION_TYPE = 1;
    public static final int KISSING_LOOP_TYPE = 2;
    public static final int PROTEIN_TYPE = 3;
    public static final int RNA_HELIX_TYPE = 4;
    public static final int LIGAND_TYPE = 5;
    private int order;
    private int id;
    private int type;
    private int hash;
    private int descriptorId = 0;

    public DBElementDescriptor() {
        this.order = 2;
        this.id = 0;
        this.type = 1;
        this.descriptorId = 0;
        this.rehash();
    }

    public DBElementDescriptor(int order, int id, int type, int descriptorId) {
        this.order = order;
        this.id = id;
        this.type = type;
        this.descriptorId = descriptorId;
        this.rehash();
    }

    public Object clone() {
        DBElementDescriptor result = new DBElementDescriptor(this.order, this.id, this.type, this.descriptorId);
        return result;
    }

    private IntegerList toIntegerList() {
        IntegerList list = new IntegerList();
        list.add(this.order);
        list.add(this.id);
        list.add(this.type);
        list.add(this.descriptorId);
        return list;
    }

    @Override
    public int compareTo(DBElementDescriptor other) {
        IntegerList l1 = this.toIntegerList();
        IntegerList l2 = other.toIntegerList();
        int result = l1.compareTo(l2);
        assert (result == 0 && this.equals(other) || result != 0 && !this.equals(other));
        return result;
    }

    public int getDescriptorId() {
        return this.descriptorId;
    }

    public int getId() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equalsSlow(Object obj) {
        if (obj instanceof DBElementDescriptor) {
            boolean resultCheck;
            DBElementDescriptor other = (DBElementDescriptor)obj;
            boolean result = this.getId() == other.getId() && this.getOrder() == other.getOrder() && this.getType() == other.getType() && this.getDescriptorId() == other.getDescriptorId();
            boolean bl = resultCheck = this.hashCode() == other.hashCode();
            assert (result == resultCheck);
            return result;
        }
        return false;
    }

    public boolean equivalent(DBElementDescriptor other) {
        return this.getId() == other.getId() && this.getOrder() == other.getOrder() && this.getType() == other.getType();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBElementDescriptor) {
            boolean result;
            boolean bl = result = this.hash == obj.hashCode();
            assert (result == this.equalsSlow(obj));
            return result;
        }
        return false;
    }

    public static String getTypeString(int junctionType) {
        switch (junctionType) {
            case 1: {
                return "j";
            }
            case 2: {
                return "k";
            }
        }
        assert (false);
        return null;
    }

    public static int parseTypeString(String typeString) {
        assert (typeString != null);
        if (typeString.equals("j")) {
            return 1;
        }
        if (typeString.equals("k")) {
            return 2;
        }
        assert (false);
        return 0;
    }

    public static DBElementDescriptor parse(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        String[] words = (s = s.trim()).split(" ");
        if (words.length != 6) {
            return null;
        }
        return new DBElementDescriptor(Integer.parseInt(words[2]), Integer.parseInt(words[3]) - 1, DBElementDescriptor.parseTypeString(words[1]), Integer.parseInt(words[4]));
    }

    public void setDescriptorId(int n) {
        this.descriptorId = n;
        this.rehash();
    }

    public boolean isSimilar(DBElementDescriptor other) {
        return this.type == other.getType() && this.order == other.getOrder() && this.id == other.getId();
    }

    private void rehash() {
        this.hash = this.toStringCore().hashCode();
    }

    public String toStringCore() {
        return "" + DBElementDescriptor.getTypeString(this.type) + " " + this.order + " " + (this.id + 1) + " " + this.descriptorId;
    }

    public String toString() {
        return "(DBElementDescriptor " + this.toStringCore() + " )";
    }

    @Test(groups={"new"})
    void testParseDBElementDescriptor() {
        System.out.println(TestTools.generateMethodHeader("testParseDBElementDescriptor"));
        DBElementDescriptor dbe = new DBElementDescriptor(2, 3, 1, 4);
        String sdbe = dbe.toString();
        System.out.println("String represenatino of DBElementDescriptor (2,3,1,4): " + sdbe);
        DBElementDescriptor dbe2 = DBElementDescriptor.parse(sdbe);
        assert (dbe2.equals(dbe));
        System.out.println(TestTools.generateMethodFooter("testParseDBElementDescriptor"));
    }

    @Test(groups={"new"})
    void testClone() {
        System.out.println(TestTools.generateMethodHeader("DBElemetDescriptor.testClone"));
        DBElementDescriptor dbe = new DBElementDescriptor(2, 3, 1, 4);
        DBElementDescriptor dbe2 = (DBElementDescriptor)dbe.clone();
        assert (dbe2.equals(dbe));
        System.out.println(TestTools.generateMethodFooter("DBElementDescriptor.testClone"));
    }
}

