/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.PropertyTools;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnamodel.BuildingBlockGrower;
import rnadesign.rnamodel.ConnectivityGenerator;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.GeneralPdbWriter;
import rnadesign.rnamodel.GrowConnectivity;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.SmallConnectivityIterator;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import rnadesign.rnamodel.StrandJunctionDBExportTools;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;

public class GrowFramework
implements Runnable {
    public static final String NAME_BASE_SUFFIX = "_fr";
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean buildMode = true;
    private boolean debugMode = true;
    private Properties properties = new Properties();
    private ConnectivityGenerator connGenerator;
    private Exception exception;
    private String rootName = "root";
    private String nameBase = "root";
    private Vector3D startPosition = new Vector3D(0.0, 0.0, 0.0);
    private StrandJunctionDB junctionDB;
    private StrandJunctionDB kissingLoopDB;
    private Object3D nucleotideDB;
    private double ringClosureExportLimit = 15.0;
    private BuildingBlockGrower bestGrower;
    private int exportMax = 100;
    private double[][] vertexFingerprints;
    private double angleTolerance = Math.toRadians(45.0);

    public GrowFramework(ConnectivityGenerator connGenerator, StrandJunctionDB junctionDB, StrandJunctionDB kissingLoopDB, Object3D nucleotideDB, String nameBase) {
        this.connGenerator = connGenerator;
        this.junctionDB = junctionDB;
        this.kissingLoopDB = kissingLoopDB;
        this.nucleotideDB = nucleotideDB;
    }

    public BuildingBlockGrower getBestGrower() {
        return this.bestGrower;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getExportMax() {
        return this.exportMax;
    }

    public boolean isBuildMode() {
        return this.buildMode;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getNameBase() {
        return this.nameBase;
    }

    @Override
    public void run() {
        log.info("Starting GrowFramework.run()...");
        boolean initial = true;
        this.properties = new Properties();
        this.bestGrower = null;
        int writeCount = 0;
        int structureCount = 0;
        this.exception = null;
        this.vertexFingerprints = this.generateAllVertexFingerprints();
        boolean orderCheck = this.verifyOrders();
        if (!orderCheck) {
            this.exception = new RnaModelException("Not all needed building blocks are provided.");
            return;
        }
        SmallConnectivityIterator iter = (SmallConnectivityIterator)this.connGenerator.iterator();
        log.info("Generated connectivity iterator!");
        if (this.debugMode) {
            long count = 1L;
            do {
                System.out.println("Iterated test grow connectivity: " + count++ + " : " + iter.next());
            } while (iter.hasNext());
            System.out.println("Number of iterations in dry run: " + count);
            if (!new BigInteger("" + count).equals(iter.getTotal())) {
                System.out.println("Discrepancy in tried steps and expected steps: tried: " + count + " expected: " + iter.getTotal() + " Don't worry, this might be due to additional checks in the connectivity iterator.");
            }
            iter.reset();
        }
        assert (iter != null);
        int exportCount = 0;
        boolean skip = false;
        do {
            log.info("Start of do loop!");
            skip = false;
            GrowConnectivity conn = iter.getGrowConnectivity();
            log.info("Starting new iteration with connectivity: " + conn);
            if (conn == null) {
                if (initial) {
                    log.info("Could not generate initial connectivity!");
                    continue;
                }
                log.info("Could not generate connectivity!");
                continue;
            }
            assert (conn != null);
            log.info("Trying connectivity: " + conn);
            assert (!conn.isGraphFlag());
            if (this.buildMode) {
                BuildingBlockGrower grower = new BuildingBlockGrower(this.junctionDB, this.kissingLoopDB, this.nucleotideDB);
                grower.setRingClosureExportLimit(this.ringClosureExportLimit);
                String ringClosureExportFileNameBase = this.nameBase + NAME_BASE_SUFFIX;
                try {
                    Properties properties = grower.growBuildingBlocks(conn, this.rootName, this.nameBase, this.startPosition, ringClosureExportFileNameBase);
                    assert (grower.getRoot() != null);
                    log.info("Successfully generated structure from connectivity: " + conn + " : " + properties);
                    ++structureCount;
                    this.bestGrower = grower;
                    if (ringClosureExportFileNameBase != null && ringClosureExportFileNameBase.length() > 0 && !properties.getProperty("ring_count").equals("0")) {
                        String outputFileName = ringClosureExportFileNameBase + "_" + ++writeCount + ".pdb";
                        if (exportCount < this.exportMax) {
                            log.info("Writing connectivity " + conn + " to file: " + outputFileName);
                            GeneralPdbWriter writer = new GeneralPdbWriter();
                            FileOutputStream fos = new FileOutputStream(outputFileName);
                            PropertyTools.writeToPdbRemarks(fos, properties);
                            writer.write((OutputStream)fos, grower.getRoot());
                            fos.close();
                            ++exportCount;
                        } else {
                            log.info("Not exporting structure to file " + outputFileName + " because maximum number of exported structures reached!");
                        }
                    } else {
                        log.info("Not writing built structure to file: " + properties);
                    }
                    System.out.println("Info of root:");
                    System.out.println(grower.getRoot().infoString());
                    for (int c = grower.getRoot().size() - 1; c >= 0; --c) {
                        if (!grower.getRoot().getChild(c).getName().startsWith(this.nameBase + "_")) continue;
                        System.out.println("Removing child node " + grower.getRoot().getChild(c).getFullName());
                        grower.getRoot().removeChild(c);
                    }
                }
                catch (FittingException fe) {
                    log.info("Fitting exception " + fe.getMessage() + " for grow connectivty: " + conn);
                }
                catch (IOException ioe) {
                    log.severe("IO exception in building block growing: " + ioe.getMessage());
                    this.exception = ioe;
                    break;
                }
            }
            log.info("Not building structure!");
            log.info("End of do-loop iteration");
        } while (iter.hasNext() && (skip || iter.next() != null));
        this.properties.setProperty("write_count", "" + writeCount);
        this.properties.setProperty("structure_count", "" + structureCount);
        log.info("Finished GrowFramework.run()...");
    }

    public void setBuildMode(boolean b) {
        this.buildMode = b;
    }

    public void setExportMax(int n) {
        this.exportMax = n;
    }

    public void setRingClosureExportLimit(double limit) {
        this.ringClosureExportLimit = limit;
    }

    public void setNameBase(String s) {
        this.nameBase = s;
    }

    private List<Double> generateFingerprint(Object3D vertex, LinkSet links) {
        LinkSet connLinks = links.findLinks(vertex);
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < connLinks.size(); ++i) {
            Link link1 = connLinks.get(i);
            for (int j = i + 1; j < connLinks.size(); ++j) {
                Link link2 = connLinks.get(j);
                assert (link1.findCommon(link2).size() == 1);
                double ang = link1.angle(link2);
                result.add(ang);
            }
        }
        Collections.sort(result);
        return result;
    }

    private double[] generateVertexFingerprint(Object3D vertex, LinkSet links) {
        LinkSet connLinks = links.findLinks(vertex);
        double[] result = new double[connLinks.size() * (connLinks.size() - 1) / 2];
        int pc = 0;
        for (int i = 0; i < connLinks.size(); ++i) {
            Link link1 = connLinks.get(i);
            for (int j = i + 1; j < connLinks.size(); ++j) {
                Link link2 = connLinks.get(j);
                assert (link1.findCommon(link2).size() == 1);
                double ang = link1.angle(link2);
                assert (pc < result.length);
                result[pc++] = ang;
            }
        }
        assert (pc == result.length);
        Arrays.sort(result);
        return result;
    }

    private double[][] generateAllVertexFingerprints() {
        List<Object3D> vertices = this.connGenerator.getVertices();
        LinkSet links = this.connGenerator.getLinks();
        int n = vertices.size();
        double[][] result = new double[n][0];
        for (int i = 0; i < n; ++i) {
            result[i] = this.generateVertexFingerprint(vertices.get(i), links);
        }
        return result;
    }

    private boolean validateFingerprint(double[] vertexFingerprint, double[] junctionFingerprint, double angleTolerance) {
        assert (vertexFingerprint != null && junctionFingerprint != null);
        if (vertexFingerprint.length != junctionFingerprint.length) {
            return false;
        }
        if (angleTolerance < 0.0) {
            return true;
        }
        for (int i = 0; i < vertexFingerprint.length; ++i) {
            if (!(Math.abs(vertexFingerprint[i] - junctionFingerprint[i]) > angleTolerance)) continue;
            return false;
        }
        return true;
    }

    private boolean validateBuildingBlockAngles(GrowConnectivity conn, int n) {
        DBElementDescriptor dbe = conn.getBuildingBlocks().get(n);
        Object3D vertex = this.connGenerator.getVertices().get(n);
        LinkSet links = this.connGenerator.getLinks();
        double[] vertexFingerprint = this.vertexFingerprints[n];
        StrandJunction3D junction = null;
        if (dbe.getType() == 1) {
            junction = this.junctionDB.getJunction(dbe.getOrder(), dbe.getId());
        } else if (dbe.getType() == 2) {
            junction = this.kissingLoopDB.getJunction(dbe.getOrder(), dbe.getId());
        } else {
            log.severe("Unsupported junction type: " + dbe.getType());
            assert (false);
            System.exit(1);
        }
        double[] junctionFingerprint = StrandJunctionDBExportTools.generateJunctionFingerPrint(junction);
        return this.validateFingerprint(vertexFingerprint, junctionFingerprint, this.angleTolerance);
    }

    private boolean validateBuildingBlockAngles(GrowConnectivity conn) {
        int n = conn.getBuildingBlocks().size();
        for (int i = 0; i < n; ++i) {
            if (this.validateBuildingBlockAngles(conn, i)) continue;
            return false;
        }
        return true;
    }

    private boolean verifyOrders() {
        log.info("starting verifyOrders()...");
        int vertexCount = this.connGenerator.getVertices().size();
        for (int i = 0; i < vertexCount; ++i) {
            int order = this.connGenerator.getVertexOrder(i);
            if (order <= 1 || this.junctionDB.size(order) != 0 || this.kissingLoopDB.size(order) != 0) continue;
            return false;
        }
        log.info("Finished verifyOrders()...");
        return true;
    }
}

