/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionNomenclature;

public class IncomingNomenclature
implements StrandJunctionNomenclature {
    public static final char DEFAULT_CHAIN_CHAR = 'A';
    private String prefix = "j";
    private String prefix2 = "k";
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean loopMode = true;

    private char getChainCharacter(NucleotideStrand strand) {
        assert (strand != null);
        String s1 = strand.getProperty("pdb_chain_char");
        if (s1 != null && s1.length() > 0) {
            return s1.charAt(0);
        }
        assert (strand.getName() != null && strand.getName().length() > 0);
        return strand.getName().charAt(0);
    }

    public boolean isLoopMode() {
        return this.loopMode;
    }

    private String getResidueName(Residue3D residue) {
        int num = residue.getAssignedNumber();
        char c = residue.getSymbol().getCharacter();
        String result = "" + c;
        assert (result.length() == 1);
        result = result + num;
        return result;
    }

    private Residue3D getBranchDescriptorResidue(BranchDescriptor3D b) {
        NucleotideStrand strand = b.getIncomingStrand();
        int index = b.getIncomingIndex() + b.getOffset();
        if (index >= strand.getResidueCount()) {
            index = strand.getResidueCount() - 1;
            this.log.fine("IncomingNomenClature: reduced index because end of strand reached: " + strand.getName() + " " + b.getIncomingIndex() + " " + b.getOffset());
        }
        assert (index < strand.getResidueCount());
        return strand.getResidue3D(index);
    }

    private String generateBranchNomenclature(BranchDescriptor3D b) {
        NucleotideStrand strand = b.getIncomingStrand();
        char c = this.getChainCharacter(strand);
        if (Character.isWhitespace(c)) {
            c = 'A';
        }
        String result = "" + c;
        assert (result.length() == 1);
        result = result + "-" + this.getResidueName(this.getBranchDescriptorResidue(b));
        return result;
    }

    @Override
    public String generateNomenclature(StrandJunction3D junction) {
        int i;
        assert (junction.getBranchCount() == junction.getStrandCount());
        BranchDescriptor3D[] branches = new BranchDescriptor3D[junction.getBranchCount()];
        String[] branchNames = new String[junction.getBranchCount()];
        for (i = 0; i < branches.length; ++i) {
            branches[i] = junction.getBranch(i);
        }
        Arrays.sort(branches, new BranchDescriptorComparator());
        for (i = 0; i < branches.length; ++i) {
            branchNames[i] = this.generateBranchNomenclature(branches[i]);
        }
        StringBuffer buf = new StringBuffer();
        String usedPrefix = this.prefix;
        if (junction.isKissingLoop()) {
            usedPrefix = this.prefix2;
        }
        buf.append(usedPrefix + junction.getBranchCount() + "_");
        buf.append(branchNames[0]);
        for (int i2 = 1; i2 < branchNames.length; ++i2) {
            buf.append("_" + branchNames[i2]);
        }
        return buf.toString();
    }

    public void setLoopMode(boolean b) {
        this.loopMode = b;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private class BranchDescriptorComparator
    implements Comparator<BranchDescriptor3D> {
        private BranchDescriptorComparator() {
        }

        @Override
        public int compare(BranchDescriptor3D b1, BranchDescriptor3D b2) {
            int id2;
            char c2;
            char c1 = IncomingNomenclature.this.getChainCharacter(b1.getIncomingStrand());
            if (c1 < (c2 = IncomingNomenclature.this.getChainCharacter(b2.getIncomingStrand()))) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            Residue3D res1 = IncomingNomenclature.this.getBranchDescriptorResidue(b1);
            Residue3D res2 = IncomingNomenclature.this.getBranchDescriptorResidue(b2);
            int id1 = res1.getAssignedNumber();
            if (id1 < (id2 = res2.getAssignedNumber())) {
                return -1;
            }
            if (id1 > id2) {
                return 1;
            }
            return 0;
        }
    }
}

