/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.DataFormatException;
import rnadesign.rnamodel.JunctionHashGenerator;
import rnadesign.rnamodel.JunctionScanOutputParser;
import tools3d.Matrix4D;
import tools3d.objects3d.CoordinateSystem3D;

class JunctionHashGeneratorTools {
    JunctionHashGeneratorTools() {
    }

    public static double scoreJunctionSimilarity(List<CoordinateSystem3D> orientations1, List<CoordinateSystem3D> orientations2) throws IOException, DataFormatException {
        JunctionHashGenerator generator = new JunctionHashGenerator();
        List<Matrix4D> trafos1 = generator.generateNormalizedTransformations(orientations1);
        List<Matrix4D> trafos2 = generator.generateNormalizedTransformations(orientations2);
        double score = generator.scoreNormalizedTransformations(trafos1, trafos2);
        return score;
    }

    public static double scoreJunctionSimilarity(InputStream fis, InputStream fis2) throws IOException, DataFormatException {
        JunctionScanOutputParser parser = new JunctionScanOutputParser(fis);
        parser.parse();
        List<CoordinateSystem3D> orientations1 = parser.getOrientations();
        JunctionScanOutputParser parser2 = new JunctionScanOutputParser(fis2);
        parser2.parse();
        List<CoordinateSystem3D> orientations2 = parser2.getOrientations();
        return JunctionHashGeneratorTools.scoreJunctionSimilarity(orientations1, orientations2);
    }
}

