/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.PropertyTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.DataFormatException;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;

public class JunctionScanOutputParser {
    int numStrands;
    List<CoordinateSystem3D> orientations;
    Properties properties = new Properties();

    public JunctionScanOutputParser(InputStream is) throws IOException {
        this.properties.load(is);
        this.orientations = new ArrayList<CoordinateSystem3D>();
    }

    public List<CoordinateSystem3D> getOrientations() {
        return this.orientations;
    }

    private CoordinateSystem3D parseHelixOrientation(int externalId) throws DataFormatException {
        String lead = "H" + externalId + "_";
        double px = PropertyTools.parseDouble(this.properties, lead + "P_X");
        double py = PropertyTools.parseDouble(this.properties, lead + "P_Y");
        double pz = PropertyTools.parseDouble(this.properties, lead + "P_Z");
        double dxx = PropertyTools.parseDouble(this.properties, lead + "DX_X");
        double dxy = PropertyTools.parseDouble(this.properties, lead + "DX_Y");
        double dxz = PropertyTools.parseDouble(this.properties, lead + "DX_Z");
        double dyx = PropertyTools.parseDouble(this.properties, lead + "DY_X");
        double dyy = PropertyTools.parseDouble(this.properties, lead + "DY_Y");
        double dyz = PropertyTools.parseDouble(this.properties, lead + "DY_Z");
        Vector3D base = new Vector3D(px, py, pz);
        Vector3D ex = new Vector3D(dxx, dxy, dxz);
        Vector3D ey = new Vector3D(dyx, dyy, dyz);
        return new CoordinateSystem3D(base, ex, ey);
    }

    private void parseHelixOrientations(int numStrands) throws DataFormatException {
        this.orientations.clear();
        for (int i = 0; i < numStrands; ++i) {
            int ii = i + 1;
            CoordinateSystem3D cs = this.parseHelixOrientation(ii);
            if (cs == null) {
                throw new DataFormatException("Error parsing helix " + ii);
            }
            this.orientations.add(cs);
        }
    }

    public void parse() throws DataFormatException {
        this.numStrands = Integer.parseInt(this.properties.getProperty("NUM_STRANDS"));
        this.parseHelixOrientations(this.numStrands);
    }
}

