/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.CorridorDescriptor;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.StrandJunction3D;
import rnasecondary.Stem;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3D;

public class KissingLoop3D
extends SimpleObject3D
implements StrandJunction3D {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final double BRANCH_MEET_DIST = 30.0;
    private int branchCount = 0;
    private boolean internalHelices = false;
    public static final int KISSING_LOOP_SIZE_MAX = 50;
    private int[] incomingBranchIds = new int[100];
    private int[] outgoingBranchIds = new int[100];
    private int[] incomingSeqIds = new int[100];
    private int[] outgoingSeqIds = new int[100];
    public static final String CLASS_NAME = "KissingLoop3D";

    public KissingLoop3D() {
    }

    public KissingLoop3D(Object3DSet branchesOrig) {
        assert (branchesOrig != null && branchesOrig.size() == 2);
        log.fine("Starting KissingLoop3D(Object3DSet): " + branchesOrig.size());
        Vector3D pos = new Vector3D(0.0, 0.0, 0.0);
        for (int i = 0; i < branchesOrig.size(); ++i) {
            BranchDescriptor3D branch = (BranchDescriptor3D)((BranchDescriptor3D)branchesOrig.get(i)).cloneDeep();
            assert (branch.isSingleSequence());
            pos.add(branch.getPosition());
            this.insertChild(branch);
        }
        pos.scale(1.0 / (double)branchesOrig.size());
        this.setIsolatedPosition(pos);
        log.fine("Quitting KissingLoop3D(Object3DSet): " + this.getPosition() + " " + this.size() + " " + this.getBranchCount() + " " + this.getStrandCount());
        assert (this.checkChildrenUnique());
    }

    private void addStrands(BranchDescriptor3D branch) {
        int branchIndex = this.getChildClassCounter(branch);
        assert (branchIndex >= 0);
        NucleotideStrand incoming = branch.getIncomingStrand();
        NucleotideStrand outgoing = branch.getOutgoingStrand();
        int inId = this.findStrandIndex(incoming);
        if (inId < 0) {
            this.insertChild(incoming);
            inId = this.size() - 1;
        } else {
            branch.setIncomingStrand(this.getStrand(inId));
        }
        this.incomingBranchIds[inId] = branchIndex;
        this.incomingSeqIds[branchIndex] = inId;
        int outId = this.findStrandIndex(outgoing);
        if (outId < 0) {
            this.insertChild(outgoing);
            outId = this.size() - 1;
        } else {
            branch.setOutgoingStrand(this.getStrand(outId));
        }
        this.outgoingBranchIds[outId] = branchIndex;
        this.outgoingSeqIds[branchIndex] = outId;
    }

    @Override
    public Object cloneDeepThis() {
        KissingLoop3D obj = new KissingLoop3D();
        obj.copyDeepThisCore(this);
        obj.branchCount = this.branchCount;
        obj.incomingBranchIds = new int[100];
        obj.outgoingBranchIds = new int[100];
        obj.incomingSeqIds = new int[100];
        obj.outgoingSeqIds = new int[100];
        for (int i = 0; i < 100; ++i) {
            obj.incomingBranchIds[i] = this.incomingBranchIds[i];
            obj.outgoingBranchIds[i] = this.outgoingBranchIds[i];
            obj.incomingSeqIds[i] = this.incomingSeqIds[i];
            obj.outgoingSeqIds[i] = this.outgoingSeqIds[i];
        }
        return obj;
    }

    @Override
    public Object cloneDeep() {
        KissingLoop3D newObj = (KissingLoop3D)this.cloneDeepThis();
        newObj.setFilename(this.getFilename());
        for (int i = 0; i < this.size(); ++i) {
            newObj.insertRawChild((Object3D)this.getChild(i).cloneDeep());
        }
        NucleotideStrand[] strands = this.getStrands();
        int branchCount = this.getBranchCount();
        for (int i = 0; i < branchCount; ++i) {
            BranchDescriptor3D branch = this.getBranch(i);
            BranchDescriptor3D newBranch = newObj.getBranch(i);
            NucleotideStrand inStrand = branch.getIncomingStrand();
            NucleotideStrand outStrand = branch.getOutgoingStrand();
            for (int j = 0; j < strands.length; ++j) {
                if (inStrand == strands[j]) {
                    newBranch.setIncomingStrand(newObj.getStrand(j));
                }
                if (outStrand != strands[j]) continue;
                newBranch.setOutgoingStrand(newObj.getStrand(j));
            }
        }
        return newObj;
    }

    @Override
    public Object3DSet cloneDown(int junctionOrder) {
        assert (false);
        return null;
    }

    @Override
    public boolean corridorCheck(CorridorDescriptor corridorDescriptor) {
        double corridorRadius = corridorDescriptor.radius;
        double corridorStart = corridorDescriptor.start;
        if (corridorRadius <= 0.0) {
            return true;
        }
        Object3DSet atomSet = Object3DTools.collectByClassName(this, "Atom3D");
        assert (atomSet.size() > 0);
        for (int i = 0; i < this.getBranchCount(); ++i) {
            BranchDescriptor3D branch = this.getBranch(i);
            if (Object3DTools.corridorCheck(branch.getPosition(), branch.getDirection(), corridorRadius, corridorStart, atomSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int findStrandIndex(NucleotideStrand strand) {
        for (int i = 0; i < this.getStrandCount(); ++i) {
            if (!this.getStrand(i).isProbablyEqual(strand)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void fuseStrands(int n, int m) {
        assert (false);
    }

    @Override
    public int getBranchCount() {
        return this.getChildCount("BranchDescriptor3D");
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public int[] getIncomingSeqIds() {
        return this.incomingSeqIds;
    }

    @Override
    public int[] getOutgoingSeqIds() {
        return this.outgoingSeqIds;
    }

    @Override
    public int getStrandCount() {
        int counter = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getChild(i) instanceof NucleotideStrand)) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public BranchDescriptor3D getBranch(int n) {
        int idx = this.getIndexOfChild(n, "BranchDescriptor3D");
        assert (idx >= 0);
        return (BranchDescriptor3D)this.getChild(idx);
    }

    @Override
    public int getLoopLength(int strandId) {
        int inBId = this.getIncomingBranchId(strandId);
        int outBId = this.getOutgoingBranchId(strandId);
        BranchDescriptor3D inBranch = this.getBranch(inBId);
        BranchDescriptor3D outBranch = this.getBranch(outBId);
        int inId = inBranch.getIncomingIndex() + inBranch.getOffset() + 1;
        int outId = outBranch.getOutgoingIndex() - outBranch.getOffset() - 1;
        int diff = outId - inId + 1;
        if (diff < 0) {
            log.severe("Warning: bad indices: " + inBId + " " + outBId + " strand: " + strandId + " " + this.getStrand(strandId));
        }
        assert (diff >= 0);
        return diff;
    }

    @Override
    public NucleotideStrand getStrand(int n) {
        int counter = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getChild(i) instanceof NucleotideStrand) || ++counter != n) continue;
            return (NucleotideStrand)this.getChild(i);
        }
        assert (false);
        return null;
    }

    @Override
    public NucleotideStrand[] getStrands() {
        int strandCount = this.getStrandCount();
        NucleotideStrand[] strands = new NucleotideStrand[strandCount];
        for (int i = 0; i < strandCount; ++i) {
            strands[i] = this.getStrand(i);
        }
        return strands;
    }

    @Override
    public int getIncomingBranchId(int n) {
        return this.incomingBranchIds[n];
    }

    @Override
    public int[] getIncomingBranchIds() {
        return this.incomingBranchIds;
    }

    @Override
    public int getOutgoingBranchId(int n) {
        return this.outgoingBranchIds[n];
    }

    @Override
    public int[] getOutgoingBranchIds() {
        return this.outgoingBranchIds;
    }

    @Override
    public boolean hasInternalHelices() {
        return this.internalHelices;
    }

    @Override
    public void insertChild(Object3D obj) {
        super.insertChild(obj);
        if (obj instanceof BranchDescriptor3D) {
            ++this.branchCount;
            BranchDescriptor3D branch = (BranchDescriptor3D)obj;
            this.addStrands(branch);
        }
    }

    public void insertRawChild(Object3D obj) {
        super.insertChild(obj);
    }

    @Override
    public boolean isKissingLoop() {
        return true;
    }

    @Override
    public void removeChild(Object3D obj) {
        super.removeChild(obj);
        if (obj instanceof BranchDescriptor3D) {
            --this.branchCount;
            assert (false);
        }
    }

    @Override
    public boolean isConnected(int incomingBranchId, int outgoingBranchId) {
        return this.incomingSeqIds[incomingBranchId] == this.outgoingSeqIds[outgoingBranchId];
    }

    @Override
    public boolean isRegular() {
        return this.getBranchCount() == this.getStrandCount() && this.getBranchCount() == 2;
    }

    @Override
    public boolean isValid() {
        int branchCount = this.getBranchCount();
        int strandCount = this.getStrandCount();
        if (branchCount != 2 || strandCount != 2) {
            log.fine("Warning: BranchCount and StrandCount are not equal 2: " + this.getBranchCount() + " " + this.getStrandCount());
            return false;
        }
        for (int i = 0; i < branchCount; ++i) {
            BranchDescriptor3D branch = this.getBranch(i);
            if (!branch.isValid()) {
                return false;
            }
            if (branch.isSingleSequence()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int findBranchConnectionLink(StrandJunction3D junction, LinkSet links) {
        int branchCount = this.getBranchCount();
        for (int i = 0; i < branchCount; ++i) {
            BranchDescriptor3D branch1 = this.getBranch(i);
            for (int j = 0; j < branchCount; ++j) {
                BranchDescriptor3D branch2 = junction.getBranch(j);
                for (int k = 0; k < links.size(); ++k) {
                    Link link = links.get(k);
                    if (!link.isLinked(branch1, branch2)) continue;
                    return k;
                }
            }
        }
        return -1;
    }

    public static boolean isLoopStem(BranchDescriptor3D branch1, RnaStem3D stem) {
        int stopPos;
        int i;
        boolean found;
        if (!branch1.isSingleSequence()) {
            return false;
        }
        if (branch1.getIncomingIndex() >= branch1.getOutgoingIndex()) {
            return false;
        }
        if (branch1.getOutgoingIndex() - branch1.getIncomingIndex() > 50) {
            return false;
        }
        Stem stemInfo = stem.getStemInfo();
        NucleotideStrand strand1 = stem.getStrand1();
        NucleotideStrand strand11 = branch1.getIncomingStrand();
        if (strand11 == strand1) {
            int startPos;
            found = false;
            i = 0;
            if (i < stemInfo.size() && (startPos = stemInfo.getStartPos(i).getPos()) > branch1.getIncomingIndex() && startPos < branch1.getOutgoingIndex()) {
                return true;
            }
        }
        if (strand11 != (strand1 = stem.getStrand2())) {
            log.fine("No common strand found in isLoopStem!");
            return false;
        }
        found = false;
        i = 0;
        return i < stemInfo.size() && (stopPos = stemInfo.getStopPos(i).getPos()) > branch1.getIncomingIndex() && stopPos < branch1.getOutgoingIndex();
    }

    private static boolean isKissingLoopStem(BranchDescriptor3D branch1, BranchDescriptor3D branch2, RnaStem3D stem) {
        assert (branch1.isSingleSequence() && branch2.isSingleSequence());
        assert (branch1.getIncomingIndex() < branch1.getOutgoingIndex());
        assert (branch2.getIncomingIndex() < branch2.getOutgoingIndex());
        return KissingLoop3D.isLoopStem(branch1, stem) && KissingLoop3D.isLoopStem(branch2, stem);
    }

    public static boolean hasCommonKissingLoopResidues(BranchDescriptor3D branch1, BranchDescriptor3D branch2) {
        assert (branch1.isSingleSequence() && branch2.isSingleSequence());
        assert (branch1.getIncomingIndex() < branch1.getOutgoingIndex());
        assert (branch2.getIncomingIndex() < branch2.getOutgoingIndex());
        NucleotideStrand strand1 = branch1.getIncomingStrand();
        NucleotideStrand strand2 = branch2.getIncomingStrand();
        for (int pos1 = branch1.getIncomingIndex(); pos1 <= branch1.getOutgoingIndex(); ++pos1) {
            Residue3D residue1 = strand1.getResidue3D(pos1);
            for (int pos2 = branch2.getIncomingIndex(); pos2 <= branch2.getOutgoingIndex(); ++pos2) {
                Residue3D residue2 = strand2.getResidue3D(pos2);
                if (!(residue1.getPosition().distance(residue2.getPosition()) < 1.0E-4)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isKissingLoop(BranchDescriptor3D branch1, BranchDescriptor3D branch2, Object3DSet stemSet) {
        boolean result = false;
        int len1 = branch1.getOutgoingIndex() - branch1.getIncomingIndex() + 1;
        int len2 = branch2.getOutgoingIndex() - branch2.getIncomingIndex() + 1;
        NucleotideStrand strand1 = branch1.getIncomingStrand();
        NucleotideStrand strand2 = branch2.getIncomingStrand();
        if (branch1.isSingleSequence() && len1 > 1 && branch2.isSingleSequence() && len2 > 1) {
            if (KissingLoop3D.hasCommonKissingLoopResidues(branch1, branch2)) {
                return false;
            }
            for (int i = 0; i < stemSet.size(); ++i) {
                RnaStem3D stem = (RnaStem3D)stemSet.get(i);
                if (!KissingLoop3D.isKissingLoopStem(branch1, branch2, stem)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static Set<Integer> computeIntersection(Set<Integer> set1, Set<Integer> set2) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (Integer i : set1) {
            if (set2.contains(i)) {
                result.add(i);
            }
            if (result.size() != set1.size() && result.size() != set2.size()) continue;
            break;
        }
        return result;
    }

    public static boolean isKissingLoop(BranchDescriptor3D branch1, BranchDescriptor3D branch2, Object3DSet stemSet, Set<Integer> loopStemIndices1, Set<Integer> loopStemIndices2) {
        int len1 = branch1.getOutgoingIndex() - branch1.getIncomingIndex() + 1;
        int len2 = branch2.getOutgoingIndex() - branch2.getIncomingIndex() + 1;
        NucleotideStrand strand1 = branch1.getIncomingStrand();
        NucleotideStrand strand2 = branch2.getIncomingStrand();
        if (branch1.isSingleSequence() && len1 > 1 && branch2.isSingleSequence() && len2 > 1) {
            if (KissingLoop3D.computeIntersection(loopStemIndices1, loopStemIndices2).size() == 0) {
                return false;
            }
            if (KissingLoop3D.hasCommonKissingLoopResidues(branch1, branch2)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setInternalHelices(boolean flag) {
        this.internalHelices = flag;
    }
}

