/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Randomizer;
import java.util.Properties;
import java.util.Random;
import rnadesign.rnamodel.AbstractBranchDescriptorOptimizer;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorOptimizer;
import rnadesign.rnamodel.BranchDescriptorOptimizerFactory;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaStem3D;
import tools3d.GaussianOrientableMutator;
import tools3d.OrientableModifier;

public class MonteCarloBranchDescriptorOptimizer
extends AbstractBranchDescriptorOptimizer {
    private static Random rnd = Randomizer.getInstance();
    public static final double HELIX_RISE_TOLERANCE = 0.5;
    public static final double HELIX_STEP_DEFAULT = 0.1;
    public static final double TRANSLATION_STEP_DEFAULT = 0.5;
    public static final double ANGLE_STEP_DEFAULT = 0.08726646259971647;
    private static final double HELIX_CONSTANT = 38.1356601;
    public static final String CLASS_NAME = "MonteCarloBranchDescriptorOptimizer";
    private FitParameters prm;
    private OrientableModifier mutator = new GaussianOrientableMutator(0.5, 0.08726646259971647);

    public MonteCarloBranchDescriptorOptimizer(FitParameters prm) {
        this.prm = prm;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private void mutateHelixParameters(BranchDescriptor3D b) {
        HelixParameters prm = b.getHelixParameters();
        double stretch = 1.0 + rnd.nextGaussian() * 0.1;
        double hNew = prm.getRise() * stretch;
        if (Math.abs(RnaConstants.HELIX_RISE - hNew) > 0.5) {
            return;
        }
        double newNt = Math.PI * 2 * prm.getRadius() / Math.sqrt(38.1356601 - hNew * hNew);
        prm.setRise(hNew);
        prm.setBasePairsPerTurn(newNt);
        b.setHelixParameters(prm);
    }

    private void mutateBranchDescriptor(BranchDescriptor3D b) {
        this.mutator.translate(b);
        this.mutator.rotate(b);
    }

    @Override
    public BranchDescriptor3D optimize(RnaStem3D stem, BranchDescriptor3D branch1, BranchDescriptor3D branch2) {
        BranchDescriptor3D b;
        double bestError;
        double rmsLimit;
        block11: {
            log.fine("Starting optimizeBranchDescriptor!");
            assert (branch1.isValid());
            assert (branch2.isValid());
            boolean bestAngle = false;
            rmsLimit = this.prm.getRmsLimit();
            log.fine("Starting MonteCarloBranchDescriptorOptimizer with rms limit: " + rmsLimit);
            bestError = rmsLimit + 1.0E-4;
            FitParameters prmInit = new FitParameters(100.0, Math.PI);
            prmInit.setRmsLimit(10.0);
            BranchDescriptorOptimizer stretchOptimizer = BranchDescriptorOptimizerFactory.generate(2, prmInit);
            b = null;
            try {
                b = stretchOptimizer.optimize(stem, branch1, branch2);
            }
            catch (FittingException fe) {
                if (b != null) break block11;
                log.fine("Stretch optimizer could not find suitable initial stem solution!");
                return null;
            }
        }
        if (b == null) {
            log.fine("Stretch optimizer could not find suitable initial stem solution!");
            return null;
        }
        assert (b != null);
        for (int iter = 0; iter < this.prm.getIterMax(); ++iter) {
            BranchDescriptor3D bSafe = (BranchDescriptor3D)b.cloneDeep();
            this.mutateBranchDescriptor(b);
            double errorVal = MonteCarloBranchDescriptorOptimizer.computeBranchDescriptorError(stem.getLength(), branch1, branch2, b);
            if (errorVal < bestError) {
                log.fine("Iteration: " + iter + " : New solution in MC optimization of stem: " + errorVal);
                bestError = errorVal;
                continue;
            }
            b = bSafe;
        }
        if (bestError > rmsLimit) {
            log.fine("Could not find stem solution: " + bestError);
            return null;
        }
        log.fine("Could find stem solution: " + bestError);
        Properties prop = b.getProperties();
        if (prop == null) {
            prop = new Properties();
            b.setProperties(prop);
        }
        prop.setProperty("fit_score", "" + bestError);
        assert (b.getProperties() != null);
        log.fine("Finished optimizeBranchDescriptor!");
        return b;
    }
}

