/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import chemistrytools.PeriodicTableImp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import rnadesign.rnacontrol.SimpleLinkController;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.AtomTools;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaModelException;
import tools3d.Vector3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DException;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.SimpleLink;

public class NucleotideTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final double HYDROGEN_BOND_DIST_MAX = 1.2;
    public static final String[] backboneNames = new String[]{"P", "O1P", "O2P", "O5*", "C5*", "C4*", "C3*", "O3*", "O4*", "C2*", "C1*", "O2*"};
    public static final String[] backboneAngleNames = new String[]{"P", "O5*", "C5*", "C4*", "C3*", "O3*"};
    public static final String[] sugarNames = new String[]{"N1", "C2", "O2", "N3", "C4", "O4", "C5", "C6", "N4", "N9", "C8", "N7", "O6", "N2", "N6"};
    public static final String[] purineTripodNames = new String[]{"N9", "C4", "C8"};
    public static final String[] pyrimidineTripodNames = new String[]{"N1", "C2", "C6"};
    public static Map<String, String[]> nucleotideMap;

    public static boolean isPhosphate(Atom3D atom) {
        return AtomTools.getElementChar(atom) == 'P';
    }

    public static String getBackboneAngleAtomName1(int angleId) {
        return backboneAngleNames[angleId / 2];
    }

    public static String getBackboneAngleAtomName2(int angleId) {
        return backboneAngleNames[1 + angleId / 2];
    }

    public static Vector3D getBackboneDirection(Nucleotide3D nuc) throws RnaModelException {
        Object3D obj1 = nuc.getChild("C5*");
        Object3D obj2 = nuc.getChild("O3*");
        if (obj1 == null || obj2 == null) {
            throw new RnaModelException("Could not find atoms C5* or O3* in " + nuc.getFullName());
        }
        return obj2.getPosition().minus(obj1.getPosition());
    }

    public static double getBackboneAngle(Nucleotide3D n1, Nucleotide3D n2) throws RnaModelException {
        return NucleotideTools.getBackboneDirection(n1).angle(NucleotideTools.getBackboneDirection(n2));
    }

    public static boolean isSugarAtom(Atom3D atom) {
        String name = atom.getName();
        char lastChar = name.charAt(name.length() - 1);
        return lastChar == '*' || lastChar == '\'';
    }

    public static boolean isCovalentlyBonded(Nucleotide3D n, Atom3D atom1, Atom3D atom2) {
        boolean result;
        block2: {
            result = false;
            try {
                result = NucleotideTools.isCovalentlyBonded(n, atom1.getName(), atom2.getName());
            }
            catch (RnaModelException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public static boolean isCovalentlyBonded(Nucleotide3D n, String atomName1, String atomName2) throws RnaModelException {
        int id1 = n.getIndexOfChild(atomName1);
        if (id1 < 0) {
            throw new RnaModelException(atomName1 + " is not a member of " + n);
        }
        int id2 = n.getIndexOfChild(atomName2);
        if (id2 < 0) {
            throw new RnaModelException(atomName2 + " is not a member of " + n);
        }
        Atom3D a1 = (Atom3D)n.getChild(id1);
        Atom3D a2 = (Atom3D)n.getChild(id2);
        if (a1.getLinks().find(a1, a2) != null) {
            return true;
        }
        if (a1.getPosition().distance(a2.getPosition()) > 3.0) {
            return false;
        }
        if (nucleotideMap == null) {
            NucleotideTools.generateNucleotideMap();
        }
        if (nucleotideMap.containsKey(atomName1) && nucleotideMap.containsKey(atomName2)) {
            String[] bondedAtoms = nucleotideMap.get(atomName1);
            for (int i = 0; i < bondedAtoms.length; ++i) {
                if (!bondedAtoms[i].equals(atomName2)) continue;
                return true;
            }
        } else {
            boolean h2Flag;
            boolean h1Flag = AtomTools.isHydrogen(a1);
            if (h1Flag ^ (h2Flag = AtomTools.isHydrogen(a2)) && a1.distance(a2) < 1.2) {
                return true;
            }
        }
        return false;
    }

    public static void addCovalentAtomLinks(Nucleotide3D nuc1, Nucleotide3D nuc2, LinkSet links) {
        for (int i = 0; i < nuc1.getAtomCount(); ++i) {
            Atom3D atom1 = nuc1.getAtom(i);
            for (int n = i + 1; n < nuc1.getAtomCount(); ++n) {
                SimpleLink link;
                Atom3D atom2 = nuc1.getAtom(n);
                if (links.find(atom1, atom2) != null || !NucleotideTools.isCovalentlyBonded(nuc1, atom1, atom2) || links.contains(link = new SimpleLink(atom1, atom2))) continue;
                links.add(link);
            }
        }
        if (nuc1.getPos() > 0) {
            Object3D obj1 = nuc1.getChild("P");
            Object3D obj2 = nuc2.getChild("O3*");
            if (obj1 != null && obj2 != null && links.find(obj1, obj2) == null) {
                SimpleLink specialLink = new SimpleLink(obj1, obj2);
                links.add(specialLink);
            }
        }
    }

    public static void addCovalentAtomLinksFast(Nucleotide3D nuc1, Nucleotide3D nuc2, LinkSet links) {
        for (int i = 0; i < nuc1.getAtomCount(); ++i) {
            Atom3D atom1 = nuc1.getAtom(i);
            for (int n = i + 1; n < nuc1.getAtomCount(); ++n) {
                SimpleLink link;
                Atom3D atom2 = nuc1.getAtom(n);
                if (!NucleotideTools.isCovalentlyBonded(nuc1, atom1, atom2) || links.contains(link = new SimpleLink(atom1, atom2))) continue;
                links.add(link);
            }
        }
        if (nuc1.getPos() > 0) {
            Object3D obj1 = nuc1.getChild("P");
            Object3D obj2 = nuc2.getChild("O3*");
            if (obj1 != null && obj2 != null && links.find(obj1, obj2) == null) {
                SimpleLink specialLink = new SimpleLink(obj1, obj2);
                links.add(specialLink);
            }
        }
    }

    public static void addCovalentAtomLinks(Nucleotide3D nuc1, LinkSet links) {
        int pos1 = nuc1.getPos();
        if (pos1 > 0) {
            Nucleotide3D nuc2 = (Nucleotide3D)nuc1.getParent().getChild(pos1 - 1);
            NucleotideTools.addCovalentAtomLinks(nuc1, nuc2, links);
            return;
        }
        for (int i = 0; i < nuc1.getAtomCount(); ++i) {
            Atom3D atom1 = nuc1.getAtom(i);
            for (int n = i + 1; n < nuc1.getAtomCount(); ++n) {
                Atom3D atom2 = nuc1.getAtom(n);
                if (links.find(atom1, atom2) != null || !NucleotideTools.isCovalentlyBonded(nuc1, atom1, atom2)) continue;
                SimpleLink link = new SimpleLink(atom1, atom2);
                links.add(link);
            }
        }
    }

    public static void addCovalentAtomLinksFast(Nucleotide3D nuc1, LinkSet links) {
        int pos1 = nuc1.getPos();
        if (pos1 > 0) {
            Nucleotide3D nuc2 = (Nucleotide3D)nuc1.getParent().getChild(pos1 - 1);
            NucleotideTools.addCovalentAtomLinks(nuc1, nuc2, links);
            return;
        }
        for (int i = 0; i < nuc1.getAtomCount(); ++i) {
            Atom3D atom1 = nuc1.getAtom(i);
            for (int n = i + 1; n < nuc1.getAtomCount(); ++n) {
                Atom3D atom2 = nuc1.getAtom(n);
                if (!NucleotideTools.isCovalentlyBonded(nuc1, atom1, atom2)) continue;
                SimpleLink link = new SimpleLink(atom1, atom2);
                links.add(link);
            }
        }
    }

    public static LinkSet getCovalentAtomLinks(Nucleotide3D nuc1) {
        SimpleLinkController links = new SimpleLinkController();
        NucleotideTools.addCovalentAtomLinks(nuc1, links);
        return links;
    }

    private static void generateNucleotideMap() {
        nucleotideMap = new HashMap<String, String[]>();
        nucleotideMap.put("N9", new String[]{"C8", "C4", "C1*"});
        nucleotideMap.put("C8", new String[]{"N7", "N9"});
        nucleotideMap.put("N7", new String[]{"C8", "C5"});
        nucleotideMap.put("C5", new String[]{"N7", "C4", "C6"});
        nucleotideMap.put("N1", new String[]{"C6", "C2", "C1*"});
        nucleotideMap.put("N3", new String[]{"C2", "C4"});
        nucleotideMap.put("C4", new String[]{"N3", "C5", "N9", "N4", "O4"});
        nucleotideMap.put("C6", new String[]{"C5", "N6", "N1", "O6"});
        nucleotideMap.put("N6", new String[]{"C6"});
        nucleotideMap.put("C2", new String[]{"N1", "N3", "N2", "O2"});
        nucleotideMap.put("O6", new String[]{"C6"});
        nucleotideMap.put("N2", new String[]{"C2"});
        nucleotideMap.put("C5", new String[]{"C6", "C4"});
        nucleotideMap.put("O2", new String[]{"C2"});
        nucleotideMap.put("N4", new String[]{"C4"});
        nucleotideMap.put("O4", new String[]{"C4"});
        nucleotideMap.put("O1P", new String[]{"P"});
        nucleotideMap.put("P", new String[]{"O1P", "O5*", "O2P"});
        nucleotideMap.put("O2P", new String[]{"P"});
        nucleotideMap.put("O5*", new String[]{"P", "C5*"});
        nucleotideMap.put("C5*", new String[]{"O5*", "C4*"});
        nucleotideMap.put("C4*", new String[]{"C5*", "O4*", "C3*"});
        nucleotideMap.put("C3*", new String[]{"C4*", "O3*", "C2*"});
        nucleotideMap.put("O3*", new String[]{"C3*"});
        nucleotideMap.put("C2*", new String[]{"C3*", "O2*", "C1*"});
        nucleotideMap.put("O2*", new String[]{"C2*"});
        nucleotideMap.put("C1*", new String[]{"N1", "N9", "O4*", "C2*"});
        nucleotideMap.put("O4*", new String[]{"C1*", "C4*"});
    }

    public static boolean isBackboneAtom(Atom3D atom) {
        String name = atom.getName();
        for (int i = 0; i < backboneNames.length; ++i) {
            if (!backboneNames[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBaseAtom(Atom3D atom) {
        return !NucleotideTools.isSugarAtom(atom) && !NucleotideTools.isBackboneAtom(atom);
    }

    public static boolean is5PrimeNucleotide(Nucleotide3D nuc) {
        if (nuc.getParent() == null) {
            return false;
        }
        return nuc.getSiblingId() == 0;
    }

    public static boolean is3PrimeNucleotide(Nucleotide3D nuc) {
        if (nuc.getParent() == null) {
            return false;
        }
        return nuc.getSiblingId() == nuc.getParent().size() - 1;
    }

    public static boolean isAtStrandEnd(Nucleotide3D nuc) {
        return NucleotideTools.is5PrimeNucleotide(nuc) || NucleotideTools.is3PrimeNucleotide(nuc);
    }

    public static boolean addMissingO3Prime(Nucleotide3D nuc) throws RnaModelException {
        Vector3D dir2;
        Vector3D vc4;
        if (nuc.getIndexOfChild("O3*") >= 0) {
            return false;
        }
        if (nuc.getIndexOfChild("C3*") < 0 || nuc.getIndexOfChild("C4*") < 0 || nuc.getIndexOfChild("C2*") < 0) {
            throw new RnaModelException("Cannot add O3*, because on of the following atoms is missing too: C3*, C2*, C4* ." + nuc.toString());
        }
        Vector3D vc2 = nuc.getChild("C2*").getPosition();
        Vector3D vc3 = nuc.getChild("C3*").getPosition();
        Vector3D dir1 = vc3.minus(vc4 = nuc.getChild("C4*").getPosition());
        Vector3D dir = dir1.plus(dir2 = vc3.minus(vc2));
        if (dir.length() == 0.0) {
            throw new RnaModelException("Error in adding O3*: zero length direction vector!");
        }
        dir.normalize();
        dir.scale(1.43);
        assert (Math.abs(dir.length() - 1.43) < 0.001);
        Vector3D pos = vc3.plus(dir);
        Atom3D o3prime = new Atom3D(pos);
        o3prime.setElement(PeriodicTableImp.generateDefaultChemicalElementByValency(2));
        o3prime.setName("O3*");
        nuc.insertChild(o3prime);
        assert (o3prime.getPosition().minus(vc3).length() < 2.0);
        return true;
    }

    public static boolean addMissingOP(Nucleotide3D nuc) throws RnaModelException {
        log.info("Trying to add O1P, O2P to nucleotide: " + nuc.toString());
        if (nuc.getIndexOfChild("O1P") >= 0 || nuc.getIndexOfChild("OP1") >= 0) {
            return false;
        }
        if (nuc.getIndexOfChild("O2P") >= 0 || nuc.getIndexOfChild("OP2") >= 0) {
            return false;
        }
        if (nuc.getSiblingId() < 1) {
            return false;
        }
        Nucleotide3D prevNuc = (Nucleotide3D)nuc.getParent().getChild(nuc.getSiblingId() - 1);
        if (nuc.getIndexOfChild("P") < 0 || nuc.getIndexOfChild("O5*") < 0 || prevNuc.getIndexOfChild("O3*") < 0) {
            throw new RnaModelException("Cannot add O1P, O2P, because on of the following atoms is missing too: P, O5*, O3* ." + nuc.toString());
        }
        Vector3D vc2 = prevNuc.getChild("O3*").getPosition();
        Vector3D vc3 = nuc.getChild("P").getPosition();
        Vector3D vc4 = nuc.getChild("O5*").getPosition();
        Vector3D vcOrth = vc2.cross(vc4);
        if (vcOrth.length() == 0.0) {
            throw new RnaModelException("Orthogonal vector could not be normalized!");
        }
        vcOrth.normalize();
        Vector3D dir1 = vc3.minus(vc4);
        Vector3D dir2 = vc3.minus(vc2);
        Vector3D dir = dir1.plus(dir2);
        if (dir.length() == 0.0) {
            throw new RnaModelException("Error in adding O3*: zero length direction vector!");
        }
        dir.normalize();
        double bLength = 1.4;
        double tetAng = Math.toRadians(54.5);
        dir.scale(Math.cos(tetAng) * bLength);
        vcOrth.scale(Math.sin(tetAng) * bLength);
        Vector3D pos = vc3.plus(dir).plus(vcOrth);
        Vector3D pos2 = vc3.plus(dir).minus(vcOrth);
        Atom3D o1p = new Atom3D(pos);
        Atom3D o2p = new Atom3D(pos2);
        o1p.setElement(PeriodicTableImp.generateDefaultChemicalElementByValency(2));
        o1p.setName("O1P");
        o2p.setName("O2P");
        nuc.insertChild(o1p);
        nuc.insertChild(o2p);
        log.info("Added missing atoms: " + o1p.toString() + " " + o2p.toString() + " to residue: " + nuc.toString());
        assert (o1p.getPosition().minus(vc3).length() < 2.0);
        assert (o2p.getPosition().minus(vc3).length() < 2.0);
        return true;
    }

    public static List<String> findMissingAtoms(Nucleotide3D nuc) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : backboneNames) {
            if (nuc.getIndexOfChild(name) >= 0) continue;
            result.add(name);
        }
        return result;
    }

    public static boolean isPurine(Nucleotide3D nuc) {
        return nuc.getIndexOfChild("N9") >= 0;
    }

    public static Atom3D getGlycosylicBondAtom(Nucleotide3D nuc) {
        if (NucleotideTools.isPurine(nuc)) {
            return (Atom3D)nuc.getChild("N9");
        }
        return (Atom3D)nuc.getChild("N1");
    }

    private static Vector3D computeBasePlaneNormal(Vector3D p1, Vector3D p2, Vector3D p3) {
        Vector3D v1 = p2.minus(p1);
        Vector3D v2 = p3.minus(p1);
        Vector3D result = v1.cross(v2);
        return result;
    }

    public static Vector3D computeBasePlaneNormal(Nucleotide3D nuc, String[] atomNames) throws RnaModelException {
        assert (atomNames.length == 3);
        Vector3D result = null;
        try {
            Object3DSet atoms = Object3DSetTools.getChildren(nuc, atomNames);
            assert (atoms.size() == 3);
            result = NucleotideTools.computeBasePlaneNormal(atoms.get(0).getPosition(), atoms.get(1).getPosition(), atoms.get(2).getPosition());
        }
        catch (Object3DException oe) {
            throw new RnaModelException(oe.getMessage());
        }
        assert (result != null);
        if (result.length() == 0.0) {
            throw new RnaModelException("Could not compute normal vector of base (has zero length): " + nuc.getFullName());
        }
        Vector3D backboneDir = NucleotideTools.getBackboneDirection(nuc);
        if (backboneDir.dot(result) < 0.0) {
            result.scale(-1.0);
        }
        result.normalize();
        assert (result.length() > 0.99 && result.length() < 1.01);
        return result;
    }

    public static Vector3D computeBasePlaneNormal(Nucleotide3D nuc) throws RnaModelException {
        return NucleotideTools.isPurine(nuc) ? NucleotideTools.computeBasePlaneNormal(nuc, purineTripodNames) : NucleotideTools.computeBasePlaneNormal(nuc, pyrimidineTripodNames);
    }
}

