/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.TestTools;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import rnadesign.rnacontrol.SimpleBasePairController;
import rnadesign.rnacontrol.SimpleLinkController;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.AtomTools;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.GeneralPdbWriter;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaPdbRnaviewReader;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StructureQualityTools;
import rnasecondary.Interaction;
import rnasecondary.InteractionSet;
import rnasecondary.InteractionType;
import rnasecondary.RnaInteractionType;
import sequence.DnaTools;
import sequence.LetterSymbol;
import sequence.Residue;
import sequence.SimpleLetterSymbol;
import sequence.UnknownSymbolException;
import tools3d.MCSuperpose;
import tools3d.SuperpositionResult;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3DSet;

public class RnaStrandTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public static void mutateResidue(RnaStrand strand, Nucleotide3D nucleotide, int n, double rmsLimit, LinkSet links) throws FittingException, RnaModelException {
        int origSize = strand.getResidueCount();
        log.fine("Changing residue " + strand.getResidue(n).getSymbol() + " " + (n + 1) + " to " + nucleotide.getSymbol());
        Nucleotide3D newRes = (Nucleotide3D)nucleotide.cloneDeep();
        Nucleotide3D oldRes = (Nucleotide3D)strand.getResidue(n);
        newRes.setName(RnaStrandTools.swapResidueNames(newRes.getName(), oldRes.getName()));
        Object3DSet oldTripod = NucleotideDBTools.extractAtomTripod(oldRes);
        Object3DSet newTripod = NucleotideDBTools.extractAtomTripod(newRes);
        Vector3D[] oldCoord = Object3DSetTools.getCoordinates(oldTripod);
        Vector3D[] newCoord = Object3DSetTools.getCoordinates(newTripod);
        MCSuperpose superposer = new MCSuperpose();
        SuperpositionResult supResult = superposer.superpose(oldCoord, newCoord);
        if (supResult.getRms() > rmsLimit) {
            throw new FittingException("Could not place mutated residue with RMS smaller than " + rmsLimit + " : " + supResult.getRms());
        }
        supResult.applyTransformation(newRes);
        if (oldRes.getProperties() != null) {
            newRes.setProperties((Properties)oldRes.getProperties().clone());
        }
        links.replaceObjectInLinks(strand.getResidue3D(n), newRes);
        strand.replaceChild(n, newRes);
        assert (newRes.getParent() instanceof BioPolymer);
        assert (oldRes.getParent() == null);
        assert (strand.getResidue(n).getSymbol().equals(newRes.getSymbol()));
        assert (strand.getResidueCount() == origSize);
        NucleotideTools.addCovalentAtomLinks(newRes, links);
        log.info("Changed residue " + oldRes.getSymbol() + " " + (n + 1) + " to " + strand.getResidue(n).getSymbol());
    }

    public static void mutateResidue(RnaStrand strand, LetterSymbol symbol, int n, Object3D nucleotideDB, double rmsLimit, LinkSet links) throws FittingException, RnaModelException {
        int dbId = NucleotideDBTools.findResidueIndex(nucleotideDB, symbol);
        if (dbId < 0) {
            throw new RnaModelException("Could not find nucleotide in database: " + symbol);
        }
        Nucleotide3D dbNuc = (Nucleotide3D)nucleotideDB.getChild(dbId);
        RnaStrandTools.mutateResidue(strand, dbNuc, n, rmsLimit, links);
    }

    public static void mutateResidueIfNecessary(RnaStrand strand, LetterSymbol symbol, int n, Object3D nucleotideDB, double rmsLimit, LinkSet links) throws FittingException, RnaModelException {
        if (strand.getResidue(n).getSymbol().getCharacter() != symbol.getCharacter()) {
            RnaStrandTools.mutateResidue(strand, symbol, n, nucleotideDB, rmsLimit, links);
        }
    }

    private static String swapResidueNames(String newResidueOrigName, String oldResidueName) {
        return "" + newResidueOrigName.charAt(0) + oldResidueName.substring(1);
    }

    private static int countBaseCollisions(Nucleotide3D res1, Nucleotide3D res2, double collDist) {
        int count = 0;
        for (int i = 0; i < res1.getAtomCount(); ++i) {
            Atom3D atom1 = res1.getAtom(i);
            if (AtomTools.isHydrogen(atom1) || !NucleotideTools.isBaseAtom(atom1)) continue;
            for (int j = 0; j < res2.getAtomCount(); ++j) {
                Atom3D atom2 = res2.getAtom(j);
                if (AtomTools.isHydrogen(atom2) || !NucleotideTools.isBaseAtom(atom2) || !(atom1.distance(atom2) < collDist)) continue;
                ++count;
            }
        }
        return count;
    }

    private static int countBaseCollisions(Nucleotide3D newRes, RnaStrand strand, int n, double collDist) {
        int result = 0;
        if (n > 0) {
            result += RnaStrandTools.countBaseCollisions(newRes, (Nucleotide3D)strand.getResidue(n - 1), collDist);
        }
        if (n < strand.getResidueCount() - 1) {
            result += RnaStrandTools.countBaseCollisions(newRes, (Nucleotide3D)strand.getResidue(n + 1), collDist);
        }
        return result;
    }

    private static void mutateBasePair(RnaStrand strand1, Nucleotide3D nucleotide1, int n1, RnaStrand strand2, Nucleotide3D nucleotide2, int n2, double rmsLimit, LinkSet links) throws FittingException, RnaModelException {
        int i;
        int origSize = strand1.getResidueCount();
        log.fine("Changing residue " + strand1.getResidue(n1).getSymbol() + " " + (n1 + 1) + " to " + nucleotide1.getSymbol() + " and " + strand2.getResidue(n2).getSymbol() + " " + (n2 + 1) + " to " + nucleotide2.getSymbol());
        Nucleotide3D newRes1 = (Nucleotide3D)nucleotide1.cloneDeep();
        Nucleotide3D newRes2 = (Nucleotide3D)nucleotide2.cloneDeep();
        Nucleotide3D oldRes1 = (Nucleotide3D)strand1.getResidue(n1);
        Nucleotide3D oldRes2 = (Nucleotide3D)strand2.getResidue(n2);
        newRes1.setName(RnaStrandTools.swapResidueNames(newRes1.getName(), oldRes1.getName()));
        newRes2.setName(RnaStrandTools.swapResidueNames(newRes2.getName(), oldRes2.getName()));
        Object3DSet oldTripod1 = NucleotideDBTools.extractAtomTripodBp(oldRes1);
        Object3DSet oldTripod2 = NucleotideDBTools.extractAtomTripodBp(oldRes2);
        Object3DSet newTripod1 = NucleotideDBTools.extractAtomTripodBp(newRes1);
        Object3DSet newTripod2 = NucleotideDBTools.extractAtomTripodBp(newRes2);
        Vector3D[] oldCoord1 = Object3DSetTools.getCoordinates(oldTripod1);
        Vector3D[] newCoord1 = Object3DSetTools.getCoordinates(newTripod1);
        Vector3D[] oldCoord2 = Object3DSetTools.getCoordinates(oldTripod2);
        Vector3D[] newCoord2 = Object3DSetTools.getCoordinates(newTripod2);
        Vector3D[] oldCoord = new Vector3D[oldCoord1.length + oldCoord2.length];
        Vector3D[] newCoord = new Vector3D[newCoord1.length + newCoord2.length];
        for (i = 0; i < newCoord1.length; ++i) {
            newCoord[i] = newCoord1[i];
            oldCoord[i] = oldCoord1[i];
        }
        for (i = 0; i < newCoord2.length; ++i) {
            newCoord[i + newCoord1.length] = newCoord2[i];
            oldCoord[i + oldCoord1.length] = oldCoord2[i];
        }
        MCSuperpose superposer = new MCSuperpose();
        SuperpositionResult supResult = superposer.superpose(oldCoord, newCoord);
        if (supResult.getRms() > rmsLimit) {
            throw new FittingException("Could not place mutated residue with RMS smaller than " + rmsLimit + " : " + supResult.getRms());
        }
        supResult.applyTransformation(newRes1);
        supResult.applyTransformation(newRes2);
        int countColl = RnaStrandTools.countBaseCollisions(newRes1, strand1, n1, AtomTools.defaultCollisionDistance) + RnaStrandTools.countBaseCollisions(newRes2, strand2, n2, AtomTools.defaultCollisionDistance);
        if (countColl > 0) {
            System.out.println("Found " + countColl + " collisions for new base pair!");
            throw new FittingException("Could not place mutated residue because of base collisions!");
        }
        assert (oldRes1 != null);
        assert (oldRes2 != null);
        if (oldRes1.getProperties() != null) {
            newRes1.setProperties((Properties)oldRes1.getProperties().clone());
        }
        if (oldRes2.getProperties() != null) {
            newRes2.setProperties((Properties)oldRes2.getProperties().clone());
        }
        links.replaceObjectInLinks(strand1.getResidue3D(n1), newRes1);
        links.replaceObjectInLinks(strand2.getResidue3D(n2), newRes2);
        strand1.replaceChild(n1, newRes1);
        strand2.replaceChild(n2, newRes2);
        NucleotideTools.addCovalentAtomLinks(newRes1, links);
        NucleotideTools.addCovalentAtomLinks(newRes2, links);
        assert (newRes1.getParent() instanceof BioPolymer);
        assert (oldRes1.getParent() == null);
        assert (strand1.getResidue(n1).getSymbol().equals(newRes1.getSymbol()));
        assert (strand2.getResidue(n2).getSymbol().equals(newRes2.getSymbol()));
        assert (strand1.getResidueCount() == origSize);
    }

    public static void mutateBasePair(InteractionLink oldBasePairLink, InteractionLink newBasePairLink, double rmsLimit, LinkSet links) throws RnaModelException, FittingException {
        Object3D objOld1 = oldBasePairLink.getObj1();
        Object3D objOld2 = oldBasePairLink.getObj2();
        Object3D objNew1 = newBasePairLink.getObj1();
        Object3D objNew2 = newBasePairLink.getObj2();
        if (!(objOld1 instanceof Nucleotide3D)) {
            throw new RnaModelException("Object " + objOld1.getName() + " is not a nucleotide object!");
        }
        if (!(objOld2 instanceof Nucleotide3D)) {
            throw new RnaModelException("Object " + objOld2.getName() + " is not a nucleotide object!");
        }
        Nucleotide3D oldNuc1 = (Nucleotide3D)objOld1;
        Nucleotide3D oldNuc2 = (Nucleotide3D)objOld2;
        Nucleotide3D newNuc1 = (Nucleotide3D)objNew1;
        Nucleotide3D newNuc2 = (Nucleotide3D)objNew2;
        RnaStrand strand1 = null;
        RnaStrand strand2 = null;
        if (!(oldNuc1.getParent() instanceof RnaStrand)) {
            throw new RnaModelException("Nucleotide does not have RNA strand as parent object: " + oldNuc1.getName());
        }
        if (!(oldNuc2.getParent() instanceof RnaStrand)) {
            throw new RnaModelException("Nucleotide does not have RNA strand as parent object: " + oldNuc2.getName());
        }
        strand1 = (RnaStrand)oldNuc1.getParent();
        strand2 = (RnaStrand)oldNuc2.getParent();
        int n1 = oldNuc1.getPos();
        int n2 = oldNuc2.getPos();
        RnaStrandTools.mutateBasePair(strand1, newNuc1, n1, strand2, newNuc2, n2, rmsLimit, links);
    }

    public static void mutateBasePair(InteractionLink oldBasePairLink, LetterSymbol symbol1, LetterSymbol symbol2, RnaInteractionType interactionType, LinkSet basePairDB, double rmsLimit, LinkSet links) throws RnaModelException, FittingException {
        boolean interactionFound = false;
        for (int i = 0; i < basePairDB.size(); ++i) {
            RnaInteractionType dbInteraction;
            InteractionLink link = (InteractionLink)basePairDB.get(i);
            LetterSymbol s1 = ((Nucleotide3D)link.getObj1()).getSymbol();
            LetterSymbol s2 = ((Nucleotide3D)link.getObj2()).getSymbol();
            if (s1.getCharacter() != symbol1.getCharacter() || s2.getCharacter() != symbol2.getCharacter() || (dbInteraction = (RnaInteractionType)link.getInteraction().getInteractionType()).getSubTypeId() != interactionType.getSubTypeId()) continue;
            interactionFound = true;
            try {
                RnaStrandTools.mutateBasePair(oldBasePairLink, link, rmsLimit, links);
                return;
            }
            catch (FittingException fe) {
                // empty catch block
            }
        }
        if (interactionFound) {
            throw new FittingException("Could not find fitting " + interactionType + " " + symbol1 + " " + symbol2 + " in base pair database!");
        }
        throw new RnaModelException("Could not find " + interactionType + " " + symbol1 + " " + symbol2 + " in base pair database!");
    }

    public static void mutateBasePair(Interaction oldBasePairInteraction, char c1, char c2, LinkSet basePairDB, double rmsLimit, LinkSet links) throws RnaModelException, FittingException, UnknownSymbolException {
        Residue res1 = oldBasePairInteraction.getResidue1();
        Residue res2 = oldBasePairInteraction.getResidue2();
        SimpleLetterSymbol s1 = new SimpleLetterSymbol(c1, DnaTools.AMBIGUOUS_RNA_ALPHABET);
        SimpleLetterSymbol s2 = new SimpleLetterSymbol(c2, DnaTools.AMBIGUOUS_RNA_ALPHABET);
        Link oldBasePairLink = links.find((Object3D)((Object)res1), (Object3D)((Object)res2));
        if (oldBasePairLink == null || !(oldBasePairLink instanceof InteractionLink)) {
            throw new RnaModelException("Could not find base pair link for residues " + res1 + " " + res2);
        }
        RnaInteractionType interactionType = new RnaInteractionType(1);
        RnaStrandTools.mutateBasePair((InteractionLink)oldBasePairLink, s1, s2, interactionType, basePairDB, rmsLimit, links);
    }

    private void writeInteractions(PrintStream ps, InteractionSet hbondInteractions) {
        for (int i = 0; i < hbondInteractions.size(); ++i) {
            Interaction interaction = hbondInteractions.get(i);
            Residue res1 = interaction.getResidue1();
            Residue res2 = interaction.getResidue2();
            System.out.println("Watson Crick interactions: " + (i + 1) + " " + res1.getSymbol() + (res1.getPos() + 1) + " : " + res2.getSymbol() + (res2.getPos() + 1));
        }
    }

    @Test(groups={"slow"})
    public void testMutateBasePair() {
        int mutationMistakeCounter;
        int allGaps;
        Object3DLinkSetBundle bundle;
        block16: {
            SimpleBasePairController basePairDB;
            InteractionSet hbondInteractions;
            SimpleLinkController linkController;
            block15: {
                block14: {
                    log.info(TestTools.generateMethodHeader("testMutateBasePair"));
                    String filename1 = "../test/fixtures/1BGZ.rnaview.pdb";
                    String basePairDBName = "../resources/2J00_A_rnaview.pdb";
                    RnaPdbRnaviewReader reader = new RnaPdbRnaviewReader();
                    bundle = null;
                    double gapCutoff = 1.9;
                    try {
                        FileInputStream fis = new FileInputStream("../test/fixtures/1BGZ.rnaview.pdb");
                        bundle = reader.readBundle(fis);
                    }
                    catch (IOException ioe) {
                        System.out.println("IO error: " + ioe.getMessage());
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError();
                    }
                }
                assert (bundle != null);
                Object3DSet strandSet = Object3DTools.collectByClassName(bundle.getObject3D(), "RnaStrand");
                for (int i = 0; i < strandSet.size(); ++i) {
                    RnaStrand strand = (RnaStrand)strandSet.get(i);
                    int numGaps = StructureQualityTools.countBackboneGaps(strand, 1.9);
                    System.out.println("Number of backbone gaps in strand: " + strand.getName() + " : " + numGaps);
                }
                allGaps = StructureQualityTools.countAllBackboneGaps(bundle.getObject3D(), 1.9);
                System.out.println("Total number of backbone gaps: " + allGaps);
                linkController = new SimpleLinkController(bundle.getLinks());
                System.out.println("Links: " + linkController.toPrettyString());
                hbondInteractions = linkController.getHydrogenBondInteractions();
                this.writeInteractions(System.out, hbondInteractions);
                System.out.println("Reading base pair database: ../resources/2J00_A_rnaview.pdb");
                basePairDB = new SimpleBasePairController();
                try {
                    FileInputStream fis = new FileInputStream("../resources/2J00_A_rnaview.pdb");
                    basePairDB.read(fis);
                }
                catch (IOException ioe) {
                    System.out.println("IO error reading base pair database: " + ioe.getMessage());
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError();
                }
            }
            System.out.println("Number of base pairs in database: " + basePairDB.size());
            double mutationRmsLimit = 0.28;
            double mutationRmsLimit2 = 0.35;
            mutationMistakeCounter = 0;
            try {
                System.out.println("mutating GC into AU:");
                RnaStrandTools.mutateBasePair(hbondInteractions.get(1), 'A', 'U', basePairDB, mutationRmsLimit, linkController);
                int allGapsNew = StructureQualityTools.countAllBackboneGaps(bundle.getObject3D(), 1.9);
                System.out.println("Total number of backbone gaps after performing mutation: " + allGapsNew);
                System.out.println("mutating AU into CG:");
                RnaStrandTools.mutateBasePair(hbondInteractions.get(3), 'C', 'G', basePairDB, mutationRmsLimit, linkController);
                allGapsNew = StructureQualityTools.countAllBackboneGaps(bundle.getObject3D(), 1.9);
                System.out.println("Total number of backbone gaps after performing mutation: " + allGapsNew);
                System.out.println("Hardest case: mutate very first base pair frmo GC to AU:");
                RnaStrandTools.mutateBasePair(hbondInteractions.get(0), 'U', 'A', basePairDB, mutationRmsLimit2, linkController);
                allGapsNew = StructureQualityTools.countAllBackboneGaps(bundle.getObject3D(), 1.9);
                System.out.println("Total number of backbone gaps after performing mutation: " + allGapsNew);
            }
            catch (RnaModelException rme) {
                System.out.println("Rna model exception while mutating base pair: " + rme.getMessage());
                assert (false);
            }
            catch (FittingException fe) {
                System.out.println("Fitting-exception while mutating base pair: " + fe.getMessage());
                assert (false);
            }
            catch (UnknownSymbolException use) {
                System.out.println("Unknown symbol exception while mutating base pair: " + use.getMessage());
                if ($assertionsDisabled) break block16;
                throw new AssertionError();
            }
        }
        GeneralPdbWriter writer = new GeneralPdbWriter();
        System.out.println("Mutated structure:");
        writer.write((OutputStream)System.out, bundle.getObject3D());
        int allGapsNew = StructureQualityTools.countAllBackboneGaps(bundle.getObject3D(), 1.9);
        System.out.println("Total number of backbone gaps after performing mutation: " + allGapsNew);
        if (allGapsNew > allGaps) {
            System.out.println("New gaps introduced due to mutation! Mutation test failed.");
            mutationMistakeCounter += allGapsNew;
        }
        if (mutationMistakeCounter > 0) assert (false);
        log.info(TestTools.generateMethodHeader("testMutateBasePair"));
    }

    public static boolean isPureHelix(NucleotideStrand strand1, NucleotideStrand strand2, LinkSet links) {
        assert (strand1 != null && strand2 != null);
        if (strand1.getResidueCount() != strand2.getResidueCount()) {
            return false;
        }
        int n = strand1.getResidueCount();
        for (int i = 0; i < strand1.getResidueCount(); ++i) {
            assert (n - i - 1 >= 0);
            if (links.getLinkNumber(strand1.getResidue3D(i), strand2.getResidue3D(n - i - 1)) != 0) continue;
            return false;
        }
        return true;
    }

    public static Object3DSet findPureHelicalStrands(Object3D node, LinkSet links) {
        List<Object3D> strands = Object3DTools.collectByClassName(node, "RnaStrand").getAsList();
        SimpleObject3DSet result = new SimpleObject3DSet();
        block0: for (int i = 0; i < strands.size(); ++i) {
            for (int j = i + 1; j < strands.size(); ++j) {
                if (!RnaStrandTools.isPureHelix((NucleotideStrand)strands.get(i), (NucleotideStrand)strands.get(j), links)) continue;
                result.add(strands.get(i));
                result.add(strands.get(j));
                continue block0;
            }
        }
        return result;
    }

    public static boolean isRnaBasePairLink(Link link) {
        Interaction interaction;
        InteractionType interactionType;
        if (link instanceof InteractionLink && (interactionType = (interaction = ((InteractionLink)link).getInteraction()).getInteractionType()) instanceof RnaInteractionType && interactionType.getSubTypeId() != 6 && interactionType.getSubTypeId() != -1) {
            log.info("Found base pair type: " + interactionType.getSubTypeId());
            return true;
        }
        return false;
    }

    public static void trimUnpaired(NucleotideStrand strand, LinkSet links) {
        int i;
        block0: for (int i2 = strand.size() - 1; i2 >= 0; --i2) {
            LinkSet group = links.findLinks(strand.getResidue3D(i2));
            boolean found = false;
            for (int j = 0; j < group.size(); ++j) {
                if (!RnaStrandTools.isRnaBasePairLink(group.get(j))) continue;
                found = true;
                log.info("Found base pair interaction for residue: " + strand.getResidue3D(i2).getFullName());
                break block0;
            }
            if (found) continue;
            log.info("Removing unpaired nucleotide " + strand.getChild(i2).getFullName());
            strand.removeChild(i2);
        }
        ArrayList<Integer> toBeRemoved = new ArrayList<Integer>();
        block2: for (i = 0; i < strand.getResidueCount(); ++i) {
            LinkSet group = links.findLinks(strand.getResidue3D(i));
            boolean found = false;
            for (int j = 0; j < group.size(); ++j) {
                if (!RnaStrandTools.isRnaBasePairLink(group.get(j))) continue;
                log.info("Found base pair interaction for residue: " + strand.getResidue3D(i).getFullName());
                found = true;
                break block2;
            }
            if (found) continue;
            log.info("Removing unpaired nucleotide " + strand.getChild(i).getFullName());
            toBeRemoved.add(i);
        }
        for (i = toBeRemoved.size() - 1; i >= 0; --i) {
            log.info("Removing unpaired nucleotide " + strand.getChild(i).getFullName());
            strand.removeChild(i);
        }
    }
}

