/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.List;
import rnadesign.rnamodel.AbstractBiopolymer;
import rnadesign.rnamodel.AminoAcid3D;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.ProteinStrand;
import rnadesign.rnamodel.Residue3D;
import sequence.Alphabet;
import sequence.ProteinTools;
import sequence.Residue;
import tools3d.Matrix3DTools;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;

public class SimpleProteinStrand
extends AbstractBiopolymer
implements ProteinStrand {
    public static final String CLASS_NAME = "ProteinStrand";
    private static Alphabet alphabet = ProteinTools.PROTEIN_ALPHABET;
    private double weight = 1.0;

    public SimpleProteinStrand() {
    }

    public SimpleProteinStrand(Alphabet alphabet) {
        SimpleProteinStrand.alphabet = alphabet;
    }

    @Override
    public Object cloneDeep(int startPos, int stopPos) {
        assert (false);
        return null;
    }

    @Override
    public Alphabet getAlphabet() {
        return alphabet;
    }

    @Override
    public Atom3D getAtom(int n) {
        assert (false);
        log.severe("getAtom method not yet implemented!");
        return null;
    }

    @Override
    public int getAtomCount() {
        int sum = 0;
        int resCount = this.getResidueCount();
        for (int i = 0; i < resCount; ++i) {
            sum += this.getResidue3D(i).getAtomCount();
        }
        return sum;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public int getCovalentBondOrder(Atom3D atom1, Atom3D atom2) {
        assert (false);
        return -1;
    }

    @Override
    public List<Atom3D> getCovalentlyBondedAtoms(Atom3D atom) {
        assert (false);
        return null;
    }

    @Override
    public Object getParentObject() {
        return this.getParent();
    }

    @Override
    public Vector3D getResiduePosition(int n) throws IndexOutOfBoundsException {
        if (n < this.getResidueCount()) {
            Residue3D residue = this.getResidue3D(n);
            return residue.getPosition();
        }
        Vector3D pos = new Vector3D();
        pos.copy(this.getPosition());
        int nn = this.getResidueCount();
        int nHalf = nn / 2;
        double z = pos.getZ() + (double)(n - nHalf) * 5.0;
        pos.setZ(z);
        return Matrix3DTools.rotate(pos, this.getRotationAxis(), this.getRotationAngle());
    }

    @Override
    public void addResidue(Residue residue) {
        if (!(residue instanceof Nucleotide3D)) {
            assert (false);
            throw new RuntimeException("SimpleRnaStrand.addResidue: added residue must be of type Nucleotid3D");
        }
        this.insertChild((Nucleotide3D)residue);
    }

    @Override
    public void append(BioPolymer polymer) {
        assert (false);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void prepend(BioPolymer polymer) {
        assert (false);
    }

    @Override
    public void appendAndDelete(BioPolymer polymer) {
        assert (false);
    }

    @Override
    public void prependAndDelete(BioPolymer polymer) {
        assert (false);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public Residue3D getResidueByAssignedNumber(int n) {
        for (int i = 0; i < this.size(); ++i) {
            Residue3D residue;
            Object3D child = this.getChild(i);
            if (!(child instanceof Residue3D) || (residue = (Residue3D)child).getAssignedNumber() != n) continue;
            return residue;
        }
        return null;
    }

    @Override
    public int getResidueCount() {
        return this.size();
    }

    @Override
    public Residue3D getResidue3D(int n) {
        return (AminoAcid3D)this.getChild(n);
    }

    @Override
    public Residue getResidue(int n) {
        return (AminoAcid3D)this.getChild(n);
    }

    @Override
    public Residue3D getResidueByPdbId(int n) {
        String ns = new Integer(n).toString();
        int resCount = this.getResidueCount();
        for (int i = 0; i < resCount; ++i) {
            Residue3D residue = this.getResidue3D(i);
            if (!ns.equals(residue.getProperty("pdb_residue_id"))) continue;
            return residue;
        }
        return null;
    }

    @Override
    public String getShapeName() {
        return "RnaStrand";
    }

    @Override
    public void insertChild(Object3D child) {
        assert (child instanceof AminoAcid3D);
        super.insertChild(child);
    }

    @Override
    public void setParent(Object obj) {
        if (obj instanceof Object3D) {
            super.setParent((Object3D)obj);
        }
        assert (false);
        throw new RuntimeException("Internal error: only object3d objects can be added here.");
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public void rotateAroundBackboneAngle(int residue, int angleId, double angle) {
        assert (false);
    }

    @Override
    public BioPolymer split(int position, String newName) {
        int oldLength = this.getResidueCount();
        String oldSequence = this.sequenceString();
        SimpleProteinStrand newStrand = new SimpleProteinStrand(this.getAlphabet());
        newStrand.setName(newName);
        this.split(position, newStrand);
        assert (this.getResidueCount() + newStrand.getResidueCount() == oldLength);
        assert (oldSequence.equals(this.sequenceString() + newStrand.sequenceString()));
        return newStrand;
    }

    @Override
    public String toString() {
        String result = "(ProteinStrand " + this.toStringBody() + this.sequenceString();
        result = result + " )";
        return result;
    }
}

