/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import numerictools.PotentialND;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaStem3D;
import rnasecondary.Stem;
import tools3d.CoordinateSystem;
import tools3d.LineShape;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;

public class StemBasePotential
implements PotentialND {
    private RnaStem3D stem;
    private Stem stemInfo;
    private static final double ERROR_VALUE = 9999.9;
    private HelixParameters helixParameters = new HelixParameters();

    public StemBasePotential(RnaStem3D stem) {
        this.stem = stem;
        this.stemInfo = stem.getStemInfo();
    }

    public double computeHelixFit(CoordinateSystem cs) throws FittingException {
        assert (this.stemInfo.size() > 0);
        double rms = 0.0;
        int count = 0;
        int step = (this.stemInfo.size() - 1) / 2;
        if (step < 1) {
            step = 1;
        }
        for (int i = 0; i < this.stemInfo.size(); i += step) {
            LineShape line = Rna3DTools.computeHelix(i, cs, this.helixParameters);
            Vector3D p1 = line.getPosition1();
            Vector3D p2 = line.getPosition2();
            String usedRefName1 = "C4*";
            String usedRefName2 = "C4*";
            if (this.stem.getStartResidue(i).getIndexOfChild(usedRefName1) < 0) {
                usedRefName1 = "C4'";
            }
            if (this.stem.getStopResidue(i).getIndexOfChild(usedRefName2) < 0) {
                usedRefName2 = "C4'";
            }
            if (this.stem.getStartResidue(i).getIndexOfChild(usedRefName1) < 0) {
                throw new FittingException("Could not find atom with name: C4* or C4' in residue " + this.stem.getStartResidue(i).getName());
            }
            if (this.stem.getStopResidue(i).getIndexOfChild(usedRefName2) < 0) {
                throw new FittingException("Could not find atom with name: C4* or C4' in residue " + this.stem.getStopResidue(i).getName());
            }
            Vector3D p1Orig = this.stem.getStartResidue(i).getChild(usedRefName1).getPosition();
            Vector3D p2Orig = this.stem.getStopResidue(i).getChild(usedRefName2).getPosition();
            rms += p1.distanceSquare(p1Orig) + p2.distanceSquare(p2Orig);
            ++count;
        }
        rms /= 2.0 * (double)count;
        rms = Math.sqrt(rms);
        return rms;
    }

    @Override
    public int getDimension() {
        return 9;
    }

    @Override
    public double[] generateLowPosition() {
        assert (false);
        return null;
    }

    @Override
    public double[] generateHighPosition() {
        assert (false);
        return null;
    }

    public HelixParameters getHelixParameters() {
        return this.helixParameters;
    }

    @Override
    public double getValue(double[] v) {
        CoordinateSystem3D.renormalize(v);
        CoordinateSystem3D cs = new CoordinateSystem3D(v);
        double value = 0.0;
        try {
            value = this.computeHelixFit(cs);
        }
        catch (FittingException fe) {
            value = 9999.9;
        }
        return value;
    }

    public void setHelixParameters(HelixParameters other) {
        this.helixParameters = other;
    }
}

