/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.Arrays;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.LilleyNomenclature;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.CoordinateSystem;
import tools3d.Vector3D;
import tools3d.objects3d.Object3DTools;

public class StrandJunctionDBExportTools {
    public static double[] generateJunctionFingerPrint(StrandJunction3D junction) {
        int size = junction.getBranchCount();
        int num = size * (size - 1) / 2;
        double[] result = new double[num];
        int pc = 0;
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            for (int j = i + 1; j < junction.getBranchCount(); ++j) {
                result[pc++] = junction.getBranch(i).getDirection().angle(junction.getBranch(j).getDirection());
            }
        }
        Arrays.sort(result);
        return result;
    }

    private static String generateJunctionFingerPrintText(StrandJunction3D junction) {
        double[] angles = StrandJunctionDBExportTools.generateJunctionFingerPrint(junction);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < angles.length; ++i) {
            double degrees = Math.toDegrees(angles[i]);
            int degreesInt = (int)(degrees + 0.5);
            buf.append("" + degreesInt);
            if (i + 1 >= angles.length) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    private static String generateVectorDBInfo(Vector3D pos, String nameBase) {
        return nameBase + "_X = " + pos.getX() + PackageConstants.NEWLINE + nameBase + "_Y = " + pos.getY() + PackageConstants.NEWLINE + nameBase + "_Z = " + pos.getZ() + PackageConstants.NEWLINE;
    }

    private static String generateStrandDBInfo(StrandJunction3D junction, int i) {
        StringBuffer buf = new StringBuffer();
        buf.append("## Properties of strand " + (i + 1) + PackageConstants.NEWLINE);
        String base = "S" + (i + 1) + "_";
        NucleotideStrand strand = junction.getStrand(i);
        int b1Id = junction.getIncomingBranchId(i);
        int b2Id = junction.getOutgoingBranchId(i);
        BranchDescriptor3D branchIn = junction.getBranch(b1Id);
        BranchDescriptor3D branchOut = junction.getBranch(b2Id);
        int fiveId = branchIn.getIncomingIndex();
        int threeId = branchOut.getOutgoingIndex();
        int inOffset = branchIn.getOffset();
        int outOffset = branchOut.getOffset();
        int fiveId2 = fiveId + inOffset;
        int threeId2 = threeId - outOffset;
        String seqString = junction.getStrand(i).sequenceString();
        assert (fiveId <= threeId + 1);
        assert (threeId + 1 <= seqString.length());
        assert (fiveId >= 0);
        seqString = seqString.substring(fiveId, threeId + 1);
        int lastIndexTmp = seqString.length() - outOffset;
        String seqString2 = "";
        if (lastIndexTmp >= 0 && lastIndexTmp > inOffset && inOffset < seqString.length() && lastIndexTmp <= seqString.length()) {
            seqString2 = seqString.substring(inOffset, lastIndexTmp);
        }
        Residue3D fiveResidue = strand.getResidue3D(fiveId);
        Residue3D threeResidue = strand.getResidue3D(threeId);
        Residue3D fiveResidue2 = strand.getResidue3D(fiveId2);
        Residue3D threeResidue2 = strand.getResidue3D(threeId2);
        String nameIn = fiveResidue.getName().substring(1);
        String nameOut = threeResidue.getName().substring(1);
        String nameIn2 = fiveResidue2.getName().substring(1);
        String nameOut2 = threeResidue2.getName().substring(1);
        String strandChar = Object3DTools.getProperty(strand, "pdb_chain_char");
        if (strandChar == null) {
            strandChar = "A";
        }
        buf.append(base + "NAME_ID5 =  " + nameIn + PackageConstants.NEWLINE);
        buf.append(base + "NAME_ID3 = " + nameOut + PackageConstants.NEWLINE);
        buf.append(base + "NUM_ID5_ORIG =  " + fiveResidue.getAssignedNumber() + PackageConstants.NEWLINE);
        buf.append(base + "NUM_ID3_ORIG = " + threeResidue.getAssignedNumber() + PackageConstants.NEWLINE);
        buf.append(base + "NAME2_ID5 =  " + nameIn2 + PackageConstants.NEWLINE);
        buf.append(base + "NAME2_ID3 = " + nameOut2 + PackageConstants.NEWLINE);
        buf.append(base + "NUM2_ID5_ORIG =  " + fiveResidue2.getAssignedNumber() + PackageConstants.NEWLINE);
        buf.append(base + "NUM2_ID3_ORIG = " + threeResidue2.getAssignedNumber() + PackageConstants.NEWLINE);
        buf.append(base + "SQ2 = " + seqString2 + PackageConstants.NEWLINE);
        buf.append(base + "SQLEN2 = " + seqString2.length() + PackageConstants.NEWLINE);
        buf.append(base + "SQ = " + seqString + PackageConstants.NEWLINE);
        buf.append(base + "SQLEN = " + seqString.length() + PackageConstants.NEWLINE);
        buf.append(base + "CHAR = " + strandChar + PackageConstants.NEWLINE);
        return buf.toString();
    }

    private static String generateBranchDBInfo(StrandJunction3D junction, int id) {
        String outStrandChar;
        StringBuffer buf = new StringBuffer();
        buf.append("## Properties of helix " + (id + 1) + PackageConstants.NEWLINE);
        BranchDescriptor3D branch = junction.getBranch(id);
        String hBase = "H" + (id + 1) + "_";
        int incIndex = branch.getIncomingIndex();
        int outIndex = branch.getOutgoingIndex();
        int incIndex2 = incIndex + branch.getOffset();
        assert (incIndex2 < branch.getIncomingStrand().getResidueCount());
        int outIndex2 = outIndex - branch.getOffset();
        assert (outIndex2 >= 0);
        assert (outIndex2 < branch.getOutgoingStrand().getResidueCount());
        int incIndex2Orig = branch.getIncomingStrand().getResidue(incIndex2).getAssignedNumber();
        int outIndex2Orig = branch.getOutgoingStrand().getResidue(outIndex2).getAssignedNumber();
        String incStrandChar = Object3DTools.getProperty(branch.getIncomingStrand(), "pdb_chain_char");
        if (incStrandChar == null) {
            incStrandChar = "A";
        }
        if ((outStrandChar = Object3DTools.getProperty(branch.getOutgoingStrand(), "pdb_chain_char")) == null) {
            outStrandChar = "A";
        }
        buf.append(hBase + "INID = " + (incIndex + 1) + PackageConstants.NEWLINE);
        buf.append(hBase + "OUTID = " + (outIndex + 1) + PackageConstants.NEWLINE);
        buf.append(hBase + "INID2 = " + (incIndex2 + 1) + PackageConstants.NEWLINE);
        buf.append(hBase + "OUTID2 = " + (outIndex2 + 1) + PackageConstants.NEWLINE);
        buf.append(hBase + "INID2_ORIG = " + incIndex2Orig + PackageConstants.NEWLINE);
        buf.append(hBase + "OUTID2_ORIG = " + outIndex2Orig + PackageConstants.NEWLINE);
        buf.append(hBase + "INSEQ_CHAR = " + incStrandChar + PackageConstants.NEWLINE);
        buf.append(hBase + "OUTSEQ_CHAR = " + outStrandChar + PackageConstants.NEWLINE);
        buf.append("# Position:" + PackageConstants.NEWLINE);
        String posBase = hBase + "P";
        buf.append(StrandJunctionDBExportTools.generateVectorDBInfo(branch.getPosition(), posBase));
        buf.append("# Orientation:" + PackageConstants.NEWLINE);
        CoordinateSystem cs = branch.getCoordinateSystem();
        String dirBase = hBase + "DX";
        buf.append(StrandJunctionDBExportTools.generateVectorDBInfo(cs.getX(), dirBase));
        dirBase = hBase + "DY";
        buf.append(StrandJunctionDBExportTools.generateVectorDBInfo(cs.getY(), dirBase));
        dirBase = hBase + "DZ";
        buf.append(StrandJunctionDBExportTools.generateVectorDBInfo(cs.getZ(), dirBase));
        return buf.toString();
    }

    static String generateBranchDBInfo(BranchDescriptor3D branch, int id) {
        String outStrandChar;
        StringBuffer buf = new StringBuffer();
        buf.append("## Properties of helix " + (id + 1) + PackageConstants.NEWLINE);
        String hBase = "H" + (id + 1) + "_";
        int incIndex = branch.getIncomingIndex();
        int outIndex = branch.getOutgoingIndex();
        int incIndex2 = incIndex + branch.getOffset();
        assert (incIndex2 < branch.getIncomingStrand().getResidueCount());
        int outIndex2 = outIndex - branch.getOffset();
        assert (outIndex2 >= 0);
        assert (outIndex2 < branch.getOutgoingStrand().getResidueCount());
        int incIndex2Orig = branch.getIncomingStrand().getResidue(incIndex2).getAssignedNumber();
        int outIndex2Orig = branch.getOutgoingStrand().getResidue(outIndex2).getAssignedNumber();
        String incStrandChar = Object3DTools.getProperty(branch.getIncomingStrand(), "pdb_chain_char");
        if (incStrandChar == null) {
            incStrandChar = "A";
        }
        if ((outStrandChar = Object3DTools.getProperty(branch.getOutgoingStrand(), "pdb_chain_char")) == null) {
            outStrandChar = "A";
        }
        buf.append(hBase + "INID = " + (incIndex + 1) + PackageConstants.NEWLINE);
        buf.append(hBase + "OUTID = " + (outIndex + 1) + PackageConstants.NEWLINE);
        buf.append(hBase + "INID2 = " + (incIndex2 + 1) + PackageConstants.NEWLINE);
        buf.append(hBase + "OUTID2 = " + (outIndex2 + 1) + PackageConstants.NEWLINE);
        buf.append(hBase + "INID2_ORIG = " + incIndex2Orig + PackageConstants.NEWLINE);
        buf.append(hBase + "OUTID2_ORIG = " + outIndex2Orig + PackageConstants.NEWLINE);
        buf.append(hBase + "INSEQ_CHAR = " + incStrandChar + PackageConstants.NEWLINE);
        buf.append(hBase + "OUTSEQ_CHAR = " + outStrandChar + PackageConstants.NEWLINE);
        buf.append("# Position:" + PackageConstants.NEWLINE);
        String posBase = hBase + "P";
        buf.append(StrandJunctionDBExportTools.generateVectorDBInfo(branch.getPosition(), posBase));
        buf.append("# Orientation:" + PackageConstants.NEWLINE);
        CoordinateSystem cs = branch.getCoordinateSystem();
        String dirBase = hBase + "DX";
        buf.append(StrandJunctionDBExportTools.generateVectorDBInfo(cs.getX(), dirBase));
        dirBase = hBase + "DY";
        buf.append(StrandJunctionDBExportTools.generateVectorDBInfo(cs.getY(), dirBase));
        dirBase = hBase + "DZ";
        buf.append(StrandJunctionDBExportTools.generateVectorDBInfo(cs.getZ(), dirBase));
        return buf.toString();
    }

    public static String generateJunctionDBInfo(StrandJunction3D junction) {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("#############  Start of Description of junction: " + junction.getName() + PackageConstants.NEWLINE);
        int numBranches = junction.getBranchCount();
        int numStrands = junction.getStrandCount();
        LilleyNomenclature lilley = new LilleyNomenclature();
        buf.append("# Number of strands:" + PackageConstants.NEWLINE + "NUM_STRANDS = " + numStrands + PackageConstants.NEWLINE);
        buf.append("LILLEY = " + lilley.generateNomenclature(junction) + PackageConstants.NEWLINE);
        buf.append("FINGERPRINT = " + StrandJunctionDBExportTools.generateJunctionFingerPrintText(junction) + PackageConstants.NEWLINE);
        buf.append("LOOP_LENGTH_SUM = " + LilleyNomenclature.computeLoopLengthSum(junction) + PackageConstants.NEWLINE);
        buf.append("KISSING_LOOP = ");
        if (junction.isKissingLoop()) {
            buf.append("TRUE" + PackageConstants.NEWLINE);
        } else {
            buf.append("FALSE" + PackageConstants.NEWLINE);
        }
        buf.append("INTERNAL_HELICES = ");
        buf.append("NULL" + PackageConstants.NEWLINE);
        for (i = 0; i < numStrands; ++i) {
            buf.append(StrandJunctionDBExportTools.generateStrandDBInfo(junction, i));
        }
        for (i = 0; i < numBranches; ++i) {
            buf.append(StrandJunctionDBExportTools.generateBranchDBInfo(junction, i));
        }
        buf.append("#############  END of Description of junction: " + junction.getName() + PackageConstants.NEWLINE);
        return buf.toString();
    }
}

