/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import generaltools.ResultWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rnasecondary.RnaSecondaryTools;
import rnasecondary.SimpleInteractionSet;
import rnasecondary.SimpleSecondaryStructure;
import rnasecondary.SimpleStem;
import rnasecondary.Stem;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.Sequence;
import sequence.UnevenAlignment;

public class SimpleSecondaryStructurePredictor
extends ResultWorker {
    private UnevenAlignment ali;
    private double gcEnergy = -1.0;
    private double auEnergy = -0.8;
    private Alphabet alphabet = DnaTools.AMBIGUOUS_RNA_ALPHABET;
    private Sequence[] sequences;
    private int stemLengthMin = 3;
    private int stopOffset = 3;

    public SimpleSecondaryStructurePredictor(UnevenAlignment ali) {
        assert (ali != null);
        this.ali = ali;
        this.sequences = this.getSequences(ali);
    }

    private Sequence[] getSequences(UnevenAlignment ali) {
        Sequence[] sequences = new Sequence[ali.getSequenceCount()];
        for (int i = 0; i < ali.getSequenceCount(); ++i) {
            sequences[i] = ali.getSequence(i);
        }
        return sequences;
    }

    private double computeStemEnergy(Stem stem) {
        assert (stem.isValid());
        String s1 = stem.getSequence1().sequenceString();
        String s2 = stem.getSequence2().sequenceString();
        int start = stem.getStartPos();
        int stop = stem.getStopPos();
        int len = stem.size();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            char c2;
            int p1 = start + i;
            int p2 = stop - i;
            char c1 = s1.charAt(p1);
            if (!RnaSecondaryTools.isWatsonCrick(c1, c2 = s2.charAt(p2))) continue;
            if (c2 < c1) {
                char help = c2;
                c2 = c1;
                c1 = help;
            }
            if (c1 == 'A') {
                result += this.auEnergy;
                continue;
            }
            if (c1 == 'C') {
                result += this.gcEnergy;
                continue;
            }
            assert (false);
        }
        assert (result <= 0.0);
        return result;
    }

    private List<Stem> generateStemList(Sequence s1, Sequence s2) {
        assert (s1 != s2);
        int maxLen = s1.size();
        if (s2.size() < maxLen) {
            maxLen = s2.size();
        }
        String s1s = s1.sequenceString();
        String s2s = s2.sequenceString();
        ArrayList<Stem> result = new ArrayList<Stem>();
        for (int start = 0; start < s1.size() - this.stemLengthMin + 1; ++start) {
            for (int stop = s2.size() - 1; stop >= this.stemLengthMin - 1; --stop) {
                for (int len = 1; len <= maxLen && SimpleStem.isValid(start, stop, len, s1.size(), s2.size()) && RnaSecondaryTools.isWatsonCrick(s1s.charAt(start + len - 1), s2s.charAt(stop - len + 1)); ++len) {
                    if (len < this.stemLengthMin) continue;
                    SimpleStem stem = new SimpleStem(start, stop, len, s1, s2);
                    assert (stem.isValid());
                    assert (stem.isComplementary());
                    stem.setEnergy(this.computeStemEnergy(stem));
                    result.add(stem);
                }
            }
        }
        return result;
    }

    private List<Stem> generateStemList(Sequence s1) {
        int maxLen = s1.size();
        ArrayList<Stem> result = new ArrayList<Stem>();
        String s1s = s1.sequenceString();
        for (int start = 0; start < s1.size() - this.stemLengthMin + 1; ++start) {
            for (int stop = s1.size() - 1; stop >= start + this.stopOffset; --stop) {
                int p2;
                int p1;
                for (int len = 1; len <= maxLen && (p1 = start + len - 1) + this.stopOffset < (p2 = stop - len + 1) && SimpleStem.isValid(start, stop, len, s1.size(), s1.size()) && RnaSecondaryTools.isWatsonCrick(s1s.charAt(p1), s1s.charAt(p2)); ++len) {
                    if (len < this.stemLengthMin) continue;
                    SimpleStem stem = new SimpleStem(start, stop, len, s1, s1);
                    assert (stem.isValid());
                    assert (stem.isComplementary());
                    stem.setEnergy(this.computeStemEnergy(stem));
                    result.add(stem);
                }
            }
        }
        return result;
    }

    private List<Stem> generateStemList(Sequence[] sequences) {
        ArrayList<Stem> result = new ArrayList<Stem>();
        for (int i = 0; i < sequences.length; ++i) {
            result.addAll(this.generateStemList(sequences[i]));
            for (int j = i + 1; j < sequences.length; ++j) {
                result.addAll(this.generateStemList(sequences[i], sequences[j]));
            }
        }
        Collections.sort(result);
        return result;
    }

    private boolean isConflicting(Stem stem, List<Stem> stemList) {
        for (int i = 0; i < stemList.size(); ++i) {
            if (!stemList.get(i).isConflicting(stem)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void runInternal() {
        List<Stem> stemList = this.generateStemList(this.sequences);
        ArrayList<Stem> placedStems = new ArrayList<Stem>();
        for (int i = 0; i < stemList.size(); ++i) {
            Stem stem = stemList.get(i);
            if (this.isConflicting(stem, placedStems)) continue;
            placedStems.add(stem);
        }
        SimpleInteractionSet interactionSet = new SimpleInteractionSet();
        for (int i = 0; i < placedStems.size(); ++i) {
            for (int j = 0; j < ((Stem)placedStems.get(i)).size(); ++j) {
                interactionSet.add(((Stem)placedStems.get(i)).get(j));
            }
        }
        this.setResult(new SimpleSecondaryStructure(this.ali, interactionSet));
    }
}

