/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.PropertyTools;
import generaltools.StringTools;
import generaltools.TestTools;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import numerictools.IntegerArrayTools;
import org.testng.annotations.Test;
import rnasecondary.RnaSecondaryTools;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import secondarystructuredesign.MatchFoldSecondaryStructureScorer;
import secondarystructuredesign.SecondaryStructureScorer;

public class CritonScorer
implements SecondaryStructureScorer {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String CRITON_PROP = "critonlen";
    private int auLim = 2;
    private int gcLim = 1;
    private int critonLen = 6;
    private double auViolationWeight = 1.0;
    private double gcViolationWeight = 1.0;
    private double nonUniquePenalty = 1.0;
    private double complementPenalty = 1.0;
    private double selfComplementPenalty = 1.0;
    private double similarPenalty = 0.0;
    private double bulgePenalty = 0.0;
    private boolean guComplementMode = true;
    private int debugLevel = 0;
    private SecondaryStructureScorer defaultScorer = new MatchFoldSecondaryStructureScorer();
    private double defaultScorerWeight = 0.0;
    private double branchMigrationWeight = 1.0;
    private double consecutiveWeight = 1.0;
    private double gcMinFrac = 0.76;
    private double gcMinFracWeight = 1.0;
    private int zipperLength = 1;
    private double zipperWeight = 1.0;
    private int consecutiveLimit = 3;
    private int consecutiveLimitG = 2;

    public void setAuViolationWeight(double value) {
        this.auViolationWeight = value;
    }

    public void setGcViolationWeight(double value) {
        this.gcViolationWeight = value;
    }

    public void setBranchMigrationWeight(double value) {
        this.branchMigrationWeight = value;
    }

    public void setBulgePenalty(double p) {
        this.bulgePenalty = p;
    }

    public void setSimilarPenalty(double p) {
        this.similarPenalty = p;
    }

    public void setConsecutiveLimit(int limit) {
        this.consecutiveLimit = limit;
    }

    public void setConsecutiveLimitG(int limit) {
        this.consecutiveLimitG = limit;
    }

    public void setConsecutiveWeight(double value) {
        this.consecutiveWeight = value;
    }

    public void setCritonLen(int newLen) {
        this.critonLen = newLen;
    }

    public void setDebugLevel(int level) {
        this.debugLevel = level;
    }

    public void setDefaultScorerWeight(double weight) {
        this.defaultScorerWeight = weight;
    }

    public void setGCMinFracWeight(double value) {
        this.gcMinFracWeight = value;
    }

    public void setGuComplementMode(boolean mode) {
        this.guComplementMode = mode;
    }

    public void setZipperWeight(double value) {
        this.zipperWeight = value;
    }

    private boolean isSelfComplementary(String strand) {
        int n = strand.length();
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            char char2;
            char char1 = strand.charAt(i);
            if (RnaSecondaryTools.isWatsonCrick(char1, char2 = strand.charAt(n - i - 1))) continue;
            return false;
        }
        return true;
    }

    @Test(groups={"new"})
    public void testIsSelfComplementary() {
        String strand1 = "ACGU";
        String strand2 = "UGCA";
        assert (this.isSelfComplementary(strand1));
        assert (this.isSelfComplementary(strand2));
        assert (this.isSelfComplementary(strand1 + strand1));
        assert (this.isSelfComplementary(strand2 + strand2));
        assert (!this.isSelfComplementary(strand1 + strand2));
        assert (!this.isSelfComplementary(strand2 + strand1));
    }

    private boolean strandsComplement(String strand1, String strand2) {
        if (strand1.length() != strand2.length()) {
            return false;
        }
        int n = strand2.length();
        for (int i = 0; i < strand1.length(); ++i) {
            if (!(this.guComplementMode ? !RnaSecondaryTools.isRnaComplement(strand1.charAt(i), strand2.charAt(n - i - 1)) : !RnaSecondaryTools.isWatsonCrick(strand1.charAt(i), strand2.charAt(n - i - 1)))) continue;
            return false;
        }
        return true;
    }

    private char getBP(int index) {
        if (index == 0) {
            return 'a';
        }
        if (index == 1) {
            return 'u';
        }
        if (index == 2) {
            return 'c';
        }
        if (index == 3) {
            return 'g';
        }
        System.out.println("Invalid bp index: " + index);
        System.out.println("Index must be between 0 & 3 (inclusive)");
        assert (false);
        return ' ';
    }

    private String[] findAllBulges(String strand) {
        String[] bulges = new String[4 * (strand.length() - 1)];
        for (int i = 0; i < strand.length() - 1; ++i) {
            for (int n = 0; n < 4; ++n) {
                StringBuffer b = new StringBuffer(strand);
                bulges[4 * i + n] = b.insert(i + 1, this.getBP(n)).toString();
            }
        }
        return bulges;
    }

    private String[] findAllSimilar(String strand) {
        String strandLower = strand.toLowerCase();
        String[] similar = new String[3 * strand.length()];
        for (int i = 0; i < strand.length(); ++i) {
            int index = 0;
            for (int n = 0; n < 4; ++n) {
                char c = this.getBP(n);
                if (strandLower.charAt(i) == c) continue;
                StringBuffer b = new StringBuffer(strand);
                b.setCharAt(i, c);
                similar[3 * i + index] = b.toString();
                ++index;
            }
        }
        return similar;
    }

    @Test(groups={"new"})
    public void testStrandsComplement() {
    }

    private String[] createCritons(String strand, int len) {
        int numCritons = strand.length() - len + 1;
        if (numCritons <= 0) {
            return new String[0];
        }
        String[] critons = new String[numCritons];
        for (int i = 0; i < critons.length; ++i) {
            critons[i] = strand.substring(i, i + len).toUpperCase();
        }
        assert (critons[critons.length - 1] != null);
        return critons;
    }

    public void setParams(Properties params) {
        if (params.getProperty(CRITON_PROP) != null) {
            this.setCritonLen(Integer.parseInt(params.getProperty(CRITON_PROP)));
        }
    }

    private boolean isUnique(String[][] critons, int xIndex, int yIndex) {
        this.log.severe("CritonScorer.isUnique is deprecated!");
        assert (xIndex < critons.length);
        assert (yIndex < critons[0].length);
        String criton = critons[xIndex][yIndex];
        for (int i = 0; i < critons.length; ++i) {
            for (int j = 0; j < critons[i].length; ++j) {
                if (!critons[i][j].equalsIgnoreCase(criton) || i == xIndex && j == yIndex) continue;
                System.out.print("Not unique!  Identical sequence exists in strand " + (i + 1) + " at index " + j + "   ");
                return false;
            }
        }
        return true;
    }

    private boolean unwantedComplementExists(String[][] critons, int xIndex, int yIndex, int[][][][] interactionMatrices) {
        this.log.severe("CritonScorer.unwantedComplementExists is deprecated!");
        String criton = critons[xIndex][yIndex];
        for (int i = 0; i < critons.length; ++i) {
            for (int j = 0; j < critons[i].length; ++j) {
                if (!this.strandsComplement(criton, critons[i][j])) continue;
                int[][] interactionMatrix = null;
                interactionMatrix = xIndex <= i ? interactionMatrices[xIndex][i] : interactionMatrices[i][xIndex];
                for (int index = 0; index < this.critonLen; ++index) {
                    if (interactionMatrix[yIndex + index][j + index] == 1) continue;
                    System.out.print("Unwanted complement exists in strand " + (i + 1) + " at index " + j + "   ");
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isGap(char c) {
        return c == '.' || c == '-';
    }

    private boolean isUniformlyBasePaired(int pos, int len, String s) {
        assert (pos + len - 1 < s.length());
        for (int i = pos; i < pos + len; ++i) {
            char c = s.charAt(i);
            if (this.isGap(c)) {
                return false;
            }
            if (i <= pos || s.charAt(i - 1) == c) continue;
            return false;
        }
        return true;
    }

    @Test(groups={"new"})
    public void testIsUniformlyBasePaired() {
        String s = "..AAAABBBB...AA";
        assert (this.isUniformlyBasePaired(2, 4, s));
        assert (this.isUniformlyBasePaired(6, 4, s));
        assert (!this.isUniformlyBasePaired(3, 4, s));
        assert (!this.isUniformlyBasePaired(1, 4, s));
        assert (!this.isUniformlyBasePaired(0, 2, s));
    }

    private int countTooOften(String s, int tooOftenLimit) {
        HashSet<String> alreadyChecked = new HashSet<String>();
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String cs = "" + c;
            if (alreadyChecked.contains(cs)) continue;
            alreadyChecked.add(cs);
            int n = StringTools.countChar(s, c);
            if (n <= tooOftenLimit) continue;
            result += n - tooOftenLimit;
        }
        return result;
    }

    private int countTooOftenConsecutive(String s, int tooOftenLimit, int tooOftenLimitG) {
        HashSet<String> alreadyChecked = new HashSet<String>();
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String cs = "" + c;
            alreadyChecked.add(cs);
        }
        for (String cs : alreadyChecked) {
            assert (cs.length() == 1);
            char c = cs.charAt(0);
            Pattern pattern = Pattern.compile(cs + "+");
            Matcher matcher = pattern.matcher(s);
            while (matcher.find()) {
                String stretch = matcher.group();
                if (Character.toUpperCase(c) != 'G') {
                    if (stretch.length() <= tooOftenLimit) continue;
                    result += stretch.length() - tooOftenLimit;
                    continue;
                }
                if (stretch.length() <= tooOftenLimitG) continue;
                result += stretch.length() - tooOftenLimitG;
            }
        }
        assert (result >= 0);
        return result;
    }

    @Test(groups={"new"})
    public void testCountTooOftenConsecutive() {
        String s1 = "ACGUACGUACGU";
        String s2 = "ACGUACGGUACGU";
        String s3 = "ACGUACGGGUACGU";
        String s4 = "ACCCGUACGGGUACGU";
        assert (this.countTooOftenConsecutive(s1, 1, 1) == 0);
        assert (this.countTooOftenConsecutive(s1, 2, 2) == 0);
        assert (this.countTooOftenConsecutive(s2, 1, 1) == 1);
        assert (this.countTooOftenConsecutive(s2, 2, 2) == 0);
        assert (this.countTooOftenConsecutive(s3, 1, 1) == 2);
        assert (this.countTooOftenConsecutive(s3, 1, 2) == 1);
        assert (this.countTooOftenConsecutive(s3, 1, 3) == 0);
        assert (this.countTooOftenConsecutive(s4, 1, 1) == 4);
    }

    private int countBranchMigrations(StringBuffer[] bseqs, int[][][][] interactionMatrices) {
        int nSeq = bseqs.length;
        int result = 0;
        for (int i = 0; i < nSeq; ++i) {
            for (int j = i; j < nSeq; ++j) {
                result += this.countBranchMigrations(bseqs[i], bseqs[j], interactionMatrices[i][j]);
            }
        }
        return result;
    }

    private int countBranchMigrations(StringBuffer sb1, StringBuffer sb2, int[][] mat) {
        assert (sb1.length() == mat.length);
        assert (sb2.length() == mat[0].length);
        int result = 0;
        for (int m = 0; m < mat.length; ++m) {
            int nStart = 0;
            if (sb1 == sb2) {
                nStart = m + 1;
            }
            for (int n = nStart; n < mat[m].length; ++n) {
                char c2;
                char c1;
                assert (sb1 != sb2 || mat[m][n] == mat[n][m]);
                if (mat[m][n] == -1) continue;
                if (m + 1 < mat.length && n - 1 >= 0 && mat[m + 1][n - 1] == -1 && RnaSecondaryTools.isWatsonCrick(c1 = sb1.charAt(m + 1), c2 = sb2.charAt(n - 1))) {
                    ++result;
                }
                if (m - 1 < 0 || n + 1 >= mat[m - 1].length || mat[m - 1][n + 1] != -1 || !RnaSecondaryTools.isWatsonCrick(c1 = sb1.charAt(m - 1), c2 = sb2.charAt(n + 1))) continue;
                ++result;
            }
        }
        return result;
    }

    private boolean isGC(char c) {
        return (c = Character.toUpperCase(c)) == 'G' || c == 'C';
    }

    private boolean isZipperViolation(StringBuffer seq, String sec, int pos) {
        char seqc = seq.charAt(pos);
        char secc = sec.charAt(pos);
        return !this.isGap(secc) && !this.isGC(seqc);
    }

    private int getFirstNongapPos(String sec) {
        for (int i = 0; i < sec.length(); ++i) {
            if (this.isGap(sec.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private int getLastNongapPos(String sec) {
        for (int i = sec.length() - 1; i >= 0; --i) {
            if (this.isGap(sec.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private int countZipperViolations(StringBuffer seq, String sec) {
        int n = seq.length();
        assert (n == sec.length());
        int result = 0;
        int firstPos = this.getFirstNongapPos(sec);
        int lastPos = this.getLastNongapPos(sec);
        if (firstPos >= 0) {
            if (this.isZipperViolation(seq, sec, firstPos)) {
                ++result;
            }
            if (firstPos + 1 < n && this.isZipperViolation(seq, sec, firstPos + 1)) {
                ++result;
            }
        }
        if (lastPos >= 0) {
            if (this.isZipperViolation(seq, sec, lastPos)) {
                ++result;
            }
            if (lastPos - 1 >= 0 && this.isZipperViolation(seq, sec, lastPos - 1)) {
                ++result;
            }
        }
        return result;
    }

    @Test(groups={"new"})
    public void testCountZipperViolations() {
        StringBuffer seq1 = new StringBuffer("ACG");
        StringBuffer seq2 = new StringBuffer("CCG");
        StringBuffer seq3 = new StringBuffer("ACU");
        String sec1 = "A-B";
        String sec2 = "---";
        assert (this.countZipperViolations(seq1, sec1) == 1);
        assert (this.countZipperViolations(seq1, sec2) == 0);
        assert (this.countZipperViolations(seq2, sec2) == 0);
        assert (this.countZipperViolations(seq2, sec1) == 0);
        assert (this.countZipperViolations(seq3, sec1) == 2);
        assert (this.countZipperViolations(seq3, sec2) == 0);
    }

    private int countSingleStrandDist(String sec, int pos) {
        char currPos = sec.charAt(pos);
        if (this.isGap(currPos)) {
            return 0;
        }
        for (int i = 0; i < sec.length(); ++i) {
            int minPos = pos - i;
            int maxPos = pos + i;
            if (minPos < 0 || currPos != sec.charAt(minPos)) {
                return i;
            }
            if (maxPos < sec.length() && currPos == sec.charAt(maxPos)) continue;
            return i;
        }
        return sec.length();
    }

    @Test(groups={"new"})
    private void testCountSingleStrandDist() {
        String methodName = "testCountSingleStrandDist";
        System.out.println(TestTools.generateMethodHeader(methodName));
        String[] secs = new String[]{"AAAAA", "-AAAAA-", "-AAAAA---BBBBB--", "-AAAAABBBBB--"};
        for (int i = 0; i < secs[0].length(); ++i) {
            System.out.println(this.countSingleStrandDist(secs[0], i));
        }
        assert (this.countSingleStrandDist(secs[0], 0) == 1);
        assert (this.countSingleStrandDist(secs[0], 1) == 2);
        assert (this.countSingleStrandDist(secs[0], 2) == 3);
        assert (this.countSingleStrandDist(secs[0], 3) == 2);
        assert (this.countSingleStrandDist(secs[0], 4) == 1);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    private int countZipperViolations2Pos(StringBuffer seq, String sec, int pos) {
        if (this.isGC(seq.charAt(pos))) {
            return 0;
        }
        int distSingleStrand = this.countSingleStrandDist(sec, pos);
        int result = 0;
        if (distSingleStrand > 0 && distSingleStrand <= this.zipperLength) {
            result = 1;
        }
        return result;
    }

    private int countZipperViolations2(StringBuffer seq, String sec) {
        int n = seq.length();
        assert (n == sec.length());
        int result = 0;
        for (int i = 0; i < n; ++i) {
            result += this.countZipperViolations2Pos(seq, sec, i);
        }
        return result;
    }

    private int countAUViolations(StringBuffer seq, String sec) {
        int n = seq.length();
        assert (n == sec.length());
        int result = 0;
        int pc = 0;
        for (int i = 0; i < n; ++i) {
            boolean reset = false;
            char c = seq.charAt(i);
            char cs = sec.charAt(i);
            if (this.isGap(cs) || i > 0 && cs != sec.charAt(i - 1) || this.isGC(c)) {
                reset = true;
            } else {
                ++pc;
            }
            if (!reset) continue;
            if (pc > this.auLim) {
                result += pc - this.auLim;
            }
            pc = 0;
        }
        if (pc > this.auLim) {
            result += pc - this.auLim;
        }
        return result;
    }

    private int countGCViolations(StringBuffer seq, String sec) {
        int n = seq.length();
        assert (n == sec.length());
        int result = 0;
        int pc = 0;
        for (int i = 0; i < n; ++i) {
            boolean reset = false;
            char c = seq.charAt(i);
            char cs = sec.charAt(i);
            if (this.isGap(cs) || i > 0 && cs != sec.charAt(i - 1) || !this.isGC(c)) {
                reset = true;
            } else {
                ++pc;
            }
            if (!reset) continue;
            if (pc > this.gcLim) {
                result += pc - this.gcLim;
            }
            pc = 0;
        }
        if (pc > this.gcLim) {
            result += pc - this.gcLim;
        }
        return result;
    }

    private int countGCFracViolations(StringBuffer seq, String sec) {
        int n = seq.length();
        assert (n == sec.length());
        assert (n > 0);
        int result = 0;
        int firstPos = -1;
        int lastPos = -1;
        int gcCount = 0;
        for (int i = 0; i < n; ++i) {
            boolean reset = false;
            char c = seq.charAt(i);
            char cs = sec.charAt(i);
            if (!(i <= 0 || this.isGap(sec.charAt(i - 1)) || cs == sec.charAt(i - 1) && i != n - 1)) {
                assert (firstPos >= 0);
                lastPos = i;
                int gcMin = (int)(this.gcMinFrac * (double)(lastPos - firstPos));
                if (gcCount < gcMin) {
                    result += gcMin - gcCount;
                }
                firstPos = -1;
                lastPos = -1;
                gcCount = 0;
            }
            if (this.isGap(cs)) continue;
            if (firstPos < 0) {
                firstPos = i;
            }
            if (!this.isGC(c)) continue;
            ++gcCount;
        }
        return result;
    }

    @Test(groups={"new"})
    public void testGCFracViolations() {
        String methodName = "testGCFracViolations";
        System.out.println(TestTools.generateMethodHeader(methodName));
        StringBuffer seq1 = new StringBuffer("GAAAAC");
        StringBuffer seq2 = new StringBuffer("CCGCAC");
        StringBuffer seq3 = new StringBuffer("ACUUAG");
        StringBuffer seq4 = new StringBuffer("ACUUAGAUAUAG");
        String sec1 = "AAAAAA";
        String sec2 = "------";
        String sec4 = "AAAAAAAAAAAA";
        System.out.println(this.countZipperViolations(seq1, sec1));
        System.out.println(this.countGCFracViolations(seq1, sec2));
        System.out.println(this.countGCFracViolations(seq2, sec2));
        System.out.println(this.countGCFracViolations(seq2, sec1));
        System.out.println(this.countGCFracViolations(seq3, sec1));
        System.out.println(this.countGCFracViolations(seq3, sec2));
        System.out.println(this.countGCFracViolations(seq4, sec4));
        assert (this.countGCFracViolations(seq1, sec1) > 0);
        assert (this.countGCFracViolations(seq1, sec2) == 0);
        assert (this.countGCFracViolations(seq2, sec2) == 0);
        assert (this.countGCFracViolations(seq2, sec1) == 0);
        assert (this.countGCFracViolations(seq3, sec1) > 0);
        assert (this.countGCFracViolations(seq3, sec2) == 0);
        assert (this.countGCFracViolations(seq4, sec4) > 0);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testAUViolations() {
        String methodName = "testAUViolations";
        System.out.println(TestTools.generateMethodHeader(methodName));
        StringBuffer seq1 = new StringBuffer("GAAAAC");
        StringBuffer seq2 = new StringBuffer("CCGCAC");
        StringBuffer seq3 = new StringBuffer("ACUUAG");
        StringBuffer seq4 = new StringBuffer("ACUUAGAUAUAG");
        String sec1 = "AAAAAA";
        String sec2 = "------";
        String sec4 = "AAAAAAAAAAAA";
        System.out.println(this.countZipperViolations(seq1, sec1));
        System.out.println(this.countAUViolations(seq1, sec2));
        System.out.println(this.countAUViolations(seq2, sec2));
        System.out.println(this.countAUViolations(seq2, sec1));
        System.out.println(this.countAUViolations(seq3, sec1));
        System.out.println(this.countAUViolations(seq3, sec2));
        System.out.println(this.countAUViolations(seq4, sec4));
        assert (this.countAUViolations(seq1, sec1) == 1);
        assert (this.countAUViolations(seq1, sec2) == 0);
        assert (this.countAUViolations(seq2, sec2) == 0);
        assert (this.countAUViolations(seq2, sec1) == 0);
        assert (this.countAUViolations(seq3, sec1) == 0);
        assert (this.countAUViolations(seq3, sec2) == 0);
        assert (this.countAUViolations(seq4, sec4) == 2);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testCountZipperViolations2() {
        String methodName = "testCountZipperViolations2";
        System.out.println(TestTools.generateMethodHeader(methodName));
        StringBuffer seq1 = new StringBuffer("ACGG");
        StringBuffer seq2 = new StringBuffer("CCGG");
        StringBuffer seq3 = new StringBuffer("ACUG");
        StringBuffer seq4 = new StringBuffer("gggaaauuCUAGAGUGUAuuguugccGCGUuuAUACUGGAUGuuUCGC");
        StringBuffer seq4b = new StringBuffer("gggaaauuGCUCUCGUGUuuguugccCCUGuuAAGGCAUCGAuuUUGG");
        String sec4 = "QQQQQQ..PPPPPPPPPP..MMMMMMNNNN..EEEEEEEEEE..RRRR";
        String sec1 = "AAAA";
        String sec2 = "----";
        System.out.println("" + this.countZipperViolations2(seq1, sec1) + " 1");
        System.out.println("" + this.countZipperViolations2(seq1, sec2) + " 0");
        System.out.println("" + this.countZipperViolations2(seq2, sec2) + " 0");
        System.out.println("" + this.countZipperViolations2(seq2, sec1) + " 0");
        System.out.println("" + this.countZipperViolations2(seq3, sec1) + " 2");
        System.out.println("" + this.countZipperViolations2(seq3, sec2) + " 0");
        System.out.println("" + this.countZipperViolations2(seq4, sec4) + " 11");
        System.out.println("" + this.countZipperViolations2(seq4, sec4) + " 12");
        assert (this.countZipperViolations2(seq1, sec1) == 1);
        assert (this.countZipperViolations2(seq1, sec2) == 0);
        assert (this.countZipperViolations2(seq2, sec2) == 0);
        assert (this.countZipperViolations2(seq2, sec1) == 0);
        assert (this.countZipperViolations2(seq3, sec1) == 2);
        assert (this.countZipperViolations2(seq3, sec2) == 0);
        assert (this.countZipperViolations2(seq4, sec4) == 11);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    private int countZipperViolations(StringBuffer[] bseqs, String[] secStrings) {
        assert (bseqs.length == secStrings.length);
        int result = 0;
        for (int i = 0; i < bseqs.length; ++i) {
            result += this.countZipperViolations(bseqs[i], secStrings[i]);
        }
        return result;
    }

    private int countZipperViolations2(StringBuffer[] bseqs, String[] secStrings) {
        assert (bseqs.length == secStrings.length);
        int result = 0;
        for (int i = 0; i < bseqs.length; ++i) {
            result += this.countZipperViolations2(bseqs[i], secStrings[i]);
        }
        return result;
    }

    @Test(groups={"new"})
    public void testCountBranchMigrations() {
        String methodName = "testCountBranchMigrations";
        System.out.println(TestTools.generateMethodHeader(methodName));
        int[][][][] mats1 = new int[1][1][6][6];
        int[][][][] mats2 = new int[1][1][6][6];
        int[][][][] mats3 = new int[1][1][6][6];
        IntegerArrayTools.fill(mats1[0][0], -1);
        IntegerArrayTools.fill(mats2[0][0], -1);
        IntegerArrayTools.fill(mats3[0][0], -1);
        mats1[0][0][1][4] = 1;
        mats1[0][0][4][1] = 1;
        mats2[0][0][0][4] = 1;
        mats2[0][0][4][0] = 1;
        mats3[0][0][0][3] = 1;
        mats3[0][0][3][0] = 1;
        StringBuffer sb1 = new StringBuffer("AAAUUU");
        StringBuffer[] sbs = new StringBuffer[]{sb1};
        System.out.println("Found branch migrations: " + this.countBranchMigrations(sbs, mats1) + " " + this.countBranchMigrations(sbs, mats2) + " " + this.countBranchMigrations(sbs, mats3));
        assert (this.countBranchMigrations(sbs, mats1) == 2);
        assert (this.countBranchMigrations(sbs, mats2) == 1);
        assert (this.countBranchMigrations(sbs, mats3) == 0);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        String scoreString = this.generateReport(bseqs, structure, interactionMatrices, 0).getProperty("score");
        assert (scoreString != null);
        return Double.parseDouble(scoreString);
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        return this.generateReport(bseqs, structure, interactionMatrices, 10);
    }

    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices, int verbosity) {
        int numberTooOftenCounts;
        int i;
        Properties resultProperties = new Properties();
        double score = 0.0;
        SecondaryStructureScriptFormatWriter secWriter = new SecondaryStructureScriptFormatWriter();
        List<String[]> secStringArrays = secWriter.writeSecondaryStructure(structure);
        String[] secStrings = new String[secStringArrays.size()];
        for (int i2 = 0; i2 < secStringArrays.size(); ++i2) {
            secStrings[i2] = StringTools.paste(secStringArrays.get(i2), "");
            if (this.debugLevel <= 0) continue;
            System.out.println(bseqs[i2].toString());
            System.out.println(secStrings[i2]);
        }
        assert (secStrings.length == structure.getSequenceCount());
        String[][] critons = new String[bseqs.length][];
        String[][] smallCritons = new String[bseqs.length][];
        HashSet<String> critSet = new HashSet<String>();
        HashSet<String> complSet = new HashSet<String>();
        Set[] smallComplSets = null;
        smallComplSets = (Set[])Array.newInstance(Set.class, bseqs.length);
        HashSet<String> bulgeSet = new HashSet<String>();
        HashSet<String> bulgeCompSet = new HashSet<String>();
        int critCount = 0;
        int critonLen2 = this.critonLen - 2;
        for (int i3 = 0; i3 < bseqs.length; ++i3) {
            int j;
            smallComplSets[i3] = new HashSet();
            critons[i3] = this.createCritons(bseqs[i3].toString(), this.critonLen);
            smallCritons[i3] = this.createCritons(bseqs[i3].toString(), critonLen2);
            String[] bulgeCritons = this.createCritons(bseqs[i3].toString(), this.critonLen + 1);
            for (j = 0; j < critons[i3].length; ++j) {
                critSet.add(critons[i3][j].toLowerCase());
                complSet.add(RnaSecondaryTools.getRnaComplement(critons[i3][j]).toLowerCase());
                if (j >= bulgeCritons.length) continue;
                bulgeSet.add(bulgeCritons[j].toLowerCase());
                bulgeCompSet.add(RnaSecondaryTools.getRnaComplement(bulgeCritons[j]).toLowerCase());
            }
            for (j = 0; j < smallCritons[i3].length; ++j) {
                smallComplSets[i3].add(RnaSecondaryTools.getRnaComplement(smallCritons[i3][j]).toLowerCase());
            }
            critCount += critons[i3].length;
        }
        int duplicateCount = critCount - critSet.size();
        assert (duplicateCount >= 0);
        double auViolationTerm = 0.0;
        double duplicateTerm = (double)duplicateCount * this.nonUniquePenalty;
        double complementTerm = 0.0;
        double selfComplementTerm = 0.0;
        double consecutiveTerm = 0.0;
        double branchMigrationTerm = 0.0;
        double bulgesTerm = 0.0;
        double bulgesComplementTerm = 0.0;
        double gcViolationTerm = 0.0;
        double simTerm = 0.0;
        double simComplementTerm = 0.0;
        double zipperTerm = 1.0;
        double smallComplTerm = 0.0;
        double smallComplWeight = 0.1;
        for (i = 0; i < critons.length; ++i) {
            int j;
            for (j = 0; j < critons[i].length; ++j) {
                int n;
                String criton = critons[i][j];
                if (this.complementPenalty != 0.0 && complSet.contains(criton) && this.unwantedComplementExists(critons, i, j, interactionMatrices)) {
                    complementTerm += this.complementPenalty;
                }
                if (this.selfComplementPenalty != 0.0 && this.isSelfComplementary(criton)) {
                    selfComplementTerm += this.selfComplementPenalty;
                }
                if (this.bulgePenalty != 0.0) {
                    String[] bulges = this.findAllBulges(criton);
                    for (n = 0; n < bulges.length; ++n) {
                        if (bulgeSet.contains(bulges[n].toLowerCase())) {
                            bulgesTerm += this.bulgePenalty;
                        }
                        if (!bulgeCompSet.contains(bulges[n].toLowerCase())) continue;
                        bulgesComplementTerm += this.bulgePenalty;
                    }
                }
                if (this.similarPenalty == 0.0) continue;
                String[] similar = this.findAllSimilar(criton);
                for (n = 0; n < similar.length; ++n) {
                    if (critSet.contains(similar[n].toLowerCase())) {
                        simTerm += this.similarPenalty;
                    }
                    if (!complSet.contains(similar[n].toLowerCase())) continue;
                    simComplementTerm += this.similarPenalty;
                }
            }
            if (smallComplWeight == 0.0) continue;
            for (j = 0; j < smallCritons[i].length; ++j) {
                if (smallComplSets[i].contains(smallCritons[i][j])) continue;
                smallComplTerm += smallComplWeight;
            }
        }
        if (this.auViolationWeight != 0.0) {
            for (i = 0; i < bseqs.length; ++i) {
                numberTooOftenCounts = this.countAUViolations(bseqs[i], secStrings[i]);
                auViolationTerm += this.auViolationWeight * (double)numberTooOftenCounts;
            }
        }
        if (this.gcViolationWeight != 0.0) {
            for (i = 0; i < bseqs.length; ++i) {
                numberTooOftenCounts = this.countGCViolations(bseqs[i], secStrings[i]);
                gcViolationTerm += this.gcViolationWeight * (double)numberTooOftenCounts;
            }
        }
        if (this.consecutiveWeight != 0.0) {
            for (i = 0; i < bseqs.length; ++i) {
                numberTooOftenCounts = this.countTooOftenConsecutive(bseqs[i].toString(), this.consecutiveLimit, this.consecutiveLimitG);
                consecutiveTerm += this.consecutiveWeight * (double)numberTooOftenCounts;
            }
        }
        if (this.branchMigrationWeight != 0.0) {
            branchMigrationTerm = this.branchMigrationWeight * (double)this.countBranchMigrations(bseqs, interactionMatrices);
        }
        if (this.zipperWeight != 0.0) {
            zipperTerm = this.zipperWeight * (double)this.countZipperViolations2(bseqs, secStrings);
        }
        double defaultScoreTerm = 0.0;
        if (this.defaultScorerWeight != 0.0) {
            defaultScoreTerm = this.defaultScorerWeight * this.defaultScorer.scoreStructure(bseqs, structure, interactionMatrices);
        }
        double gcMinFracTerm = 0.0;
        if (this.gcMinFracWeight != 0.0) {
            for (int i4 = 0; i4 < bseqs.length; ++i4) {
                int numberTooOftenCounts2 = this.countGCFracViolations(bseqs[i4], secStrings[i4]);
                gcMinFracTerm += this.gcMinFracWeight * (double)numberTooOftenCounts2;
            }
        }
        score = defaultScoreTerm + duplicateTerm + complementTerm + smallComplTerm + selfComplementTerm + consecutiveTerm + branchMigrationTerm + bulgesTerm + bulgesComplementTerm + gcViolationTerm + simTerm + simComplementTerm + zipperTerm + auViolationTerm + gcMinFracTerm;
        if (this.debugLevel > 0) {
            this.log.info("Total score, default score, duplicate, complement, smallComplement, selfComplement, consecutive, branch-migration, bulges, bulgesComplement, gcViolationTerm, sim, simComlement, zipper, auViolation, gcMinFracWeight: " + score + " " + defaultScoreTerm + " " + duplicateTerm + " " + complementTerm + " " + smallComplTerm + " " + selfComplementTerm + " " + consecutiveTerm + " " + branchMigrationTerm + " " + bulgesTerm + " " + bulgesComplementTerm + " " + gcViolationTerm + " " + simTerm + " " + simComplementTerm + " " + zipperTerm + " " + auViolationTerm + " " + gcMinFracTerm);
        }
        assert (score >= 0.0);
        resultProperties.setProperty("score", "" + score);
        if (verbosity > 1 && this.defaultScorer != null && this.defaultScorerWeight != 0.0) {
            PropertyTools.mergeProperties(resultProperties, this.defaultScorer.generateReport(bseqs, structure, interactionMatrices), "subscorer.");
        }
        return resultProperties;
    }
}

