/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import rnasecondary.MatchFoldSecondaryStructurePredictor;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import secondarystructuredesign.AbstractSecondaryStructureScorer;
import sequence.DuplicateNameException;
import sequence.UnevenAlignment;
import sequence.UnknownSymbolException;

public class MatchFoldSecondaryStructureScorer
extends AbstractSecondaryStructureScorer {
    private double scale = 1.0;
    private Level debugLevel = Level.FINE;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        UnevenAlignment ali;
        block6: {
            ali = null;
            try {
                ali = this.generateAlignment(bseqs);
            }
            catch (UnknownSymbolException use) {
                System.out.println(use.getMessage());
                assert (false);
            }
            catch (DuplicateNameException dne) {
                System.out.println(dne.getMessage());
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        MatchFoldSecondaryStructurePredictor predictor = new MatchFoldSecondaryStructurePredictor(ali);
        predictor.run();
        SecondaryStructure prediction = (SecondaryStructure)predictor.getResult();
        assert (prediction != null);
        double result = this.scorePrediction(prediction, structure, interactionMatrices);
        assert (result >= 0.0);
        return result;
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        UnevenAlignment ali;
        Properties resultProperties;
        block6: {
            resultProperties = new Properties();
            ali = null;
            try {
                ali = this.generateAlignment(bseqs);
            }
            catch (UnknownSymbolException use) {
                System.out.println(use.getMessage());
                assert (false);
            }
            catch (DuplicateNameException dne) {
                System.out.println(dne.getMessage());
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        MatchFoldSecondaryStructurePredictor predictor = new MatchFoldSecondaryStructurePredictor(ali);
        predictor.run();
        SecondaryStructure prediction = (SecondaryStructure)predictor.getResult();
        resultProperties.setProperty("prediction", new SecondaryStructureScriptFormatWriter().writeString(prediction));
        assert (prediction != null);
        double result = this.scorePrediction(prediction, structure, interactionMatrices);
        resultProperties.setProperty("score", "" + result);
        assert (result >= 0.0);
        return resultProperties;
    }
}

