/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.ParsingException;
import generaltools.StringTools;
import generaltools.TestTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import org.testng.annotations.Test;
import rnasecondary.SecondaryStructure;
import secondarystructuredesign.NupackTools;
import secondarystructuredesign.RnaFoldTools;
import secondarystructuredesign.SecondaryStructureScorer;

public class NupackStructureScorer
implements SecondaryStructureScorer {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private static ResourceBundle rb = ResourceBundle.getBundle("SecondaryStructureDesign");
    private static String complexesScriptName = rb.getString("nupackComplexes");
    private static String concentrationsScriptName = rb.getString("nupackConcentrations");
    private double energyAU = -0.8;
    private double energyGC = -1.2;
    private double[] initConcentrations;
    public final double DEFAULT_CONC = Math.pow(10.0, -6.0);
    public final double CONC_WEIGHT = Math.pow(10.0, 6.0);
    public static final int maxComplexSize = 3;
    public static final double cGap = 0.0;

    public double interactionEnergy(char c1, char c2) {
        if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
            return 0.0;
        }
        if (c1 > c2) {
            return this.interactionEnergy(c2, c1);
        }
        switch (c1) {
            case 'A': {
                if (c2 == 'U') {
                    return this.energyAU;
                }
            }
            case 'C': {
                if (c2 != 'G') break;
                return this.energyGC;
            }
        }
        return 0.0;
    }

    public void setInitConcentrations(double[] concentrations) {
        this.initConcentrations = new double[concentrations.length];
        for (int i = 0; i < concentrations.length; ++i) {
            this.initConcentrations[i] = concentrations[i];
        }
    }

    public void setDefaultConcentrations(int numStrands) {
        this.initConcentrations = new double[numStrands];
        for (int i = 0; i < numStrands; ++i) {
            this.initConcentrations[i] = this.DEFAULT_CONC;
        }
    }

    String[][] launchComplexes(String[] sequences, int maxComplexSize, String outputName) throws IOException {
        File tmpInputFile = File.createTempFile("input", ".txt");
        String inputFileName = tmpInputFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(tmpInputFile);
        PrintStream ps = new PrintStream(fos);
        this.log.fine("Writing to file: " + inputFileName);
        ps.println(outputName);
        ps.println(sequences.length);
        for (int i = 0; i < sequences.length; ++i) {
            ps.println(sequences[i]);
        }
        ps.println(maxComplexSize);
        fos.close();
        File tempFile = new File(complexesScriptName);
        String[] commandWords = new String[]{complexesScriptName, inputFileName, outputName};
        String[] outputFilenames = new String[]{outputName + ".cx", outputName + ".ocx-mfe"};
        String[][] rawOutput = this.runScript(commandWords, outputFilenames);
        if (tmpInputFile != null) {
            tmpInputFile.delete();
        }
        return rawOutput;
    }

    String[] launchConcentrations(String filePrefix, int numSequences, double[] concentrations) throws IOException {
        assert (concentrations.length == numSequences);
        String inputFileName = filePrefix + ".con";
        File inputFile = new File(inputFileName);
        FileOutputStream fos = new FileOutputStream(inputFile);
        PrintStream ps = new PrintStream(fos);
        this.log.fine("Writing to file: " + inputFileName);
        for (int i = 0; i < numSequences; ++i) {
            ps.println(concentrations[i]);
        }
        fos.close();
        File tempFile = new File(concentrationsScriptName);
        String[] commandWords = new String[]{concentrationsScriptName, filePrefix};
        String[] outputFilenames = new String[]{filePrefix + ".eq"};
        String[][] rawOutput = this.runScript(commandWords, outputFilenames);
        if (inputFile != null) {
            inputFile.delete();
        }
        return rawOutput[0];
    }

    private String[][] runScript(String[] commandWords, String[] outputFilenames) throws IOException {
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        this.log.fine("queue manager finished job!");
        String[][] results = new String[outputFilenames.length][];
        for (int i = 0; i < outputFilenames.length; ++i) {
            this.log.fine("Reading results from " + outputFilenames[i]);
            String[] resultLines = null;
            FileInputStream resultFile = null;
            try {
                resultFile = new FileInputStream(outputFilenames[i]);
                resultLines = StringTools.readAllLines(resultFile);
            }
            catch (IOException ioe) {
                this.log.warning("Error when scraping result file from: " + outputFilenames[i]);
                throw ioe;
            }
            finally {
                if (resultFile != null) {
                    resultFile.close();
                }
            }
            if (resultLines == null) {
                this.log.warning("Results were null!");
            }
            results[i] = resultLines;
        }
        return results;
    }

    private boolean firstTier(int[] complex) {
        return complex[0] == 1 && complex[1] == 1 && complex[2] == 1;
    }

    private boolean secondTier(int[] complex) {
        for (int i = 0; i < complex.length; ++i) {
            if (i < 2 && complex[i] != 1) {
                return false;
            }
            if (i < 2 || complex[i] == 0) continue;
            return false;
        }
        return true;
    }

    private boolean thirdTier(int[] complex) {
        int first1Index = 0;
        if (complex[0] != 0) {
            return false;
        }
        for (int i = 1; i < complex.length - 2; ++i) {
            if (complex[i] != 1 || complex[i - 1] != 0) continue;
            first1Index = i;
            break;
        }
        return complex[first1Index + 1] == 1 && complex[first1Index + 2] == 1;
    }

    private double compareComplexes(double greaterConc, double smallerConc) {
        if (greaterConc > smallerConc + 0.0) {
            return 0.0;
        }
        return 0.0 + smallerConc - greaterConc;
    }

    private double scoreMFEStructures(String[] mfeStructures, int[][][] interactionMatrices) {
        double result = 0.0;
        for (int i = 0; i < mfeStructures.length; ++i) {
            String bracket = mfeStructures[i];
            int[][] predictedInteractions = RnaFoldTools.parseRnacofoldBracketInteractions(bracket);
            result += RnaFoldTools.computeMatrixDifference(interactionMatrices[i], predictedInteractions) / 2.0;
        }
        return result / (double)mfeStructures.length;
    }

    private double scoreComplexConcentrations(String[] unorderedOutput, String[] orderedOutput) {
        int i;
        double score = 0.0;
        ArrayList[] tiers = new ArrayList[4];
        for (i = 0; i < tiers.length; ++i) {
            tiers[i] = new ArrayList();
        }
        for (i = 0; i < unorderedOutput.length; ++i) {
            int[] complex = NupackTools.findComplex(unorderedOutput, i + 1);
            if (this.firstTier(complex)) {
                tiers[0].add(complex);
                continue;
            }
            if (this.secondTier(complex)) {
                tiers[1].add(complex);
                continue;
            }
            if (this.thirdTier(complex)) {
                tiers[2].add(complex);
                continue;
            }
            tiers[3].add(complex);
        }
        for (i = 0; i < tiers.length - 1; ++i) {
            for (int[] greater : tiers[i]) {
                double greaterEn = NupackTools.findConcentration(greater, orderedOutput, unorderedOutput) * this.CONC_WEIGHT;
                for (int[] smaller : tiers[i + 1]) {
                    double smallerEn = NupackTools.findConcentration(smaller, orderedOutput, unorderedOutput) * this.CONC_WEIGHT;
                    score += this.compareComplexes(greaterEn, smallerEn);
                }
            }
        }
        return score;
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        assert (false);
        return null;
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        double score = 0.0;
        int numStrands = bseqs.length;
        String outputName = "output";
        String[] seqs = new String[numStrands];
        for (int i = 0; i < bseqs.length; ++i) {
            seqs[i] = bseqs[i].toString();
        }
        try {
            String[][] complexesOutput = this.launchComplexes(seqs, 3, outputName);
            String[] unorderedRawOutput = complexesOutput[0];
            if (this.initConcentrations == null) {
                this.setDefaultConcentrations(numStrands);
            }
            String[] orderedRawOutput = this.launchConcentrations(outputName, numStrands, this.initConcentrations);
            String[] unorderedOutput = NupackTools.findRelevantData(unorderedRawOutput);
            String[] orderedOutput = NupackTools.findRelevantData(orderedRawOutput);
            System.out.println("Score from complexes = " + (score += this.scoreComplexConcentrations(unorderedOutput, orderedOutput)));
            String[] mfeRawOutput = complexesOutput[1];
            int numDimers = numStrands * (numStrands - 1) / 2;
            String[] mfeStructures = new String[numDimers];
            int[][][] matrices = new int[numDimers][][];
            int[] currComplex = new int[numStrands];
            for (int i = 0; i < numStrands; ++i) {
                currComplex[i] = 0;
            }
            int x = 0;
            int y = 0;
            for (int i = 0; i < numDimers; ++i) {
                String struct;
                currComplex[x] = 0;
                currComplex[y] = 0;
                if (++y >= numStrands) {
                    y = ++x + 1;
                }
                currComplex[x] = 1;
                currComplex[y] = 1;
                matrices[i] = interactionMatrices[x][y];
                int index = NupackTools.findIndex(currComplex, orderedOutput);
                mfeStructures[i] = struct = NupackTools.parseNupackMFEStructure(mfeRawOutput, index);
            }
            double subscore = this.scoreMFEStructures(mfeStructures, matrices);
            System.out.println("Score from MFE structure = " + subscore);
            System.out.println("Total score = " + (score += subscore));
        }
        catch (IOException ioe) {
            this.log.severe("Error launching NUPACK! Error message: " + ioe.getMessage());
            return 0.0;
        }
        return score;
    }

    @Test(groups={"new"})
    public void testScoreStructure() throws IOException, ParsingException {
        int i;
        String methodName = "testScoreStructure";
        System.out.println(TestTools.generateMethodHeader(methodName));
        StringBuffer seq1 = new StringBuffer("ggccggaaaaaaaauu");
        StringBuffer seq2 = new StringBuffer("uuuuaauuuuaaaaaa");
        StringBuffer seq3 = new StringBuffer("uuuuuuaaaauuccuu");
        StringBuffer seq4 = new StringBuffer("aaggaauuuuccggcc");
        int[][][][] interactions = new int[4][4][16][16];
        for (i = 0; i < interactions.length; ++i) {
            for (int j = 0; j < interactions[0].length; ++j) {
                interactions[i][j] = this.initializeblank(16, 16);
            }
        }
        for (i = 0; i < 6; ++i) {
            interactions[0][1][10 + i][i] = 1;
            interactions[1][0][i][10 + i] = 1;
            interactions[1][2][10 + i][i] = 1;
            interactions[2][1][i][10 + i] = 1;
            interactions[2][3][10 + i][i] = 1;
            interactions[3][2][i][10 + i] = 1;
            interactions[0][3][i][10 + i] = 1;
            interactions[3][0][10 + i][i] = 1;
        }
        StringBuffer[] strands = new StringBuffer[]{seq1, seq2, seq3, seq4};
        double score = this.scoreStructure(strands, null, interactions);
        System.out.println("Score = " + score);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    private int[][] initializeblank(int width, int height) {
        int[][] inter = new int[width][height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                inter[i][j] = -1;
            }
        }
        return inter;
    }
}

