/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import sequence.Alphabet;
import sequence.SimpleAlphabet;
import sequence.SimpleSequence;
import sequence.UnknownSymbolException;

public class DnaTools {
    public static final String AMBIGUOUS_DNA_LETTERS = "ACGTN";
    public static final String AMBIGUOUS_RNA_LETTERS = "ACGUNSW";
    public static final String DNA_LETTERS = "ACGT";
    public static final String RNA_LETTERS = "ACGU";
    public static final String DNA_RNA_LETTERS = "ACGUT";
    public static final Alphabet AMBIGUOUS_DNA_ALPHABET = new SimpleAlphabet("ACGTN", 1);
    public static final Alphabet AMBIGUOUS_RNA_ALPHABET = new SimpleAlphabet("ACGUNSW", 3);
    public static final Alphabet DNA_ALPHABET = new SimpleAlphabet("ACGT", 2);
    public static final Alphabet RNA_ALPHABET = new SimpleAlphabet("ACGU", 4);
    public static final Alphabet DNA_RNA_ALPHABET = new SimpleAlphabet("ACGUT", 6);

    public static boolean isWatsonCrick(char c1, char c2) {
        if (c2 < c1) {
            char help = c2;
            c2 = c1;
            c1 = help;
        }
        return c1 == 'A' && (c2 == 'U' || c2 == 'T') || c1 == 'C' && c2 == 'G';
    }

    public static boolean isWobble(char c1, char c2) {
        if (c2 < c1) {
            char help = c2;
            c2 = c1;
            c1 = help;
        }
        return c1 == 'G' && (c2 == 'T' || c2 == 'U');
    }

    public static boolean isComplementary(char c1, char c2) {
        return DnaTools.isWatsonCrick(c1, c2) || DnaTools.isWobble(c1, c2);
    }

    public static boolean checkSequenceCompatible(String s, Alphabet alphabet) {
        boolean result = true;
        try {
            SimpleSequence seq = new SimpleSequence(s, "dummyname", alphabet);
        }
        catch (UnknownSymbolException use) {
            result = false;
        }
        return result;
    }

    public static boolean checkSequencesCompatible(String[] sequences, Alphabet alphabet) {
        for (String s : sequences) {
            if ((s = s.trim()).length() <= 0 || s.charAt(0) == '>' || DnaTools.checkSequenceCompatible(s, alphabet)) continue;
            return false;
        }
        return true;
    }

    public static String[] translateTU(String[] sequences) {
        String[] result = sequences;
        for (int i = 0; i < sequences.length; ++i) {
            if (result[i].length() <= 0 || result[i].charAt(0) == '>') continue;
            result[i] = sequences[i].replaceAll("T", "U");
        }
        return result;
    }

    public static String[] translateUT(String[] sequences) {
        String[] result = sequences;
        for (int i = 0; i < sequences.length; ++i) {
            if (result[i].length() <= 0 || result[i].charAt(0) == '>') continue;
            result[i] = sequences[i].replaceAll("U", "T");
        }
        return result;
    }
}

