/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import java.util.ArrayList;
import java.util.List;
import sequence.Residue;
import sequence.Sequence;
import sequence.SequenceSubset;

public class SimpleSequenceSubset
implements SequenceSubset {
    private Sequence sequence;
    private Sequence subsetSequence;
    private List<Integer> indices = new ArrayList<Integer>();

    public SimpleSequenceSubset() {
    }

    public SimpleSequenceSubset(Sequence s, int startPos, int length) {
        this.sequence = s;
        for (int i = 0; i < length; ++i) {
            this.addIndex(startPos + length);
        }
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public Sequence getSubsetSequence() {
        return this.subsetSequence;
    }

    @Override
    public void addIndex(int pos) {
        this.indices.add(new Integer(pos));
        this.update();
    }

    @Override
    public int getIndex(int n) {
        Integer integer = this.indices.get(n);
        return integer;
    }

    @Override
    public Residue getResidue(int n) {
        return this.sequence.getResidue(this.getIndex(n));
    }

    @Override
    public void setSequence(Sequence s) {
        this.sequence = s;
        this.update();
    }

    @Override
    public int size() {
        return this.indices.size();
    }

    @Override
    public String toString() {
        String result = "(Subset " + ((Object)this.sequence).toString() + " ";
        result = result + this.size() + " ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + (this.getIndex(i) + 1) + " ";
        }
        result = result + " ) ";
        return result;
    }

    private void update() {
        this.subsetSequence = null;
    }
}

