/*
 * Decompiled with CFR 0.152.
 */
package symmetry;

import generaltools.StringTools;
import symmetry.PackageConstants;
import symmetry.SpaceGroup;
import symmetry.SpaceGroupConvention;

public class DefaultSpaceGroup
implements SpaceGroup {
    private int number;
    private String[] names;

    public DefaultSpaceGroup(int number, String[] names) {
        assert (number != 0);
        assert (names.length == SpaceGroupConvention.COUNT);
        this.number = number;
        this.names = names;
    }

    public DefaultSpaceGroup() {
        this.number = 0;
        this.names = new String[SpaceGroupConvention.COUNT];
    }

    @Override
    public Object clone() {
        assert (this.names != null);
        assert (this.names.length == SpaceGroupConvention.COUNT);
        String[] clonedNames = StringTools.cloneLines(this.names);
        return new DefaultSpaceGroup(this.number, clonedNames);
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public boolean isValid() {
        return this.number > 0 && this.names != null && this.names.length > 0;
    }

    @Override
    public void setNumber(int number) {
        assert (number > 0);
        this.number = number;
    }

    @Override
    public String getName() {
        return this.getName(0);
    }

    @Override
    public void setName(String name) {
        this.setName(name, 0);
    }

    @Override
    public String getName(String convention) {
        int conventionId = SpaceGroupConvention.findConventionId(convention);
        return this.getName(conventionId);
    }

    @Override
    public void setName(String name, String convention) {
        int conventionId = SpaceGroupConvention.findConventionId(convention);
        this.setName(name, conventionId);
    }

    @Override
    public String getName(int conventionId) {
        assert (conventionId >= 0);
        assert (conventionId < this.names.length);
        return this.names[conventionId];
    }

    @Override
    public void setName(String name, int conventionId) {
        assert (conventionId >= 0);
        assert (this.names != null);
        assert (conventionId < this.names.length);
        this.names[conventionId] = name.substring(0, name.length());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("begin_spacegroup" + PackageConstants.NEWLINE);
        buf.append("number  " + this.getNumber() + PackageConstants.NEWLINE);
        assert (this.names != null);
        assert (SpaceGroupConvention.COUNT == this.names.length);
        for (int i = 0; i < SpaceGroupConvention.COUNT; ++i) {
            if (this.names[i] == null || this.names[i].length() <= 0) continue;
            buf.append(SpaceGroupConvention.NAMES[i] + " " + this.names[i] + PackageConstants.NEWLINE);
        }
        buf.append("end_spacegroup" + PackageConstants.NEWLINE);
        return buf.toString();
    }
}

