/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.BoundingVolume;
import tools3d.Vector4D;

public class AABBBoundingVolume
implements BoundingVolume {
    private Vector4D maxCorner;
    private Vector4D minCorner;
    private Vector4D[] vertexArray;
    private Vector4D bottomXZ;
    private Vector4D topXZ;
    private Vector4D leftYZ;
    private Vector4D rightYZ;
    private Vector4D frontXY;
    private Vector4D backXY;
    private Vector4D[][] faces;
    private Vector4D center;
    double minX;
    double minY;
    double minZ;
    double maxX;
    double maxY;
    double maxZ;

    public AABBBoundingVolume(Vector4D c1, Vector4D c2) {
        this.maxCorner = c1;
        this.minCorner = c2;
        this.center = new Vector4D((c1.getX() + c2.getX()) / 2.0, (c1.getY() + c2.getY()) / 2.0, (c1.getZ() + c2.getZ()) / 2.0, 1.0);
        if (c1.getX() > c2.getX()) {
            this.maxX = c1.getX();
            this.minX = c2.getX();
        } else {
            this.maxX = c2.getX();
            this.minX = c1.getX();
        }
        if (c1.getY() > c2.getY()) {
            this.maxY = c1.getY();
            this.minY = c2.getY();
        } else {
            this.maxY = c2.getY();
            this.minY = c1.getY();
        }
        if (c1.getZ() > c2.getZ()) {
            this.maxZ = c1.getZ();
            this.minZ = c2.getZ();
        } else {
            this.maxZ = c2.getZ();
            this.minZ = c1.getZ();
        }
        this.maxCorner = new Vector4D(this.maxX, this.maxY, this.maxZ, 1.0);
        this.minCorner = new Vector4D(this.minX, this.minY, this.minZ, 1.0);
        this.vertexArray = new Vector4D[8];
        this.vertexArray[0] = new Vector4D(c1);
        this.vertexArray[1] = new Vector4D(c1.getX(), c1.getY(), c2.getZ());
        this.vertexArray[2] = new Vector4D(c2.getX(), c1.getY(), c2.getZ());
        this.vertexArray[3] = new Vector4D(c2.getX(), c1.getY(), c1.getZ());
        this.vertexArray[4] = new Vector4D(c2);
        this.vertexArray[5] = new Vector4D(c2.getX(), c2.getY(), c1.getZ());
        this.vertexArray[6] = new Vector4D(c1.getX(), c2.getY(), c1.getZ());
        this.vertexArray[7] = new Vector4D(c1.getX(), c2.getY(), c2.getZ());
        this.faces = new Vector4D[6][4];
        this.faces[0][0] = this.vertexArray[0];
        this.faces[0][1] = this.vertexArray[1];
        this.faces[0][2] = this.vertexArray[2];
        this.faces[0][3] = this.vertexArray[3];
        this.faces[1][0] = this.vertexArray[0];
        this.faces[1][1] = this.vertexArray[1];
        this.faces[1][2] = this.vertexArray[7];
        this.faces[1][3] = this.vertexArray[6];
        this.faces[2][0] = this.vertexArray[0];
        this.faces[2][1] = this.vertexArray[3];
        this.faces[2][2] = this.vertexArray[5];
        this.faces[2][3] = this.vertexArray[6];
        this.faces[3][0] = this.vertexArray[4];
        this.faces[3][1] = this.vertexArray[5];
        this.faces[3][2] = this.vertexArray[6];
        this.faces[3][3] = this.vertexArray[7];
        this.faces[4][0] = this.vertexArray[4];
        this.faces[4][1] = this.vertexArray[5];
        this.faces[4][2] = this.vertexArray[3];
        this.faces[4][3] = this.vertexArray[2];
        this.faces[5][0] = this.vertexArray[4];
        this.faces[5][1] = this.vertexArray[2];
        this.faces[5][2] = this.vertexArray[1];
        this.faces[5][3] = this.vertexArray[7];
        this.bottomXZ = new Vector4D((c1.getX() + c2.getX()) / 2.0, this.minY, (c1.getZ() + c2.getZ()) / 2.0);
        this.topXZ = new Vector4D((c1.getX() + c2.getX()) / 2.0, this.maxY, (c1.getZ() + c2.getZ()) / 2.0);
        this.leftYZ = new Vector4D(this.minX, (c1.getY() + c2.getY()) / 2.0, (c1.getZ() + c2.getZ()) / 2.0);
        this.rightYZ = new Vector4D(this.maxX, (c1.getY() + c2.getY()) / 2.0, (c1.getZ() + c2.getZ()) / 2.0);
        this.frontXY = new Vector4D((c1.getX() + c2.getX()) / 2.0, (c1.getY() + c2.getY()) / 2.0, this.maxZ);
        this.backXY = new Vector4D((c1.getX() + c2.getX()) / 2.0, (c1.getY() + c2.getY()) / 2.0, this.minZ);
    }

    @Override
    public Vector4D[][] getFaces() {
        return this.faces;
    }

    @Override
    public Vector4D[] getVertices() {
        return this.vertexArray;
    }

    public Vector4D getCorner1() {
        return new Vector4D(this.maxCorner);
    }

    public Vector4D getCorner2() {
        return new Vector4D(this.minCorner);
    }

    public Vector4D getCenter() {
        return this.center;
    }

    @Override
    public boolean intersectBV(BoundingVolume v) throws IllegalArgumentException {
        if (!(v instanceof AABBBoundingVolume)) {
            throw new IllegalArgumentException("Parameter not AABBBoundingVolume");
        }
        AABBBoundingVolume bv = (AABBBoundingVolume)v;
        if (this.minX > bv.maxX || bv.minX > this.maxX) {
            return false;
        }
        if (this.minY > bv.maxY || bv.minY > this.maxY) {
            return false;
        }
        return !(this.minZ > bv.maxZ) && !(bv.minZ > this.maxZ);
    }

    @Override
    public boolean intersectLine(Vector4D p1, Vector4D p2) {
        Vector4D c = new Vector4D((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0, (p1.getZ() + p2.getZ()) / 2.0, 1.0);
        Vector4D w = new Vector4D(c);
        w = w.minus(p1);
        Vector4D t = this.center.mul(-1.0);
        Vector4D x = new Vector4D(this.rightYZ);
        x = x.minus(this.center);
        Vector4D y = new Vector4D(this.topXZ);
        y = y.minus(this.center);
        Vector4D z = new Vector4D(this.frontXY);
        z = z.minus(this.center);
        this.translateVector(x, t);
        this.translateVector(y, t);
        this.translateVector(z, t);
        this.translateVector(c, t);
        double vx = Math.abs(w.getX());
        double vy = Math.abs(w.getY());
        double vz = Math.abs(w.getZ());
        double hx = x.getX();
        double hy = y.getY();
        double hz = z.getZ();
        double cx = c.getX();
        double cy = c.getY();
        double cz = c.getZ();
        if (Math.abs(cx) > vx + hx) {
            return false;
        }
        if (Math.abs(cy) > vy + hy) {
            return false;
        }
        if (Math.abs(cz) > vz + hz) {
            return false;
        }
        if (Math.abs(cy * w.getZ() - cz * w.getY()) > hy * vz + hz * vy) {
            return false;
        }
        if (Math.abs(cx * w.getZ() - cz * w.getX()) > hx * vz + hz * vx) {
            return false;
        }
        return !(Math.abs(cx * w.getY() - cy * w.getX()) > hx * vy + hy * vz);
    }

    private Vector4D translateVector(Vector4D v, Vector4D t) {
        v.setX(v.getX() + t.getX());
        v.setY(v.getY() + t.getY());
        v.setZ(v.getZ() + t.getZ());
        return v;
    }

    @Override
    public boolean intersectPlane(Vector4D u, Vector4D v, Vector4D offset) {
        double x2;
        Vector4D n = u.cross(v);
        double d = n.dot(offset) * -1.0;
        Vector4D v1 = null;
        Vector4D v2 = null;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            Vector4D diagonal = new Vector4D(this.vertexArray[i]);
            diagonal = diagonal.minus(this.vertexArray[i + 4]);
            Vector4D proj = n.mul(diagonal.dot(n));
            Vector4D dist = new Vector4D(diagonal);
            double newDistance = (dist = dist.minus(proj)).length();
            if (!(newDistance < distance)) continue;
            distance = newDistance;
            v1 = this.vertexArray[i];
            v2 = this.vertexArray[i + 4];
        }
        double x1 = n.dot(v1) + d;
        return x1 * (x2 = n.dot(v2) + d) < 0.0;
    }

    @Override
    public boolean intersectRay(Vector4D line, Vector4D offset) {
        double candidatePlaneZ;
        double candidatePlaneY;
        double candidatePlaneX;
        boolean inside = true;
        if (offset.getX() < this.minCorner.getX()) {
            candidatePlaneX = this.minCorner.getX();
            inside = false;
        } else if (offset.getX() > this.maxCorner.getX()) {
            candidatePlaneX = this.maxCorner.getX();
            inside = false;
        } else {
            candidatePlaneX = Double.NaN;
        }
        if (offset.getY() < this.minCorner.getY()) {
            candidatePlaneY = this.minCorner.getY();
            inside = false;
        } else if (offset.getY() > this.maxCorner.getY()) {
            candidatePlaneY = this.maxCorner.getY();
            inside = false;
        } else {
            candidatePlaneY = Double.NaN;
        }
        if (offset.getZ() < this.minCorner.getZ()) {
            candidatePlaneZ = this.minCorner.getZ();
            inside = false;
        } else if (offset.getZ() > this.maxCorner.getZ()) {
            candidatePlaneZ = this.maxCorner.getZ();
            inside = false;
        } else {
            candidatePlaneZ = Double.NaN;
        }
        if (inside) {
            return true;
        }
        double tX = !Double.isNaN(candidatePlaneX) && line.getX() != 0.0 ? (candidatePlaneX - offset.getX()) / line.getX() : -1.0;
        double tY = !Double.isNaN(candidatePlaneY) && line.getY() != 0.0 ? (candidatePlaneY - offset.getY()) / line.getY() : -1.0;
        double tZ = !Double.isNaN(candidatePlaneZ) && line.getZ() != 0.0 ? (candidatePlaneZ - offset.getZ()) / line.getZ() : -1.0;
        double maxT = Math.max(tX, tY);
        if ((maxT = Math.max(maxT, tZ)) < 0.0) {
            return false;
        }
        Vector4D point = new Vector4D(maxT * line.getX() + offset.getX(), maxT * line.getY() + offset.getY(), maxT * line.getZ() + offset.getZ(), 1.0);
        if (maxT != tX && (point.getX() < this.minCorner.getX() || point.getX() > this.maxCorner.getX())) {
            return false;
        }
        if (maxT != tY && (point.getY() < this.minCorner.getY() || point.getY() > this.maxCorner.getY())) {
            return false;
        }
        return maxT == tZ || !(point.getZ() < this.minCorner.getZ()) && !(point.getZ() > this.maxCorner.getZ());
    }

    private boolean pointInBounds(double uA1, double uA2, double vA1, double vA2, double pu, double pv) {
        return pu > Math.min(uA1, uA2) && pu < Math.max(uA1, uA2) && pv > Math.min(vA1, vA2) && pv < Math.max(vA1, vA2);
    }

    @Override
    public boolean containsPoint(Vector4D p) {
        return p.getX() > Math.min(this.maxCorner.getX(), this.minCorner.getX()) && p.getX() < Math.max(this.maxCorner.getX(), this.minCorner.getX()) && p.getY() > Math.min(this.maxCorner.getY(), this.minCorner.getY()) && p.getY() < Math.max(this.maxCorner.getY(), this.minCorner.getY()) && p.getZ() > Math.min(this.maxCorner.getZ(), this.minCorner.getZ()) && p.getZ() < Math.max(this.maxCorner.getZ(), this.minCorner.getZ());
    }

    public String toString() {
        return "" + this.maxCorner + "\t" + this.minCorner;
    }
}

