/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import org.testng.annotations.Test;
import tools3d.Vector3D;

public class CoordinateSet {
    private double x;
    private double y;
    private double z;

    public CoordinateSet() {
    }

    public CoordinateSet(Vector3D vector) {
        this.setX(vector.getX());
        this.setY(vector.getY());
        this.setZ(vector.getZ());
    }

    public CoordinateSet(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Test
    public void testGetCoordinates() {
        CoordinateSet coorSet = new CoordinateSet(10.0, 42.0, 80.0);
        assert (coorSet.getX() == 10.0);
        assert (coorSet.getY() == 42.0);
        assert (coorSet.getZ() == 80.0);
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    @Test
    public void testSetCoordinates() {
        CoordinateSet coorSet = new CoordinateSet();
        coorSet.setX(11.0);
        coorSet.setY(23.0);
        coorSet.setZ(49.0);
        assert (coorSet.getX() == 11.0);
        assert (coorSet.getY() == 23.0);
        assert (coorSet.getZ() == 49.0);
    }

    public String toString() {
        String s = new String("" + this.x + ", " + this.y + ", " + this.z);
        return s;
    }

    public void testToString() {
        CoordinateSet coorSet = new CoordinateSet(3.0, 18.0, 4.0);
        assert (coorSet.toString().equals("3, 18, 4"));
    }

    public Vector3D toVector3D() {
        return new Vector3D(this.getX(), this.getY(), this.getZ());
    }

    @Test
    public void testToVector3D() {
        CoordinateSet coorSet = new CoordinateSet(5.0, 19.0, 52.0);
        Vector3D vector = coorSet.toVector3D();
        assert (vector.getX() == 5.0);
        assert (vector.getY() == 19.0);
        assert (vector.getZ() == 52.0);
    }
}

