/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Geometry;
import tools3d.Matrix3DTools;
import tools3d.Point3D;
import tools3d.SimpleShape3D;
import tools3d.StandardGeometry;
import tools3d.Vector3D;

public class Cube
extends SimpleShape3D {
    Point3D[] points;
    Vector3D[] offPoints;
    Edge3D[] edges;
    Face3D[] faces = new Face3D[0];

    public Cube(Vector3D position, Vector3D dimensions) {
        this.setPosition(position);
        this.setDimensions(dimensions);
        double r = dimensions.getX();
        if (dimensions.getY() > r) {
            r = dimensions.getY();
        }
        if (dimensions.getZ() > r) {
            r = dimensions.getZ();
        }
        this.setBoundingRadius(r);
        this.points = new Point3D[8];
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Point3D();
        }
        this.offPoints = new Vector3D[8];
        this.edges = new Edge3D[12];
        this.initOffPoints();
    }

    public Cube(Vector3D position, double width) {
        this(position, new Vector3D(width, width, width));
    }

    @Override
    public String getShapeName() {
        return "Cube";
    }

    private void initOffPoints() {
        Vector3D dim = this.getDimensions();
        Vector3D dim2 = dim.mul(0.5);
        this.offPoints[0] = new Vector3D(dim2.getX(), dim2.getY(), dim2.getZ());
        this.offPoints[1] = new Vector3D(dim2.getX(), dim2.getY(), -dim2.getZ());
        this.offPoints[2] = new Vector3D(dim2.getX(), -dim2.getY(), dim2.getZ());
        this.offPoints[3] = new Vector3D(dim2.getX(), -dim2.getY(), -dim2.getZ());
        this.offPoints[4] = new Vector3D(-dim2.getX(), dim2.getY(), dim2.getZ());
        this.offPoints[5] = new Vector3D(-dim2.getX(), dim2.getY(), -dim2.getZ());
        this.offPoints[6] = new Vector3D(-dim2.getX(), -dim2.getY(), dim2.getZ());
        this.offPoints[7] = new Vector3D(-dim2.getX(), -dim2.getY(), -dim2.getZ());
    }

    @Override
    public Geometry createGeometry(double angleDelta) {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return this.geometry;
    }

    protected void updateGeometry() {
        Vector3D pos = this.getPosition();
        for (int i = 0; i < this.points.length; ++i) {
            Vector3D rotAxis = this.getRotationAxis();
            double rotAngle = this.getRotationAngle();
            Vector3D rotPoint = Matrix3DTools.rotate(this.offPoints[i], rotAxis, rotAngle);
            this.points[i].setPosition(pos.plus(rotPoint));
        }
        int pc = 0;
        this.edges[pc++] = new Edge3D(this.points[0].getPosition(), this.points[1].getPosition());
        this.edges[pc++] = new Edge3D(this.points[0].getPosition(), this.points[2].getPosition());
        this.edges[pc++] = new Edge3D(this.points[0].getPosition(), this.points[4].getPosition());
        this.edges[pc++] = new Edge3D(this.points[1].getPosition(), this.points[3].getPosition());
        this.edges[pc++] = new Edge3D(this.points[1].getPosition(), this.points[5].getPosition());
        this.edges[pc++] = new Edge3D(this.points[2].getPosition(), this.points[3].getPosition());
        this.edges[pc++] = new Edge3D(this.points[2].getPosition(), this.points[6].getPosition());
        this.edges[pc++] = new Edge3D(this.points[3].getPosition(), this.points[7].getPosition());
        this.edges[pc++] = new Edge3D(this.points[4].getPosition(), this.points[5].getPosition());
        this.edges[pc++] = new Edge3D(this.points[4].getPosition(), this.points[6].getPosition());
        this.edges[pc++] = new Edge3D(this.points[5].getPosition(), this.points[7].getPosition());
        this.edges[pc++] = new Edge3D(this.points[6].getPosition(), this.points[7].getPosition());
        this.geometry = new StandardGeometry(this.points, this.edges, this.faces, this.getProperties());
        this.geometry.setSelected(this.isSelected());
    }
}

