/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Geometry;
import tools3d.GeometryTools;
import tools3d.Matrix3DTools;
import tools3d.Point3D;
import tools3d.SimpleShape3D;
import tools3d.StandardGeometry;
import tools3d.Vector3D;

public class Cylinder
extends SimpleShape3D {
    Point3D[] pointsLow;
    Point3D[] pointsHigh;
    Point3D[] points;
    Vector3D[] offPointsLow;
    Vector3D[] offPointsHigh;
    Edge3D[] edges = new Edge3D[0];
    Face3D[] faces = new Face3D[0];
    double radius;

    public Cylinder(Vector3D position, double height, double radius) {
        this.setPosition(position);
        Vector3D dimensions = new Vector3D(radius, radius, height);
        this.setDimensions(dimensions);
        this.setBoundingRadius(dimensions.max());
        this.radius = radius;
    }

    @Override
    public String getShapeName() {
        return "Cylinder";
    }

    private void initOffPoints(double height, double radius, int nn) {
        int i;
        double h2 = 0.5 * height;
        double angleStep = Math.PI * 2 / (double)nn;
        if (this.pointsLow == null || this.pointsLow.length != nn) {
            this.pointsLow = new Point3D[nn];
            this.pointsHigh = new Point3D[nn];
            for (i = 0; i < nn; ++i) {
                this.pointsLow[i] = new Point3D();
                this.pointsHigh[i] = new Point3D();
            }
            this.offPointsLow = new Vector3D[nn];
            this.offPointsHigh = new Vector3D[nn];
            for (i = 0; i < nn; ++i) {
                this.offPointsLow[i] = new Vector3D();
                this.offPointsHigh[i] = new Vector3D();
            }
        }
        for (i = 0; i < nn; ++i) {
            double ang = angleStep * (double)i;
            double x = radius * Math.cos(ang);
            double y = radius * Math.sin(ang);
            this.offPointsLow[i].set(x, y, -h2);
            this.offPointsHigh[i].set(x, y, h2);
        }
    }

    @Override
    public Geometry createGeometry(double angleDelta) {
        if (!this.isGeometryUpToDate()) {
            this.updateGeometry(angleDelta);
        }
        return this.geometry;
    }

    protected void updateGeometry(double angleDelta) {
        int nn = GeometryTools.computeCircleDevisions(angleDelta);
        this.initOffPoints(this.getDimensions().getZ(), this.getDimensions().getX(), nn);
        Vector3D pos = this.getPosition();
        Vector3D rotAxis = this.getRotationAxis();
        double rotAngle = this.getRotationAngle();
        for (int i = 0; i < this.pointsLow.length; ++i) {
            Vector3D rotPointLow = Matrix3DTools.rotate(this.offPointsLow[i], rotAxis, rotAngle);
            Vector3D rotPointHigh = Matrix3DTools.rotate(this.offPointsHigh[i], rotAxis, rotAngle);
            this.pointsLow[i].setPosition(pos.plus(rotPointLow));
            this.pointsHigh[i].setPosition(pos.plus(rotPointHigh));
        }
        this.updatePoints();
        this.updateEdges();
        this.geometry = new StandardGeometry(this.points, this.edges, this.faces, this.getProperties());
        this.geometry.setSelected(this.isSelected());
        this.setGeometryUpToDate(true);
    }

    private void updatePoints() {
        int i;
        if (this.points == null || this.points.length != this.pointsLow.length + this.pointsHigh.length) {
            int nt = this.pointsLow.length + this.pointsHigh.length;
            this.points = new Point3D[nt];
        }
        int pc = 0;
        for (i = 0; i < this.pointsLow.length; ++i) {
            this.points[pc++] = this.pointsLow[i];
        }
        for (i = 0; i < this.pointsHigh.length; ++i) {
            this.points[pc++] = this.pointsHigh[i];
        }
    }

    private void updateEdges() {
        int i;
        if (this.edges == null || this.edges.length != 3 * this.pointsHigh.length) {
            int nEdges = 3 * this.pointsHigh.length;
            this.edges = new Edge3D[nEdges];
        }
        int pc = 0;
        for (i = 1; i < this.pointsLow.length; ++i) {
            this.edges[pc++] = new Edge3D(this.pointsLow[i - 1].getPosition(), this.pointsLow[i].getPosition());
        }
        this.edges[pc++] = new Edge3D(this.pointsLow[0].getPosition(), this.pointsLow[this.pointsLow.length - 1].getPosition());
        for (i = 1; i < this.pointsHigh.length; ++i) {
            this.edges[pc++] = new Edge3D(this.pointsHigh[i - 1].getPosition(), this.pointsHigh[i].getPosition());
        }
        this.edges[pc++] = new Edge3D(this.pointsHigh[0].getPosition(), this.pointsHigh[this.pointsHigh.length - 1].getPosition());
        for (i = 0; i < this.pointsHigh.length; ++i) {
            this.edges[pc++] = new Edge3D(this.pointsLow[i].getPosition(), this.pointsHigh[i].getPosition());
        }
    }
}

