/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.io.Serializable;
import tools3d.Matrix3D;
import tools3d.Vector3D;
import tools3d.Vector4D;

public class Matrix4D
implements Serializable,
Comparable<Matrix4D> {
    public static final String SPACE = " ";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final Matrix4D I4 = new Matrix4D(1.0);
    public static final Matrix4D Z4 = new Matrix4D(0.0);
    Vector4D xRow = new Vector4D();
    Vector4D yRow = new Vector4D();
    Vector4D zRow = new Vector4D();
    Vector4D wRow = new Vector4D();

    public Matrix4D() {
    }

    public Matrix4D(double diagonal) {
        this();
        this.setXRow(diagonal, 0.0, 0.0, 0.0);
        this.setYRow(0.0, diagonal, 0.0, 0.0);
        this.setZRow(0.0, 0.0, diagonal, 0.0);
        this.setWRow(0.0, 0.0, 0.0, diagonal);
    }

    public Matrix4D(Vector4D newXRow, Vector4D newYRow, Vector4D newZRow, Vector4D newWRow) {
        this();
        this.setXRow(newXRow);
        this.setYRow(newYRow);
        this.setZRow(newZRow);
        this.setWRow(newWRow);
    }

    public Matrix4D(double xx, double xy, double xz, double xw, double yx, double yy, double yz, double yw, double zx, double zy, double zz, double zw, double wx, double wy, double wz, double ww) {
        this();
        this.setXRow(xx, xy, xz, xw);
        this.setYRow(yx, yy, yz, yw);
        this.setZRow(zx, zy, zz, zw);
        this.setWRow(wx, wy, wz, ww);
    }

    public Matrix4D(Matrix4D other) {
        this();
        this.copy(other);
    }

    public Matrix4D(Matrix3D other) {
        this();
        this.copy(other);
    }

    public Matrix4D(Matrix3D rotation, Vector3D translation) {
        this();
        this.copy(rotation);
        this.setXW(translation.getX());
        this.setYW(translation.getY());
        this.setZW(translation.getZ());
        this.setWW(1.0);
    }

    public static Matrix4D generateUnitMatrix4D() {
        return new Matrix4D(new Matrix3D(1.0), new Vector3D(0.0, 0.0, 0.0));
    }

    @Override
    public int compareTo(Matrix4D other) {
        double s2;
        double s1 = this.norm();
        if (s1 < (s2 = other.norm())) {
            return -1;
        }
        if (s1 > s2) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Matrix4D other) {
        return this.getXRow().equals(other.getXRow()) && this.getYRow().equals(other.getYRow()) && this.getZRow().equals(other.getZRow()) && this.getWRow().equals(other.getWRow());
    }

    public Matrix4D homogeneousInverse() {
        Matrix3D rotation = this.submatrix();
        Vector3D translation = this.subvector();
        return new Matrix4D(rotation.transposed(), translation.mul(-1.0));
    }

    public Matrix4D inverse() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        Matrix4D result = new Matrix4D(1.0);
        Matrix4D src = new Matrix4D(this);
        double pivot = Math.abs(src.getXRow().getX());
        double newPivot = Math.abs(src.getYRow().getX());
        if (d6 > pivot) {
            pivot = newPivot;
            src.getYRow().swap(src.getXRow());
            result.getYRow().swap(result.getXRow());
        }
        newPivot = Math.abs(src.getZRow().getX());
        if (d5 > pivot) {
            pivot = newPivot;
            src.getZRow().swap(src.getXRow());
            result.getZRow().swap(result.getXRow());
        }
        newPivot = Math.abs(src.getWRow().getX());
        if (d4 > pivot) {
            pivot = newPivot;
            src.getWRow().swap(src.getXRow());
            result.getWRow().swap(result.getXRow());
        }
        if (pivot == 0.0) {
            return result;
        }
        pivot = 1.0 / src.getXRow().getX();
        result.getXRow().scale(pivot);
        src.getXRow().scale(pivot);
        result.getYRow().sub(result.getXRow().mul(src.getYRow().getX()));
        src.getYRow().sub(src.getXRow().mul(src.getYRow().getX()));
        result.getZRow().sub(result.getXRow().mul(src.getZRow().getX()));
        src.getZRow().sub(src.getXRow().mul(src.getZRow().getX()));
        result.getWRow().sub(result.getXRow().mul(src.getWRow().getX()));
        src.getWRow().sub(src.getXRow().mul(src.getWRow().getX()));
        pivot = Math.abs(src.getYRow().getY());
        newPivot = Math.abs(src.getZRow().getY());
        if (d3 > pivot) {
            pivot = newPivot;
            src.getZRow().swap(src.getYRow());
            result.getZRow().swap(result.getYRow());
        }
        newPivot = Math.abs(src.getWRow().getY());
        if (d2 > pivot) {
            pivot = newPivot;
            src.getWRow().swap(src.getYRow());
            result.getWRow().swap(result.getYRow());
        }
        if (pivot == 0.0) {
            return result;
        }
        pivot = 1.0 / src.getYRow().getY();
        result.getYRow().scale(pivot);
        src.getYRow().scale(pivot);
        result.getZRow().sub(result.getYRow().mul(src.getZRow().getY()));
        src.getZRow().sub(src.getYRow().mul(src.getZRow().getY()));
        result.getWRow().sub(result.getYRow().mul(src.getWRow().getY()));
        src.getWRow().sub(src.getYRow().mul(src.getWRow().getY()));
        pivot = Math.abs(src.getZRow().getZ());
        newPivot = Math.abs(src.getWRow().getZ());
        if (d > pivot) {
            pivot = newPivot;
            src.getWRow().swap(src.getZRow());
            result.getWRow().swap(result.getZRow());
        }
        if (pivot == 0.0) {
            return result;
        }
        pivot = 1.0 / src.getZRow().getZ();
        result.getZRow().scale(pivot);
        src.getZRow().scale(pivot);
        result.getWRow().sub(result.getZRow().mul(src.getWRow().getZ()));
        src.getWRow().sub(src.getZRow().mul(src.getWRow().getZ()));
        if (src.getWRow().getW() == 0.0) {
            return result;
        }
        pivot = 1.0 / src.getWRow().getW();
        result.getWRow().scale(pivot);
        src.getWRow().scale(pivot);
        result.getZRow().sub(result.getWRow().mul(src.getZRow().w));
        src.getZRow().sub(src.getWRow().mul(src.getZRow().getW()));
        result.getYRow().sub(result.getWRow().mul(src.getYRow().w));
        src.getYRow().sub(src.getWRow().mul(src.getYRow().getW()));
        result.getXRow().sub(result.getWRow().mul(src.getXRow().w));
        src.getXRow().sub(src.getWRow().mul(src.getXRow().getW()));
        result.getYRow().sub(result.getZRow().mul(src.getYRow().getZ()));
        src.getYRow().sub(src.getZRow().mul(src.getYRow().getZ()));
        result.getXRow().sub(result.getZRow().mul(src.getXRow().getZ()));
        src.getXRow().sub(src.getZRow().mul(src.getXRow().getZ()));
        result.getXRow().sub(result.getYRow().mul(src.getXRow().getY()));
        return result;
    }

    public boolean isHomogenous() {
        Matrix3D m3 = this.submatrix();
        Vector3D v3 = this.getWRow().subVector();
        return m3.isRotation() && v3.length() < 0.01;
    }

    public Matrix4D multiply(double number) {
        Matrix4D result = new Matrix4D();
        result.getXRow().copy(this.getXRow().mul(number));
        result.getYRow().copy(this.getYRow().mul(number));
        result.getZRow().copy(this.getZRow().mul(number));
        result.getWRow().copy(this.getWRow().mul(number));
        return result;
    }

    public void scale(double _scale) {
        this.xRow.scale(_scale);
        this.yRow.scale(_scale);
        this.zRow.scale(_scale);
        this.wRow.scale(_scale);
    }

    public Vector4D multiply(Vector4D vect) {
        Vector4D result = new Vector4D();
        result.setX(this.getXX() * vect.getX() + this.getXY() * vect.getY() + this.getXZ() * vect.getZ() + this.getXW() * vect.getW());
        result.setY(this.getYX() * vect.getX() + this.getYY() * vect.getY() + this.getYZ() * vect.getZ() + this.getYW() * vect.getW());
        result.setZ(this.getZX() * vect.getX() + this.getZY() * vect.getY() + this.getZZ() * vect.getZ() + this.getZW() * vect.getW());
        result.setW(this.getWX() * vect.getX() + this.getWY() * vect.getY() + this.getWZ() * vect.getZ() + this.getWW() * vect.getW());
        return result;
    }

    public double[] getArray() {
        double[] array = new double[]{this.xRow.getX(), this.xRow.getY(), this.xRow.getZ(), this.xRow.getW(), this.yRow.getX(), this.yRow.getY(), this.yRow.getZ(), this.yRow.getW(), this.zRow.getX(), this.zRow.getY(), this.zRow.getZ(), this.zRow.getW(), this.wRow.getX(), this.wRow.getY(), this.wRow.getZ(), this.wRow.getW()};
        return array;
    }

    public Vector4D multiply(Vector4D vect, int n) {
        Vector4D result = new Vector4D(vect);
        for (int i = 0; i < n; ++i) {
            result = this.multiply(result);
        }
        return result;
    }

    public Vector3D multiply(Vector3D vect) {
        return this.multiply(new Vector4D(vect)).subVector();
    }

    public Vector3D multiply(Vector3D vect, int n) {
        return this.multiply(new Vector4D(vect), n).subVector();
    }

    public Matrix4D multiply(Matrix4D other) {
        Matrix4D result = new Matrix4D();
        result.setXX(this.getXX() * other.getXX() + this.getXY() * other.getYX() + this.getXZ() * other.getZX() + this.getXW() * other.getWX());
        result.setXY(this.getXX() * other.getXY() + this.getXY() * other.getYY() + this.getXZ() * other.getZY() + this.getXW() * other.getWY());
        result.setXZ(this.getXX() * other.getXZ() + this.getXY() * other.getYZ() + this.getXZ() * other.getZZ() + this.getXW() * other.getWZ());
        result.setXW(this.getXX() * other.getXW() + this.getXY() * other.getYW() + this.getXZ() * other.getZW() + this.getXW() * other.getWW());
        result.setYX(this.getYX() * other.getXX() + this.getYY() * other.getYX() + this.getYZ() * other.getZX() + this.getYW() * other.getWX());
        result.setYY(this.getYX() * other.getXY() + this.getYY() * other.getYY() + this.getYZ() * other.getZY() + this.getYW() * other.getWY());
        result.setYZ(this.getYX() * other.getXZ() + this.getYY() * other.getYZ() + this.getYZ() * other.getZZ() + this.getYW() * other.getWZ());
        result.setYW(this.getYX() * other.getXW() + this.getYY() * other.getYW() + this.getYZ() * other.getZW() + this.getYW() * other.getWW());
        result.setZX(this.getZX() * other.getXX() + this.getZY() * other.getYX() + this.getZZ() * other.getZX() + this.getZW() * other.getWX());
        result.setZY(this.getZX() * other.getXY() + this.getZY() * other.getYY() + this.getZZ() * other.getZY() + this.getZW() * other.getWY());
        result.setZZ(this.getZX() * other.getXZ() + this.getZY() * other.getYZ() + this.getZZ() * other.getZZ() + this.getZW() * other.getWZ());
        result.setZW(this.getZX() * other.getXW() + this.getZY() * other.getYW() + this.getZZ() * other.getZW() + this.getZW() * other.getWW());
        result.setWX(this.getWX() * other.getXX() + this.getWY() * other.getYX() + this.getWZ() * other.getZX() + this.getWW() * other.getWX());
        result.setWY(this.getWX() * other.getXY() + this.getWY() * other.getYY() + this.getWZ() * other.getZY() + this.getWW() * other.getWY());
        result.setWZ(this.getWX() * other.getXZ() + this.getWY() * other.getYZ() + this.getWZ() * other.getZZ() + this.getWW() * other.getWZ());
        result.setWW(this.getWX() * other.getXW() + this.getWY() * other.getYW() + this.getWZ() * other.getZW() + this.getWW() * other.getWW());
        return result;
    }

    public Matrix4D plus(Matrix4D other) {
        Matrix4D result = new Matrix4D();
        result.setXRow(this.getXRow().plus(other.getXRow()));
        result.setYRow(this.getYRow().plus(other.getYRow()));
        result.setZRow(this.getZRow().plus(other.getZRow()));
        result.setWRow(this.getWRow().plus(other.getWRow()));
        return result;
    }

    public Matrix4D minus(Matrix4D other) {
        Matrix4D result = new Matrix4D();
        result.setXRow(this.getXRow().minus(other.getXRow()));
        result.setYRow(this.getYRow().minus(other.getYRow()));
        result.setZRow(this.getZRow().minus(other.getZRow()));
        result.setWRow(this.getWRow().minus(other.getWRow()));
        return result;
    }

    public Matrix4D add(Matrix4D other) {
        this.xRow.add(other.getXRow());
        this.yRow.add(other.getYRow());
        this.zRow.add(other.getZRow());
        this.wRow.add(other.getWRow());
        return this;
    }

    public Matrix4D pow(int n) {
        assert (n >= 0);
        Matrix4D result = new Matrix4D(1.0);
        for (int i = 0; i < n; ++i) {
            result = result.multiply(this);
        }
        return result;
    }

    public Matrix3D submatrix() {
        return new Matrix3D(this.getXRow().subVector(), this.getYRow().subVector(), this.getZRow().subVector());
    }

    public Vector3D subvector() {
        return new Vector3D(this.getXRow().getW(), this.getYRow().getW(), this.getZRow().getW());
    }

    public Matrix4D subtract(Matrix4D other) {
        this.xRow.sub(other.getXRow());
        this.yRow.sub(other.getYRow());
        this.zRow.sub(other.getZRow());
        this.wRow.sub(other.getWRow());
        return this;
    }

    public double trace() {
        return this.getXX() + this.getYY() + this.getZZ() + this.getWW();
    }

    public Matrix4D transposed() {
        return new Matrix4D(this.getXX(), this.getYX(), this.getZX(), this.getWX(), this.getXY(), this.getYY(), this.getZY(), this.getWY(), this.getXZ(), this.getYZ(), this.getZZ(), this.getWZ(), this.getXW(), this.getYW(), this.getZW(), this.getWW());
    }

    public Vector4D getXRow() {
        return this.xRow;
    }

    public Vector4D getYRow() {
        return this.yRow;
    }

    public Vector4D getZRow() {
        return this.zRow;
    }

    public Vector4D getWRow() {
        return this.wRow;
    }

    public double getXX() {
        return this.getXRow().getX();
    }

    public double getXY() {
        return this.getXRow().getY();
    }

    public double getXZ() {
        return this.getXRow().getZ();
    }

    public double getXW() {
        return this.getXRow().getW();
    }

    public double getYX() {
        return this.getYRow().getX();
    }

    public double getYY() {
        return this.getYRow().getY();
    }

    public double getYZ() {
        return this.getYRow().getZ();
    }

    public double getYW() {
        return this.getYRow().getW();
    }

    public double getZX() {
        return this.getZRow().getX();
    }

    public double getZY() {
        return this.getZRow().getY();
    }

    public double getZZ() {
        return this.getZRow().getZ();
    }

    public double getZW() {
        return this.getZRow().getW();
    }

    public double getWX() {
        return this.getWRow().getX();
    }

    public double getWY() {
        return this.getWRow().getY();
    }

    public double getWZ() {
        return this.getWRow().getZ();
    }

    public double getWW() {
        return this.getWRow().getW();
    }

    public void setXX(double xx) {
        this.xRow.setX(xx);
    }

    public void setXY(double xy) {
        this.xRow.setY(xy);
    }

    public void setXZ(double xz) {
        this.xRow.setZ(xz);
    }

    public void setXW(double xw) {
        this.xRow.setW(xw);
    }

    public void setYX(double yx) {
        this.yRow.setX(yx);
    }

    public void setYY(double yy) {
        this.yRow.setY(yy);
    }

    public void setYZ(double yz) {
        this.yRow.setZ(yz);
    }

    public void setYW(double yw) {
        this.yRow.setW(yw);
    }

    public void setZX(double zx) {
        this.zRow.setX(zx);
    }

    public void setZY(double zy) {
        this.zRow.setY(zy);
    }

    public void setZZ(double zz) {
        this.zRow.setZ(zz);
    }

    public void setZW(double zw) {
        this.zRow.setW(zw);
    }

    public void setWX(double wx) {
        this.wRow.setX(wx);
    }

    public void setWY(double wy) {
        this.wRow.setY(wy);
    }

    public void setWZ(double wz) {
        this.wRow.setZ(wz);
    }

    public void setWW(double ww) {
        this.wRow.setW(ww);
    }

    public String toString() {
        String result = "(Matrix4D " + NEWLINE + this.getXX() + SPACE + this.getXY() + SPACE + this.getXZ() + SPACE + this.getXW() + NEWLINE + this.getYX() + SPACE + this.getYY() + SPACE + this.getYZ() + SPACE + this.getYW() + NEWLINE + this.getZX() + SPACE + this.getZY() + SPACE + this.getZZ() + SPACE + this.getZW() + NEWLINE + this.getWX() + SPACE + this.getWY() + SPACE + this.getWZ() + SPACE + this.getWW() + NEWLINE + ")" + SPACE;
        return result;
    }

    public double norm() {
        return Math.sqrt(this.xRow.lengthSquare() + this.yRow.lengthSquare() + this.zRow.lengthSquare() + this.wRow.lengthSquare());
    }

    public void copy(Matrix4D other) {
        if (this.getXRow() == null) {
            this.setXRow(new Vector4D());
        }
        this.xRow.copy(other.getXRow());
        if (this.getYRow() == null) {
            this.setYRow(new Vector4D());
        }
        this.yRow.copy(other.getYRow());
        if (this.getZRow() == null) {
            this.setZRow(new Vector4D());
        }
        this.zRow.copy(other.getZRow());
        if (this.getWRow() == null) {
            this.setWRow(new Vector4D());
        }
        this.wRow.copy(other.getWRow());
    }

    public void copy(Matrix3D other) {
        this.xRow.copy(other.getXRow());
        this.xRow.setW(0.0);
        this.yRow.copy(other.getYRow());
        this.yRow.setW(0.0);
        this.zRow.copy(other.getZRow());
        this.zRow.setW(0.0);
        this.wRow.set(0.0, 0.0, 0.0, 1.0);
    }

    public void copy(Vector4D newXRow, Vector4D newYRow, Vector4D newZRow, Vector3D newWRow) {
        this.xRow.copy(newXRow);
        this.yRow.copy(newYRow);
        this.zRow.copy(newZRow);
        this.wRow.copy(newWRow);
    }

    public void setXRow(Vector4D x) {
        this.xRow = new Vector4D(x);
    }

    public void setXRow(double x, double y, double z, double w) {
        this.xRow.set(x, y, z, w);
    }

    public void setYRow(Vector4D y) {
        this.yRow = new Vector4D(y);
    }

    public void setYRow(double x, double y, double z, double w) {
        this.yRow.set(x, y, z, w);
    }

    public void setZRow(Vector4D z) {
        this.zRow = new Vector4D(z);
    }

    public void setZRow(double x, double y, double z, double w) {
        this.zRow.set(x, y, z, w);
    }

    public void setWRow(Vector4D w) {
        this.wRow = new Vector4D(w);
    }

    public void setWRow(double x, double y, double z, double w) {
        this.wRow.set(x, y, z, w);
    }
}

