/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Geometry;
import tools3d.Point3D;
import tools3d.Shape3D;
import tools3d.SimpleShape3D;
import tools3d.StandardGeometry;
import tools3d.Vector3D;

public class PointShape
extends SimpleShape3D
implements Shape3D {
    public PointShape(Vector3D position, double radius) {
        this.setPosition(position);
        this.setBoundingRadius(radius);
        this.setDimensions(new Vector3D(radius, radius, radius));
    }

    @Override
    public Geometry createGeometry(double angleDelta) {
        if (!this.isGeometryUpToDate()) {
            this.updateGeometry(angleDelta);
        }
        return this.geometry;
    }

    @Override
    public String getShapeName() {
        return "PointShape";
    }

    protected void updateGeometry(double angleDelta) {
        Vector3D pos = this.getPosition();
        double radius = this.getBoundingRadius();
        Point3D[] points = new Point3D[]{new Point3D(pos, radius)};
        Edge3D[] edges = new Edge3D[]{};
        Face3D[] faces = new Face3D[]{};
        this.geometry = new StandardGeometry(points, edges, faces);
        this.geometry.setProperties(this.getProperties());
        this.geometry.setSelected(this.isSelected());
        this.setGeometryUpToDate(true);
    }
}

