/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.Matrix3D;
import tools3d.Vector3D;

public class Superimpose {
    public static double rms(Vector3D[] v1, Vector3D[] v2) {
        assert (v1 != null && v2 != null && v1.length == v2.length && v1.length > 0);
        double sum = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            sum += v1[i].minus(v2[i]).lengthSquare();
        }
        return Math.sqrt(sum /= (double)v1.length);
    }

    public static double superimpose(double[][] coords1, double[][] coords2, double[][] rot, double[] mc1, double[] mc2) {
        double gamma;
        double beta;
        double alpha;
        double val;
        int j;
        int i;
        assert (rot != null && rot.length == 3 && rot[0].length == 3);
        assert (mc1 != null && mc1.length == 3);
        assert (mc2 != null && mc2.length == 3);
        int npoints = coords1.length;
        assert (npoints >= 3);
        if (npoints < 3) {
            return 0.0;
        }
        double[][] mat_s = new double[3][3];
        double[][] mat_a = new double[3][3];
        double[][] mat_b = new double[3][3];
        double[][] mat_g = new double[3][3];
        double[][] mat_u = new double[3][3];
        double[][] tmp_mat = new double[3][3];
        int NUMBER_STEPS_MAX = 1000;
        int stepCounter = 0;
        double cz2 = 0.0;
        double cy2 = 0.0;
        double cx2 = 0.0;
        double cz1 = 0.0;
        double cy1 = 0.0;
        double cx1 = 0.0;
        for (i = 0; i < npoints; ++i) {
            cx1 += coords1[i][0];
            cy1 += coords1[i][1];
            cz1 += coords1[i][2];
            cx2 += coords2[i][0];
            cy2 += coords2[i][1];
            cz2 += coords2[i][2];
        }
        cx1 /= (double)npoints;
        cy1 /= (double)npoints;
        cz1 /= (double)npoints;
        cx2 /= (double)npoints;
        cy2 /= (double)npoints;
        cz2 /= (double)npoints;
        for (i = 0; i < npoints; ++i) {
            double[] dArray = coords1[i];
            dArray[0] = dArray[0] - cx1;
            double[] dArray2 = coords1[i];
            dArray2[1] = dArray2[1] - cy1;
            double[] dArray3 = coords1[i];
            dArray3[2] = dArray3[2] - cz1;
            double[] dArray4 = coords2[i];
            dArray4[0] = dArray4[0] - cx2;
            double[] dArray5 = coords2[i];
            dArray5[1] = dArray5[1] - cy2;
            double[] dArray6 = coords2[i];
            dArray6[2] = dArray6[2] - cz2;
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                if (i == j) {
                    mat_g[i][j] = 1.0;
                    mat_b[i][j] = 1.0;
                    mat_a[i][j] = 1.0;
                    mat_s[i][j] = 1.0;
                } else {
                    mat_g[i][j] = 0.0;
                    mat_b[i][j] = 0.0;
                    mat_a[i][j] = 0.0;
                    mat_s[i][j] = 0.0;
                }
                mat_u[i][j] = 0.0;
            }
        }
        for (int n = 0; n < npoints; ++n) {
            double[] dArray = mat_u[0];
            dArray[0] = dArray[0] + coords1[n][0] * coords2[n][0];
            double[] dArray7 = mat_u[0];
            dArray7[1] = dArray7[1] + coords1[n][0] * coords2[n][1];
            double[] dArray8 = mat_u[0];
            dArray8[2] = dArray8[2] + coords1[n][0] * coords2[n][2];
            double[] dArray9 = mat_u[1];
            dArray9[0] = dArray9[0] + coords1[n][1] * coords2[n][0];
            double[] dArray10 = mat_u[1];
            dArray10[1] = dArray10[1] + coords1[n][1] * coords2[n][1];
            double[] dArray11 = mat_u[1];
            dArray11[2] = dArray11[2] + coords1[n][1] * coords2[n][2];
            double[] dArray12 = mat_u[2];
            dArray12[0] = dArray12[0] + coords1[n][2] * coords2[n][0];
            double[] dArray13 = mat_u[2];
            dArray13[1] = dArray13[1] + coords1[n][2] * coords2[n][1];
            double[] dArray14 = mat_u[2];
            dArray14[2] = dArray14[2] + coords1[n][2] * coords2[n][2];
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                tmp_mat[i][j] = 0.0;
            }
        }
        do {
            int k;
            double d = mat_u[2][1] - mat_u[1][2];
            double d2 = mat_u[1][1] + mat_u[2][2];
            alpha = d == 0.0 || d2 == 0.0 ? 0.0 : Math.atan(d / d2);
            if (Math.cos(alpha) * (mat_u[1][1] + mat_u[2][2]) + Math.sin(alpha) * (mat_u[2][1] - mat_u[1][2]) < 0.0) {
                alpha += Math.PI;
            }
            double d3 = Math.cos(alpha);
            mat_a[2][2] = d3;
            mat_a[1][1] = d3;
            mat_a[2][1] = Math.sin(alpha);
            mat_a[1][2] = -mat_a[2][1];
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_u[i][k] * mat_a[j][k];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_u[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_a[i][k] * mat_s[k][j];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_s[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            d = mat_u[0][2] - mat_u[2][0];
            d2 = mat_u[0][0] + mat_u[2][2];
            beta = d == 0.0 || d2 == 0.0 ? 0.0 : Math.atan(d / d2);
            if (Math.cos(beta) * (mat_u[0][0] + mat_u[2][2]) + Math.sin(beta) * (mat_u[0][2] - mat_u[2][0]) < 0.0) {
                beta += Math.PI;
            }
            double d4 = Math.cos(beta);
            mat_b[2][2] = d4;
            mat_b[0][0] = d4;
            mat_b[0][2] = Math.sin(beta);
            mat_b[2][0] = -mat_b[0][2];
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_u[i][k] * mat_b[j][k];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_u[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_b[i][k] * mat_s[k][j];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_s[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            d = mat_u[1][0] - mat_u[0][1];
            d2 = mat_u[0][0] + mat_u[1][1];
            gamma = d == 0.0 || d2 == 0.0 ? 0.0 : Math.atan(d / d2);
            if (Math.cos(gamma) * (mat_u[0][0] + mat_u[1][1]) + Math.sin(gamma) * (mat_u[1][0] - mat_u[0][1]) < 0.0) {
                gamma += Math.PI;
            }
            double d5 = Math.cos(gamma);
            mat_g[1][1] = d5;
            mat_g[0][0] = d5;
            mat_g[1][0] = Math.sin(gamma);
            mat_g[0][1] = -mat_g[1][0];
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_u[i][k] * mat_g[j][k];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_u[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_g[i][k] * mat_s[k][j];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_s[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
        } while ((val = Math.abs(alpha) + Math.abs(beta) + Math.abs(gamma)) > 1.0E-4 && stepCounter++ < NUMBER_STEPS_MAX);
        val = 0.0;
        for (i = 0; i < npoints; ++i) {
            double x = coords2[i][0];
            double y = coords2[i][1];
            double z = coords2[i][2];
            double tmpx = x * mat_s[0][0] + y * mat_s[0][1] + z * mat_s[0][2];
            double tmpy = x * mat_s[1][0] + y * mat_s[1][1] + z * mat_s[1][2];
            double tmpz = x * mat_s[2][0] + y * mat_s[2][1] + z * mat_s[2][2];
            x = coords1[i][0] - tmpx;
            y = coords1[i][1] - tmpy;
            z = coords1[i][2] - tmpz;
            val += x * x + y * y + z * z;
        }
        for (i = 0; i < npoints; ++i) {
            double[] dArray = coords1[i];
            dArray[0] = dArray[0] + cx1;
            double[] dArray15 = coords1[i];
            dArray15[1] = dArray15[1] + cy1;
            double[] dArray16 = coords1[i];
            dArray16[2] = dArray16[2] + cz1;
            double[] dArray17 = coords2[i];
            dArray17[0] = dArray17[0] + cx2;
            double[] dArray18 = coords2[i];
            dArray18[1] = dArray18[1] + cy2;
            double[] dArray19 = coords2[i];
            dArray19[2] = dArray19[2] + cz2;
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                rot[i][j] = mat_s[i][j];
            }
        }
        mc1[0] = cx1;
        mc1[1] = cy1;
        mc1[2] = cz1;
        mc2[0] = cx2;
        mc2[1] = cy2;
        mc2[2] = cz2;
        return Math.sqrt(val / (double)npoints);
    }

    public static double superimpose(Vector3D[] _coords1, Vector3D[] _coords2, Matrix3D _rot, Vector3D _mc1, Vector3D _mc2) {
        assert (_coords1 != null && _coords1 != null && _coords1.length == _coords2.length && _coords1.length >= 3);
        assert (_rot != null);
        double[][] coords1 = new double[_coords1.length][3];
        double[][] coords2 = new double[_coords2.length][3];
        double[][] rot = new double[3][3];
        double[] mc1 = new double[3];
        double[] mc2 = new double[3];
        for (int i = 0; i < coords1.length; ++i) {
            coords1[i][0] = _coords1[i].getX();
            coords1[i][1] = _coords1[i].getY();
            coords1[i][2] = _coords1[i].getZ();
            coords2[i][0] = _coords2[i].getX();
            coords2[i][1] = _coords2[i].getY();
            coords2[i][2] = _coords2[i].getZ();
        }
        double result = Superimpose.superimpose(coords1, coords2, rot, mc1, mc2);
        _rot.copy(new Matrix3D(rot[0][0], rot[0][1], rot[0][2], rot[1][0], rot[1][1], rot[1][2], rot[2][0], rot[2][1], rot[2][2]));
        _mc1.copy(new Vector3D(mc1[0], mc1[1], mc1[2]));
        _mc2.copy(new Vector3D(mc2[0], mc2[1], mc2[2]));
        return result;
    }

    public static Vector3D applyPoint2(Vector3D point, Matrix3D rot, Vector3D mc1, Vector3D mc2) {
        Vector3D dv = mc1.minus(mc2);
        return rot.multiply(point.minus(mc2)).plus(mc1);
    }

    public static Vector3D[] applyPoints2(Vector3D[] points, Matrix3D rot, Vector3D mc1, Vector3D mc2) {
        Vector3D[] result = new Vector3D[points.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Superimpose.applyPoint2(points[i], rot, mc1, mc2);
        }
        return result;
    }
}

