/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.Matrix3D;
import tools3d.Matrix3DTools;
import tools3d.Orientable;
import tools3d.Vector3D;

public class SuperpositionResult {
    private Matrix3D rotationMatrix;
    private Vector3D[] newCoords;
    private Vector3D shift1 = new Vector3D();
    private Vector3D shift2 = new Vector3D();
    private double rms = 0.0;

    SuperpositionResult() {
        this.rotationMatrix = new Matrix3D(1.0);
    }

    public Matrix3D getRotationMatrix() {
        return new Matrix3D(this.rotationMatrix);
    }

    public boolean isValid() {
        return this.rotationMatrix != null && this.shift1 != null && this.shift2 != null;
    }

    public void setRotationMatrix(Matrix3D m) {
        this.rotationMatrix = new Matrix3D(m);
    }

    public Vector3D[] getNewCoords() {
        return this.newCoords;
    }

    public void setNewCoords(Vector3D[] coords) {
        this.newCoords = coords;
    }

    public Vector3D getShift1() {
        return new Vector3D(this.shift1);
    }

    public Vector3D getShift2() {
        return new Vector3D(this.shift2);
    }

    public void setShift1(Vector3D shift1) {
        this.shift1 = new Vector3D(shift1);
    }

    public void setShift2(Vector3D shift2) {
        this.shift2 = new Vector3D(shift2);
    }

    public double getRms() {
        return this.rms;
    }

    public void setRms(double rms) {
        this.rms = rms;
    }

    public String toString() {
        return "" + this.rms + " " + this.shift1 + " " + this.shift2 + " " + this.rotationMatrix + " transformed coords: " + this.newCoords;
    }

    public void applyTransformation(Orientable obj) {
        assert (this.isValid());
        Vector3D origPos = obj.getPosition();
        Vector3D zeroVec = new Vector3D(0.0, 0.0, 0.0);
        obj.translate(this.shift2.mul(-1.0));
        obj.rotate(zeroVec, this.rotationMatrix);
        obj.translate(this.shift1);
        Vector3D newPos = obj.getPosition();
        assert (this.returnTransformed(origPos).distance(newPos) < 0.1);
    }

    public void applyTransformation_old(Orientable obj) {
        assert (this.isValid());
        Vector3D totShift = this.shift1.minus(this.shift2);
        obj.translate(totShift);
        double[] axisAngle = Matrix3DTools.convertRotationMatrixToAxisAngle(this.rotationMatrix);
        Vector3D axis = new Vector3D(axisAngle[0], axisAngle[1], axisAngle[2]);
        double angle360 = axisAngle[3] * 57.29577951308232;
        obj.rotate(axis, axisAngle[3]);
    }

    public void applyTransformation_old(Vector3D v) {
        assert (this.isValid());
        Vector3D totShift = this.shift1.minus(this.shift2);
        v.add(totShift);
        double[] axisAngle = Matrix3DTools.convertRotationMatrixToAxisAngle(this.rotationMatrix);
        Vector3D axis = new Vector3D(axisAngle[0], axisAngle[1], axisAngle[2]);
        double angle = axisAngle[3];
        Vector3D newPos = Matrix3DTools.rotate(v, axis, angle);
        v.copy(newPos);
    }

    public void applyTransformation(Vector3D v) {
        assert (this.isValid());
        v.sub(this.shift2);
        Vector3D newPos = this.rotationMatrix.multiply(v);
        v.copy(newPos);
        v.add(this.shift1);
    }

    public Vector3D returnTransformed(Vector3D v) {
        Vector3D newPos = new Vector3D(v);
        this.applyTransformation(newPos);
        return newPos;
    }
}

