/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import graphtools.IntegerArrayGenerator;
import graphtools.IntegerPermutator;
import java.util.logging.Logger;
import tools3d.Orientable;
import tools3d.OrientableModifier;
import tools3d.Vector3D;
import tools3d.Vector3DTools;

public class SystematicMutator2
extends IntegerArrayGenerator
implements OrientableModifier,
IntegerPermutator {
    public static final int X_ID = 0;
    public static final int Y_ID = 1;
    public static final int Z_ID = 2;
    public static final int ANGLE_ID = 3;
    public static final int AXIS_ID = 4;
    public static final int DEFAULT_SIZE = 5;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private double angleStep;
    private Vector3D[] fixedAxis;
    private double translationStep;
    private Vector3D minPos;

    public SystematicMutator2() {
    }

    public SystematicMutator2(double translationStep, Vector3D minPos, int[] maxNumbers, Vector3D axis) {
        super(maxNumbers);
        assert (maxNumbers.length == 5);
        this.translationStep = translationStep;
        assert (maxNumbers[3] > 0);
        assert (axis != null);
        this.angleStep = Math.PI * 2 / (double)maxNumbers[3];
        this.minPos = new Vector3D(minPos);
        this.fixedAxis = new Vector3D[1];
        maxNumbers[4] = 1;
        this.fixedAxis[0] = new Vector3D(axis);
        assert (this.validate());
    }

    public SystematicMutator2(double translationStep, Vector3D minPos, int[] maxNumbers) {
        super(maxNumbers);
        assert (maxNumbers.length == 5);
        this.translationStep = translationStep;
        assert (maxNumbers[3] > 0);
        this.angleStep = Math.PI * 2 / (double)maxNumbers[3];
        this.minPos = new Vector3D(minPos);
        this.fixedAxis = Vector3DTools.generateSpherePoints(maxNumbers[4], 1.0, Vector3D.ZVEC);
        assert (this.validate());
    }

    public SystematicMutator2(SystematicMutator2 other) {
        this.copy(other);
    }

    @Override
    public Object clone() {
        SystematicMutator2 result = new SystematicMutator2(this);
        return result;
    }

    @Override
    public boolean validate() {
        return super.validate() && this.hasNext() && this.size() == 5 && this.fixedAxis != null && (double)this.fixedAxis.length > 0.0 && this.minPos != null;
    }

    public void copy(SystematicMutator2 other) {
        assert (other != null);
        assert (other.validate());
        super.copy(other);
        this.angleStep = other.angleStep;
        if (this.fixedAxis == null || this.fixedAxis.length != other.fixedAxis.length) {
            this.fixedAxis = new Vector3D[other.fixedAxis.length];
        }
        for (int i = 0; i < other.fixedAxis.length; ++i) {
            if (this.fixedAxis[i] == null) {
                this.fixedAxis[i] = new Vector3D();
            }
            this.fixedAxis[i].copy(other.fixedAxis[i]);
        }
        this.translationStep = other.translationStep;
        if (this.minPos == null) {
            this.minPos = new Vector3D(other.minPos);
        } else {
            this.minPos.copy(other.minPos);
        }
    }

    @Override
    public void rotate(Orientable obj) {
        assert (false);
    }

    @Override
    public double getAngleStep() {
        return this.angleStep;
    }

    @Override
    public double getTranslationStep() {
        return this.translationStep;
    }

    @Override
    public void setAngleStep(double d) {
        this.angleStep = d;
        assert (this.validate());
    }

    @Override
    public void setTranslationStep(double d) {
        this.translationStep = d;
        assert (this.validate());
    }

    @Override
    public void mutate(Orientable obj) {
        int[] ids = this.getNumbers();
        if (ids[3] != 0) {
            obj.rotate(this.fixedAxis[ids[4]], (double)ids[3] * this.angleStep);
        }
        Vector3D pos = new Vector3D(this.minPos);
        pos.setX(pos.getX() + (double)ids[0] * this.translationStep);
        pos.setY(pos.getY() + (double)ids[1] * this.translationStep);
        pos.setZ(pos.getZ() + (double)ids[2] * this.translationStep);
        obj.setPosition(pos);
    }

    @Override
    public void scaleAngleStep(double scale) {
        this.angleStep *= scale;
    }

    @Override
    public void scaleTranslationStep(double scale) {
        this.translationStep *= scale;
    }

    @Override
    public void translate(Orientable obj) {
        assert (false);
    }

    @Override
    public String toString() {
        assert (this.minPos != null);
        return "(SystematicMutator2 " + this.translationStep + " " + 57.29577951308232 * this.angleStep + " " + this.minPos.toString() + " " + super.toString() + " )";
    }

    @Override
    public boolean inc() {
        int nai = this.getNumbers()[3];
        boolean result = super.inc();
        return result;
    }
}

