/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.CoordinateSet;
import tools3d.Point;

public class Vector2 {
    private Point point = new Point(0.0, 0.0, 0.0);
    private Point vectorPoint = new Point(0.0, 0.0, 0.0);

    public Vector2() {
    }

    public Vector2(Point point, Point vectorPoint) {
        this.setPoint(point);
        this.setVectorPoint(vectorPoint);
    }

    public Vector2(Point point, CoordinateSet xyz) {
        this.setPoint(point);
        this.setVectorPoint(xyz);
    }

    public Vector2(Point point, double x, double y, double z) {
        this.setPoint(point);
        this.setVectorPoint(new CoordinateSet(x, y, z));
    }

    public boolean equals(Vector2 v) {
        return this.getPoint().similar(v.getPoint()) && this.getVectorPoint().similar(v.getVectorPoint());
    }

    public boolean containsPoint(Point p) {
        if (p.equals(this.getPoint())) {
            return true;
        }
        return p.equals(this.getVectorPoint());
    }

    public Object cloneDeep() {
        Vector2 v = new Vector2();
        v.copyDeepThisCore(this);
        return v;
    }

    protected void copyDeepThisCore(Vector2 v) {
        this.setPoint(v.getPoint());
        this.setVectorPoint(v.getVectorPoint());
    }

    public String toString() {
        String s = new String("Vector from " + this.point + " to " + this.vectorPoint);
        return s;
    }

    public Point getPoint() {
        return this.point;
    }

    public Point getVectorPoint() {
        return this.vectorPoint;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public void setVectorPoint(Point vectorPoint) {
        this.vectorPoint = vectorPoint;
    }

    public void setVectorPoint(CoordinateSet xyz) {
        this.vectorPoint = new Point(xyz);
    }
}

