/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import java.util.logging.Logger;
import tools3d.CoordinateSystem;
import tools3d.Matrix3D;
import tools3d.Matrix4D;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleObject3D;

public class CoordinateSystem3D
extends SimpleObject3D
implements Object3D,
CoordinateSystem {
    public static final CoordinateSystem3D CARTESIAN = new CoordinateSystem3D(Vector3D.ZVEC, Vector3D.EX, Vector3D.EY);
    public static final int X_ID = 0;
    public static final int Y_ID = 1;
    public static final int Z_ID = 2;
    public static final String CLASS_NAME = "CoordinateSystem3D";
    public static final String DEFAULT_NAME = "coordinateSystem";
    public static final int ARRAY_DIM = 9;
    public static Logger log = Logger.getLogger("NanoTiler_debug");

    public CoordinateSystem3D(Vector3D basePos, Vector3D x, Vector3D y) {
        super(basePos);
        assert (Math.abs(x.dot(y)) < 0.01);
        assert (Math.abs(x.lengthSquare() - 1.0) < 0.01);
        assert (Math.abs(y.lengthSquare() - 1.0) < 0.01);
        Vector3D z = x.cross(y);
        assert (Math.abs(z.lengthSquare() - 1.0) < 0.1);
        z.normalize();
        SimpleObject3D xObj = new SimpleObject3D(basePos.plus(x));
        SimpleObject3D yObj = new SimpleObject3D(basePos.plus(y));
        SimpleObject3D zObj = new SimpleObject3D(basePos.plus(z));
        xObj.setName("x");
        yObj.setName("y");
        zObj.setName("z");
        super.insertChild(xObj);
        super.insertChild(yObj);
        super.insertChild(zObj);
        this.setName(DEFAULT_NAME);
        assert (this.isValid());
    }

    public CoordinateSystem3D(Vector3D basePos, Vector3D x, Vector3D y, Vector3D z) {
        super(basePos);
        SimpleObject3D xObj = new SimpleObject3D(basePos.plus(x));
        SimpleObject3D yObj = new SimpleObject3D(basePos.plus(y));
        SimpleObject3D zObj = new SimpleObject3D(basePos.plus(z));
        xObj.setName("x");
        yObj.setName("y");
        zObj.setName("z");
        super.insertChild(xObj);
        super.insertChild(yObj);
        super.insertChild(zObj);
        this.setName(DEFAULT_NAME);
        assert (this.isValid());
    }

    public CoordinateSystem3D(Matrix4D m) {
        this(new Vector3D(m.getXW(), m.getYW(), m.getZW()), new Vector3D(m.getXX(), m.getYX(), m.getZX()), new Vector3D(m.getXY(), m.getYY(), m.getZY()));
    }

    public CoordinateSystem3D(CoordinateSystem cs) {
        this(cs.getPosition(), cs.getX(), cs.getY(), cs.getZ());
        assert (this.isValid());
    }

    public CoordinateSystem3D(double[] ary) {
        super(new Vector3D(ary[0], ary[1], ary[2]));
        assert (ary.length == 9);
        Vector3D basePos = new Vector3D(ary[0], ary[1], ary[2]);
        Vector3D x = new Vector3D(ary[3], ary[4], ary[5]);
        assert (x.length() > 0.0);
        x.normalize();
        Vector3D y = new Vector3D(ary[6], ary[7], ary[8]);
        assert (y.length() > 0.0);
        y.normalize();
        Vector3D z = x.cross(y);
        assert (z.length() > 0.0);
        z.normalize();
        SimpleObject3D xObj = new SimpleObject3D(basePos.plus(x));
        SimpleObject3D yObj = new SimpleObject3D(basePos.plus(y));
        SimpleObject3D zObj = new SimpleObject3D(basePos.plus(z));
        xObj.setName("x");
        yObj.setName("y");
        zObj.setName("z");
        super.insertChild(xObj);
        super.insertChild(yObj);
        super.insertChild(zObj);
        this.setName(DEFAULT_NAME);
        assert (this.isValid());
    }

    public CoordinateSystem3D() {
    }

    public CoordinateSystem3D(Vector3D pos) {
        this(new Vector3D(pos), new Vector3D(1.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0));
    }

    @Override
    public Vector3D activeTransform(Vector3D p) {
        Vector3D origin = this.getPosition();
        Matrix3D mt = this.generateTransposedMatrix();
        return mt.multiply(p).plus(origin);
    }

    @Override
    public Vector3D activeTransform2(Vector3D p) {
        Vector3D origin = this.getPosition();
        Matrix3D mt = this.generateTransposedMatrix();
        return mt.multiply(p.minus(origin)).plus(origin);
    }

    @Override
    public Vector3D activeTransform3(Vector3D p) {
        Matrix4D m = this.generateMatrix4D();
        return m.multiply(p);
    }

    @Override
    public Matrix4D generateMatrix4D() {
        Vector3D origin = this.getPosition();
        Matrix3D mt = this.generateTransposedMatrix();
        return new Matrix4D(mt, origin);
    }

    @Override
    public Object cloneDeepThis() {
        CoordinateSystem3D newObj = new CoordinateSystem3D();
        newObj.copyDeepThisCore(this);
        return newObj;
    }

    @Override
    public void copy(CoordinateSystem other) {
        this.setPosition(other.getPosition());
        Object3D xObj = this.getChild(0);
        Object3D yObj = this.getChild(1);
        Object3D zObj = this.getChild(2);
        xObj.setRelativePosition(other.getX());
        yObj.setRelativePosition(other.getY());
        zObj.setRelativePosition(other.getZ());
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof CoordinateSystem)) {
            return false;
        }
        CoordinateSystem other = (CoordinateSystem)otherObject;
        return this.getPosition().equals(other.getPosition()) && this.getX().equals(other.getX()) && this.getY().equals(other.getY()) && this.getZ().equals(other.getZ());
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public Vector3D getX() {
        return this.getChild(0).getRelativePosition();
    }

    @Override
    public Vector3D getY() {
        return this.getChild(1).getRelativePosition();
    }

    @Override
    public Vector3D getZ() {
        return this.getChild(2).getRelativePosition();
    }

    private Matrix3D generateMatrix() {
        Vector3D ex = this.getX();
        Vector3D ey = this.getY();
        Vector3D ez = this.getZ();
        Matrix3D m = new Matrix3D(ex.getX(), ex.getY(), ex.getZ(), ey.getX(), ey.getY(), ey.getZ(), ez.getX(), ez.getY(), ez.getZ());
        return m;
    }

    private Matrix3D generateTransposedMatrix() {
        Vector3D ex = this.getX();
        Vector3D ey = this.getY();
        Vector3D ez = this.getZ();
        Matrix3D mt = new Matrix3D(ex.getX(), ey.getX(), ez.getX(), ex.getY(), ey.getY(), ez.getY(), ex.getZ(), ey.getZ(), ez.getZ());
        return mt;
    }

    @Override
    public CoordinateSystem inverse() {
        Matrix4D m = this.generateMatrix4D();
        return new CoordinateSystem3D(m.inverse());
    }

    @Override
    public boolean isUnitTransform(double error) {
        return this.getPosition().length() < 0.01 && this.getX().minus(Vector3D.EX).length() < error && this.getY().minus(Vector3D.EY).length() < error && this.getZ().minus(Vector3D.EZ).length() < error;
    }

    @Override
    public boolean isCartesian() {
        assert (this.isValid());
        Vector3D x = this.getX();
        Vector3D y = this.getY();
        Vector3D z = this.getZ();
        boolean result = CoordinateSystem3D.isUnitLength(x) && CoordinateSystem3D.isUnitLength(y) && CoordinateSystem3D.isUnitLength(z) && CoordinateSystem3D.isRightAngle(x, y) && CoordinateSystem3D.isRightAngle(x, z) && CoordinateSystem3D.isRightAngle(y, z) && CoordinateSystem3D.isRightHanded(x, y, z);
        return result;
    }

    @Override
    public boolean isValid() {
        boolean result = true;
        if (this.size() < 3) {
            return false;
        }
        return this.getX().isValid() && this.getY().isValid() && this.getZ().isValid();
    }

    private static boolean isUnitLength(Vector3D v) {
        return Math.abs(v.length() - 1.0) < 0.001;
    }

    private static boolean isRightAngle(Vector3D v, Vector3D w) {
        return Math.abs(v.dot(w)) < 0.01;
    }

    private static boolean isRightHanded(Vector3D x, Vector3D y, Vector3D z) {
        Vector3D diff = z.minus(x.cross(y));
        return diff.length() < 0.01;
    }

    @Override
    public Vector3D passiveTransform(Vector3D p) {
        Vector3D origin = this.getPosition();
        Matrix3D m = this.generateMatrix();
        return m.multiply(p.minus(origin));
    }

    @Override
    public Vector3D passiveTransform2(Vector3D p) {
        Vector3D origin = this.getPosition();
        Matrix3D m = this.generateMatrix();
        return m.multiply(p.minus(origin)).plus(origin);
    }

    @Override
    public Vector3D passiveTransform3(Vector3D p) {
        Matrix4D m = this.generateMatrix4D().inverse();
        return m.multiply(p);
    }

    public static void renormalize(double[] ary) {
        Vector3D x = new Vector3D(ary[3], ary[4], ary[5]);
        Vector3D y = new Vector3D(ary[6], ary[7], ary[8]);
        if (x.lengthSquare() == 0.0) {
            x.copy(Vector3DTools.generateRandomDirection());
        } else {
            x.normalize();
        }
        assert (CoordinateSystem3D.isUnitLength(x));
        if (y.lengthSquare() == 0.0) {
            y.copy(Vector3DTools.generateRandomOrthogonalDirection(x));
        } else {
            y.copy(Vector3DTools.generateOrthogonalDirection(x, y));
        }
        assert (CoordinateSystem3D.isUnitLength(y));
        assert (CoordinateSystem3D.isRightAngle(x, y));
        x.setArray(ary, 3);
        y.setArray(ary, 6);
    }

    @Override
    public void scale(Vector3D factor) {
        this.scaling.scale(factor);
        this.relativePosition.scale(factor);
    }

    @Override
    public double[] toArray() {
        double[] result = new double[9];
        this.getPosition().setArray(result, 0);
        this.getX().setArray(result, 3);
        this.getY().setArray(result, 6);
        return result;
    }

    @Override
    public String toStringBody() {
        String result = new String();
        result = this.getName() + " ";
        result = result + this.getPosition();
        result = result + " " + this.size();
        for (int i = 0; i < this.size(); ++i) {
            result = result + " " + this.getChild(i).getRelativePosition();
        }
        result = result + " ";
        return result;
    }

    @Override
    public String toString() {
        String result = new String();
        result = "(" + this.getClassName() + " " + this.toStringBody() + " )";
        return result;
    }
}

