/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import tools3d.Edge3D;
import tools3d.Geometry;
import tools3d.Point3D;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class Object3DLinkSetBundleTools {
    private static int findPointIndex(Vector3D point, Point3D[] points) {
        for (int i = 0; i < points.length; ++i) {
            if (!points[i].getPosition().equals(point)) continue;
            return i;
        }
        return -1;
    }

    public static Object3DLinkSetBundle generateBundleFromGeometry(Geometry geometry, String rootName, String childNameBase, Object3D template) {
        assert (geometry != null);
        assert (rootName != null);
        assert (childNameBase != null);
        assert (template != null);
        Object3D root = (Object3D)template.cloneEmpty();
        root.setName(rootName);
        Point3D[] points = new Point3D[geometry.getNumberPoints()];
        for (int i = 0; i < geometry.getNumberPoints(); ++i) {
            Object3D child = (Object3D)template.cloneEmpty();
            child.setPosition(geometry.getPoint(i).getPosition());
            String childName = childNameBase + (i + 1);
            child.setName(childName);
            root.insertChild(child);
            points[i] = geometry.getPoint(i);
        }
        SimpleLinkSet linkSet = new SimpleLinkSet();
        for (int i = 0; i < geometry.getNumberEdges(); ++i) {
            Edge3D edge = geometry.getEdge(i);
            Vector3D p1 = edge.getFirst();
            Vector3D p2 = edge.getSecond();
            int p1Idx = Object3DLinkSetBundleTools.findPointIndex(p1, points);
            int p2Idx = Object3DLinkSetBundleTools.findPointIndex(p2, points);
            SimpleLink link = new SimpleLink(root.getChild(p1Idx), root.getChild(p2Idx));
            linkSet.add(link);
        }
        return new SimpleObject3DLinkSetBundle(root, linkSet);
    }

    public static Object3DLinkSetBundle generateClone(Object3D root, LinkSet allLinks) {
        return null;
    }

    public static Object3DSet generateGraphSet(Object3D root, LinkSet allLinks) {
        SimpleObject3DSet objSet = new SimpleObject3DSet(root);
        SimpleObject3DSet result = new SimpleObject3DSet();
        for (int i = 0; i < allLinks.size(); ++i) {
            Link link = allLinks.get(i);
            Object3D obj1 = link.getObj1();
            Object3D obj2 = link.getObj2();
            if (!objSet.contains(obj1) || !objSet.contains(obj2)) continue;
            if (!result.contains(obj1)) {
                result.add(obj1);
            }
            if (result.contains(obj2)) continue;
            result.add(obj2);
        }
        return result;
    }

    public static LinkSet generateGraphLinks(Object3D root, LinkSet allLinks) {
        SimpleObject3DSet objSet = new SimpleObject3DSet(root);
        SimpleLinkSet result = new SimpleLinkSet();
        for (int i = 0; i < allLinks.size(); ++i) {
            Link link = allLinks.get(i);
            Object3D obj1 = link.getObj1();
            Object3D obj2 = link.getObj2();
            if (!objSet.contains(obj1) || !objSet.contains(obj2)) continue;
            result.add(link);
        }
        return result;
    }
}

