/*
 * Decompiled with CFR 0.152.
 */
package viewer.commands;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.media.opengl.GL;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.Vector3D;
import tools3d.Vector4D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import viewer.commands.ToggableDisplayCommand;
import viewer.deprecated.DefaultRNAModelRenderer;
import viewer.display.Display;
import viewer.event.DisplayEvent;
import viewer.event.DisplayLayoutListener;
import viewer.event.DisplayViewChangedListener;
import viewer.graphics.Material;
import viewer.graphics.RenderableModel;
import viewer.rnadesign.GraphControllerDisplayManager;
import viewer.rnadesign.LinkRenderer;
import viewer.util.Tools;

public class GraphEditor
extends ToggableDisplayCommand
implements RenderableModel,
DisplayViewChangedListener,
DisplayLayoutListener {
    private Object3DGraphController controller;
    private GraphControllerDisplayManager manager;
    private LinkSet links;
    private Object3D root;
    private int nodeCounter = 0;
    private int linkCounter = 0;
    private Listener listener = new Listener();
    private Object3D selected1;
    private Object3D selected2;
    private ModePanel panel;
    private Mode currentMode = Mode.NodeAdd;

    public GraphEditor(Object3DGraphController controller, GraphControllerDisplayManager manager) {
        this.controller = controller;
        this.manager = manager;
        this.root = new SimpleObject3D();
        this.links = new SimpleLinkSet();
    }

    @Override
    public void executeOff(Display d) {
        this.manager.setObjectSelectionEnabled(true);
        if (this.root.size() > 0) {
            this.controller.getGraph().addGraph(this.root);
            this.controller.getLinks().addLinks(this.links);
        }
        this.root = new SimpleObject3D();
        this.panel.dispose();
        this.manager.getDisplay().removeRenderable(this);
        this.linkCounter = 0;
        this.nodeCounter = 0;
        this.manager.removeDisplayLayoutListener(this);
        this.manager.getDisplay().removeDisplayViewChangedListener(this);
        this.manager.setViewTranslationEnabled(true);
        this.detachListener();
    }

    @Override
    public void executeOn(Display d) {
        this.manager.setObjectSelectionEnabled(false);
        this.panel = new ModePanel();
        this.panel.setVisible(true);
        this.manager.getDisplay().addRenderable(this);
        this.manager.addDisplayLayoutListener(this);
        this.manager.getDisplay().addDisplayViewChangedListener(this);
        this.links = new SimpleLinkSet();
        this.attachListener();
    }

    public void executeOn(Display d, Object3D root, LinkSet links) {
        this.manager.setObjectSelectionEnabled(false);
        this.panel = new ModePanel();
        this.panel.setVisible(true);
        this.manager.getDisplay().addRenderable(this);
        this.manager.addDisplayLayoutListener(this);
        this.manager.getDisplay().addDisplayViewChangedListener(this);
    }

    private void attachListener() {
        for (Display d : this.manager.getDisplay().getDisplays()) {
            d.addMouseListener(this.listener);
            d.addMouseMotionListener(this.listener);
        }
    }

    private void detachListener() {
        for (Display d : this.manager.getDisplay().getDisplays()) {
            d.removeMouseListener(this.listener);
            d.removeMouseMotionListener(this.listener);
        }
    }

    @Override
    public void execute(Display d) {
        if (this.isOn() && this.root.size() > 0) {
            int result = JOptionPane.showConfirmDialog(this.manager, "Graph has been manipulated. Commit graph?");
            if (result == 2) {
                return;
            }
            if (result == 1) {
                this.links = new SimpleLinkSet();
                this.root = new SimpleObject3D();
            }
        }
        super.execute(d);
    }

    @Override
    public JComponent component(final Display d) {
        JButton button = new JButton("Graph Editor");
        button.setToolTipText("Graph Editor");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.execute(d);
            }
        });
        return button;
    }

    @Override
    public String description() {
        return "Toggles graph editor mode";
    }

    @Override
    public KeyStroke keyStroke() {
        return KeyStroke.getKeyStroke(69, 2, true);
    }

    private void clearSelection() {
        if (this.selected1 != null) {
            this.selected1.setSelected(false);
            this.selected1 = null;
        }
        if (this.selected2 != null) {
            this.selected2.setSelected(false);
            this.selected2 = null;
        }
    }

    @Override
    public void render(GL gl) {
        Material material = new Material(Color.white);
        Material.renderMaterial(gl, material);
        DefaultRNAModelRenderer renderer = new DefaultRNAModelRenderer();
        for (int i = 0; i < this.root.size(); ++i) {
            Object3D o = this.root.getChild(i);
            Material.renderMaterial(gl, material);
            renderer.renderSphere(o, gl);
            if (!o.isSelected()) continue;
            renderer.renderSelected(o, gl);
        }
        LinkRenderer linkRenderer = this.manager.getLinkRenderer();
        for (int i = 0; i < this.links.size(); ++i) {
            linkRenderer.renderLink(this.links.get(i), gl);
        }
    }

    @Override
    public void displayLayoutChanged(DisplayEvent e) {
        this.attachListener();
        this.manager.getDisplay().addDisplayViewChangedListener(this);
    }

    @Override
    public void displayChanged(DisplayEvent e) {
        if (e.getId() == 1) {
            Display d = e.getDisplay();
            d.addMouseListener(this.listener);
        }
    }

    private class ModePanel
    extends JDialog {
        private ButtonGroup group;
        private JRadioButton nodeAdd;
        private JRadioButton nodeRemove;
        private JRadioButton linkAdd;
        private JRadioButton linkRemove;
        private JRadioButton nodeManipulate;

        public ModePanel() {
            super((Frame)null, "Mode Select", false);
            this.setDefaultCloseOperation(2);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            this.group = new ButtonGroup();
            this.nodeAdd = new JRadioButton("Add Graph Node");
            this.nodeAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphEditor.this.currentMode = Mode.NodeAdd;
                    GraphEditor.this.manager.setViewTranslationEnabled(true);
                    GraphEditor.this.clearSelection();
                }
            });
            this.group.add(this.nodeAdd);
            this.group.setSelected(this.nodeAdd.getModel(), true);
            panel.add(this.nodeAdd);
            this.nodeManipulate = new JRadioButton("Manipulate Graph Node");
            this.nodeManipulate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphEditor.this.currentMode = Mode.NodeManipulate;
                    GraphEditor.this.manager.setViewTranslationEnabled(false);
                    GraphEditor.this.clearSelection();
                }
            });
            this.group.add(this.nodeManipulate);
            panel.add(this.nodeManipulate);
            this.nodeRemove = new JRadioButton("Remove Graph Node");
            this.nodeRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphEditor.this.currentMode = Mode.NodeRemove;
                    GraphEditor.this.manager.setViewTranslationEnabled(true);
                    GraphEditor.this.clearSelection();
                }
            });
            this.group.add(this.nodeRemove);
            panel.add(this.nodeRemove);
            this.linkAdd = new JRadioButton("Add Link");
            this.linkAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphEditor.this.currentMode = Mode.LinkAdd;
                    GraphEditor.this.manager.setViewTranslationEnabled(true);
                    GraphEditor.this.clearSelection();
                }
            });
            this.group.add(this.linkAdd);
            panel.add(this.linkAdd);
            this.linkRemove = new JRadioButton("Remove Link");
            this.linkRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphEditor.this.currentMode = Mode.LinkRemove;
                    GraphEditor.this.manager.setViewTranslationEnabled(true);
                    GraphEditor.this.clearSelection();
                }
            });
            this.group.add(this.linkRemove);
            panel.add(this.linkRemove);
            JLabel label = new JLabel("Select the graph editor button again to close this window");
            panel.add(label);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    this.recreate();
                }

                private void recreate() {
                    GraphEditor.this.panel = new ModePanel();
                    GraphEditor.this.panel.setVisible(true);
                    GraphEditor.this.panel.setSelected(GraphEditor.this.currentMode);
                }
            });
            this.add(panel);
            this.pack();
        }

        public void setSelected(Mode mode) {
            switch (mode) {
                case NodeAdd: {
                    this.group.setSelected(this.nodeAdd.getModel(), true);
                    return;
                }
                case NodeRemove: {
                    this.group.setSelected(this.nodeRemove.getModel(), true);
                    return;
                }
                case LinkAdd: {
                    this.group.setSelected(this.linkAdd.getModel(), true);
                    return;
                }
                case LinkRemove: {
                    this.group.setSelected(this.linkRemove.getModel(), true);
                    return;
                }
                case NodeManipulate: {
                    this.group.setSelected(this.nodeManipulate.getModel(), true);
                    return;
                }
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        Vector4D p = null;

        private Listener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (GraphEditor.this.currentMode == Mode.NodeManipulate) {
                this.p = ((Display)e.getSource()).getCoordinates(e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.p = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (GraphEditor.this.currentMode != Mode.NodeManipulate || GraphEditor.this.selected1 == null) {
                return;
            }
            Vector4D to = ((Display)e.getSource()).getCoordinates(e.getPoint());
            Vector4D diff = to.minus(this.p);
            Vector3D offset = new Vector3D(diff);
            GraphEditor.this.selected1.setPosition(GraphEditor.this.selected1.getPosition().plus(offset));
            this.p = to;
            GraphEditor.this.manager.getDisplay().repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Display d = (Display)e.getSource();
            Vector4D origin = new Vector4D(0.0, 0.0, 0.0, 1.0);
            Vector4D ray = new Vector4D(0.0, 0.0, 0.0, 0.0);
            Tools.screenTo3DSpace(e.getPoint(), d, ray, origin);
            Object3D found = GraphEditor.this.manager.getSelector().findSelected(ray, origin, GraphEditor.this.root);
            if (found != null && found != GraphEditor.this.root) {
                if (GraphEditor.this.selected1 == null) {
                    GraphEditor.this.selected1 = found;
                    GraphEditor.this.selected1.setSelected(true);
                } else if (GraphEditor.this.selected1 == found) {
                    GraphEditor.this.selected1.setSelected(false);
                    GraphEditor.this.selected1 = null;
                } else if (GraphEditor.this.selected2 == null && GraphEditor.this.currentMode != Mode.NodeManipulate) {
                    GraphEditor.this.selected2 = found;
                } else if (GraphEditor.this.currentMode != Mode.NodeManipulate) {
                    GraphEditor.this.selected1.setSelected(false);
                    GraphEditor.this.selected2.setSelected(false);
                    GraphEditor.this.selected1 = found;
                    GraphEditor.this.selected2 = null;
                }
            }
            if (GraphEditor.this.currentMode == Mode.NodeAdd && (found == null || found == GraphEditor.this.root)) {
                final Vector3D position = new Vector3D(d.getCoordinates(e.getPoint()));
                if (e.getButton() != 1) {
                    final JDialog dialog = new JDialog((Frame)null, "Coordinate Manipulator", true);
                    JPanel panel = new JPanel();
                    panel.setLayout(new BoxLayout(panel, 1));
                    JPanel temp = new JPanel();
                    temp.add(new JLabel("X"));
                    final JTextField xfield = new JTextField(5);
                    DecimalFormat fmt = new DecimalFormat("###.000");
                    xfield.setText(fmt.format(position.getX()));
                    temp.add(xfield);
                    panel.add(temp);
                    temp = new JPanel();
                    temp.add(new JLabel("Y"));
                    final JTextField yfield = new JTextField(5);
                    yfield.setText(fmt.format(position.getY()));
                    temp.add(yfield);
                    panel.add(temp);
                    temp = new JPanel();
                    temp.add(new JLabel("Z"));
                    final JTextField zfield = new JTextField(5);
                    zfield.setText(fmt.format(position.getZ()));
                    temp.add(zfield);
                    panel.add(temp);
                    temp = new JPanel();
                    JButton submit = new JButton("Submit");
                    submit.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                position.setX(Double.parseDouble(xfield.getText()));
                                position.setY(Double.parseDouble(yfield.getText()));
                                position.setZ(Double.parseDouble(zfield.getText()));
                                dialog.dispose();
                            }
                            catch (NumberFormatException ex) {
                                JOptionPane.showMessageDialog(dialog, "Please enter only numbers");
                            }
                        }
                    });
                    temp.add(submit);
                    panel.add(temp);
                    dialog.setLocationRelativeTo(GraphEditor.this.manager);
                    dialog.add(panel);
                    dialog.pack();
                    dialog.setDefaultCloseOperation(2);
                    dialog.setVisible(true);
                }
                SimpleObject3D o = new SimpleObject3D(position);
                o.setName("n" + GraphEditor.this.nodeCounter++);
                GraphEditor.this.root.insertChild(o);
            } else if (GraphEditor.this.currentMode == Mode.NodeRemove && found != null && found != GraphEditor.this.root) {
                GraphEditor.this.root.removeChild(found);
                GraphEditor.this.links.removeBadLinks(GraphEditor.this.root);
                GraphEditor.this.selected1 = null;
            } else if (GraphEditor.this.selected1 != null && GraphEditor.this.selected2 != null) {
                Link l = GraphEditor.this.links.find(GraphEditor.this.selected1, GraphEditor.this.selected2);
                if (GraphEditor.this.currentMode == Mode.LinkAdd && l == null) {
                    SimpleLink link = new SimpleLink(GraphEditor.this.selected1, GraphEditor.this.selected2);
                    link.setName("l" + GraphEditor.this.linkCounter++);
                    GraphEditor.this.links.add(link);
                    GraphEditor.this.selected1.setSelected(false);
                    GraphEditor.this.selected2.setSelected(false);
                    GraphEditor.this.selected1 = (GraphEditor.this.selected2 = null);
                } else if (GraphEditor.this.currentMode == Mode.LinkRemove && l != null) {
                    GraphEditor.this.links.remove(l);
                    GraphEditor.this.selected1.setSelected(false);
                    GraphEditor.this.selected2.setSelected(false);
                    GraphEditor.this.selected1 = (GraphEditor.this.selected2 = null);
                }
            }
            GraphEditor.this.manager.display();
        }
    }

    public static enum Mode {
        NodeAdd,
        LinkAdd,
        LinkRemove,
        NodeRemove,
        NodeManipulate;

    }
}

