/*
 * Decompiled with CFR 0.152.
 */
package viewer.deprecated;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.swing.JOptionPane;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.Vector3D;
import tools3d.Vector4D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import tools3d.splines.StandaloneSplineFactory;
import viewer.deprecated.RNAModelRenderer;
import viewer.graphics.ColorModel;
import viewer.graphics.Colorable;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.MeshOperations;
import viewer.graphics.MeshRenderer;
import viewer.graphics.SolidMeshRenderer;
import viewer.graphics.WireframeMeshRenderer;
import viewer.rnadesign.StrandColorModel;
import viewer.util.Pair;

public class RibbonRenderer
implements RNAModelRenderer,
Colorable,
ModelChangeListener {
    private Vector4D[] shape = new Vector4D[]{new Vector4D(1.5, 0.0, 1.0E-4, 1.0), new Vector4D(-1.5, 0.0, 1.0E-4, 1.0), new Vector4D(-1.5, 0.0, -1.0E-4, 1.0), new Vector4D(1.5, 0.0, -1.0E-4, 1.0)};
    private static final int REFINEMENT = 3;
    private List<Pair<Mesh, Material>> meshes = new ArrayList<Pair<Mesh, Material>>();
    private Vector4D shapeNormal = new Vector4D(0.0, 1.0, 0.0, 0.0);
    private ColorModel model = new StrandColorModel();
    private Object3DGraphController controller;
    private boolean wireframeMode = false;

    @Override
    public Object3DGraphController getController() {
        return this.controller;
    }

    public RibbonRenderer(Object3DGraphController controller) {
        this(controller, null);
    }

    public RibbonRenderer() {
        this(null, null);
    }

    public RibbonRenderer(Object3DGraphController controller, ColorModel model) {
        this.controller = controller;
        this.model = model;
        controller.addModelChangeListener(this);
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        this.assembleMesh();
    }

    @Override
    public boolean getRenderAtom() {
        return false;
    }

    @Override
    public boolean getRenderBranchDescriptor() {
        return false;
    }

    @Override
    public boolean getRenderKissingLoop() {
        return false;
    }

    @Override
    public boolean getRenderLinks() {
        return false;
    }

    @Override
    public boolean getRenderNucleotide() {
        return false;
    }

    @Override
    public boolean getRenderOther() {
        return false;
    }

    @Override
    public boolean getRenderRNAStem() {
        return false;
    }

    @Override
    public boolean getRenderStrand() {
        return true;
    }

    @Override
    public boolean getRenderStrandJunction() {
        return false;
    }

    @Override
    public void renderAtom(Atom3D atom, GL gl) {
    }

    @Override
    public void renderBranchDescriptor(BranchDescriptor3D bd, GL gl) {
    }

    @Override
    public void renderKissingLoop(KissingLoop3D kl, GL gl) {
    }

    @Override
    public void renderLink(Link link, GL gl) {
    }

    @Override
    public void renderNucleotide(Nucleotide3D n, GL gl) {
    }

    @Override
    public void renderOther(Object3D o, GL gl) {
    }

    @Override
    public void renderRNAStem(RnaStem3D stem, GL gl) {
    }

    @Override
    public void renderRnaStrand(RnaStrand strand, GL gl) {
    }

    @Override
    public void renderSelected(Object3D o, GL gl) {
    }

    @Override
    public void renderStrandJunction(StrandJunction3D sj, GL gl) {
    }

    private void assembleMesh() {
        this.meshes.clear();
        this.assembleMeshes(this.controller.getGraph().getGraph());
    }

    private void assembleMeshes(Object3D o) {
        if (o instanceof RnaStrand) {
            this.assembleStrandMesh((RnaStrand)o);
        }
        if (o.size() == 0) {
            return;
        }
        for (int i = 0; i < o.size(); ++i) {
            this.assembleMeshes(o.getChild(i));
        }
    }

    private void assembleStrandMesh(RnaStrand s) {
        ArrayList<Vector3D> backbone = new ArrayList<Vector3D>();
        block0: for (int i = 0; i < s.getResidueCount(); ++i) {
            Residue3D r = s.getResidue3D(i);
            if (!(r instanceof Nucleotide3D)) continue;
            Nucleotide3D n = (Nucleotide3D)r;
            for (int j = 0; j < n.getAtomCount(); ++j) {
                Atom3D atom = n.getAtom(j);
                if (!NucleotideTools.isPhosphate(atom) || !NucleotideTools.isBackboneAtom(atom)) continue;
                backbone.add(atom.getPosition());
                continue block0;
            }
        }
        if (backbone.size() < 2) {
            JOptionPane.showMessageDialog(null, "Ribbon renderer cannot render molecule. Please switch to a different renderer.");
            return;
        }
        Vector3D[] points = new Vector3D[backbone.size()];
        backbone.toArray(points);
        StandaloneSplineFactory factory = new StandaloneSplineFactory();
        Vector3D[] curve = factory.createCubic(points, 3);
        Mesh m = MeshOperations.extend(this.shape, this.shapeNormal, curve);
        this.meshes.add(Pair.makePair(m, this.model != null ? this.model.getMaterial(s) : null));
    }

    @Override
    public void setController(Object3DGraphController controller) {
        this.controller = controller;
        this.assembleMeshes(controller.getGraph().getGraph());
    }

    @Override
    public void setWireframeMode(boolean wireframeMode) {
        this.wireframeMode = wireframeMode;
    }

    @Override
    public void render(GL gl) {
        this.render(gl, this.controller.getGraph().getGraph());
    }

    private void render(GL gl, Object3D o) {
        if (this.meshes.size() == 0) {
            this.assembleMesh();
        }
        for (Pair<Mesh, Material> m : this.meshes) {
            if (m.getSecond() != null) {
                Material.renderMaterial(gl, m.getSecond());
            }
            MeshRenderer r = this.wireframeMode ? new WireframeMeshRenderer(m.getFirst()) : new SolidMeshRenderer(m.getFirst());
            r.render(gl);
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.model;
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.model = model;
        this.assembleMesh();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

