/*
 * Decompiled with CFR 0.152.
 */
package viewer.display;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import viewer.display.Display;
import viewer.display.OrthogonalDisplay;
import viewer.display.PerspectiveDisplay;
import viewer.event.DisplayEvent;
import viewer.event.DisplayViewChangedListener;
import viewer.graphics.CloneableRenderableModel;
import viewer.graphics.RenderableAggregator;
import viewer.graphics.RenderableModel;

public class MultiDisplay
extends JPanel
implements RenderableAggregator {
    private RenderableModel model;
    private LinkedList<Display> displays = new LinkedList();
    private ArrayList<DisplayViewChangedListener> listeners = new ArrayList();

    public void addDisplayViewChangedListener(DisplayViewChangedListener l) {
        this.listeners.add(l);
    }

    public boolean removeDisplayViewChangedListener(DisplayViewChangedListener l) {
        return this.listeners.remove(l);
    }

    public void notifyDisplayViewChanged(int id, Display d) {
        for (DisplayViewChangedListener l : this.listeners) {
            l.displayChanged(new DisplayEvent(this, id, d));
        }
    }

    public void registerDisplay(Display d) {
        if (d.getOwner() != null) {
            d.getOwner().unregisterDisplay(d);
        }
        d.setOwner(this);
        this.displays.add(d);
        this.notifyDisplayViewChanged(1, d);
    }

    public boolean unregisterDisplay(Display d) {
        d.setOwner(null);
        this.notifyDisplayViewChanged(2, d);
        return this.displays.remove(d);
    }

    public void setGridColor(Color c) {
        for (Display d : this.displays) {
            d.setGridColor(c);
        }
    }

    public void setGridVisible(boolean gridVisible) {
        for (Display d : this.displays) {
            d.setGridVisible(gridVisible);
        }
    }

    public void setModel(RenderableModel model) {
        this.model = model;
        for (Display d : this.displays) {
            d.setModel(model);
        }
    }

    public void setModelClones(CloneableRenderableModel model) {
        this.model = model;
        for (Display d : this.displays) {
            d.setModel((RenderableModel)model.clone());
        }
    }

    public RenderableModel getModel() {
        return this.model;
    }

    @Override
    public void remove(Component c) {
        if (c instanceof PerspectiveDisplay || c instanceof OrthogonalDisplay) {
            this.displays.remove(c);
        }
        super.remove(c);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.displays.clear();
    }

    public List<Display> getDisplays() {
        return new LinkedList<Display>(this.displays);
    }

    @Override
    public List<RenderableModel> getRenderables() {
        if (this.getDisplays().size() > 0) {
            return this.getDisplays().get(0).getRenderables();
        }
        return null;
    }

    @Override
    public void addRenderable(Collection<RenderableModel> models) {
        for (Display d : this.getDisplays()) {
            d.addRenderable(models);
        }
    }

    @Override
    public void addRenderable(RenderableModel model) {
        for (Display d : this.getDisplays()) {
            d.addRenderable(model);
        }
    }

    @Override
    public boolean removeRenderable(RenderableModel model) {
        boolean allReturnedTrue = true;
        for (Display d : this.getDisplays()) {
            if (d.removeRenderable(model)) continue;
            allReturnedTrue = false;
        }
        return allReturnedTrue;
    }

    @Override
    public void removeAllRenderables() {
        for (Display d : this.getDisplays()) {
            d.removeAllRenderables();
        }
    }
}

