/*
 * Decompiled with CFR 0.152.
 */
package viewer.display;

import java.awt.Color;
import java.awt.Point;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import tools3d.CollisionDetectionTools;
import tools3d.Vector4D;
import viewer.components.ViewManipulator;
import viewer.display.Display;
import viewer.event.ViewEvent;
import viewer.event.ViewListener;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.PrimitiveFactory;
import viewer.graphics.RenderableModel;
import viewer.graphics.WireframeMeshRenderer;
import viewer.util.Tools;
import viewer.view.PerspectiveView;

public class PerspectiveDisplay
extends Display {
    private double viewSize = 4000.0;
    private double viewBegin = 5.0;
    private Mesh grid;
    private boolean fog = false;
    private ViewManipulator.ZoomListener zoomListener;
    private ViewManipulator.RotateListener rotateListener;
    private ViewManipulator.TranslateListener translateListener;
    private double angle;
    private PerspectiveView view;

    public PerspectiveDisplay(PerspectiveView view) {
        this.view = view;
        this.setBackground(Color.black);
        this.addGLEventListener(new PerspectiveDisplayRenderer());
        view.addViewListener(new ViewListener(){

            @Override
            public void viewChanged(ViewEvent e) {
                PerspectiveDisplay.this.display();
            }
        });
        this.grid = PrimitiveFactory.generateSheet(Tools.Y_AXIS, 500.0, 500.0, (int)(500.0 / this.getGridSize()), (int)(500.0 / this.getGridSize()));
        ViewManipulator manipulator = new ViewManipulator(this.getView());
        this.zoomListener = manipulator.new ViewManipulator.ZoomListener();
        this.rotateListener = manipulator.new ViewManipulator.RotateListener();
        this.translateListener = manipulator.new ViewManipulator.TranslateListener();
        this.addMouseListener(this.zoomListener);
        this.addMouseMotionListener(this.zoomListener);
        this.addMouseListener(this.rotateListener);
        this.addMouseMotionListener(this.rotateListener);
        this.addMouseListener(this.translateListener);
        this.addMouseMotionListener(this.translateListener);
    }

    public PerspectiveDisplay(PerspectiveView view, RenderableModel model) {
        this(view);
        this.setModel(model);
    }

    @Override
    public void setMouseTranslationEnabled(boolean mouseTranslationEnabled) {
        boolean oldMode = this.isMouseTranslationEnabled();
        super.setMouseTranslationEnabled(mouseTranslationEnabled);
        if (mouseTranslationEnabled && !oldMode) {
            this.addMouseListener(this.zoomListener);
            this.addMouseMotionListener(this.zoomListener);
            this.addMouseListener(this.rotateListener);
            this.addMouseMotionListener(this.rotateListener);
            this.addMouseListener(this.translateListener);
            this.addMouseMotionListener(this.translateListener);
        } else if (!mouseTranslationEnabled && oldMode) {
            this.removeMouseListener(this.zoomListener);
            this.removeMouseMotionListener(this.zoomListener);
            this.removeMouseListener(this.rotateListener);
            this.removeMouseMotionListener(this.rotateListener);
            this.removeMouseListener(this.translateListener);
            this.removeMouseMotionListener(this.translateListener);
        }
    }

    @Override
    public ViewManipulator.ZoomListener getZoomListener() {
        return this.zoomListener;
    }

    @Override
    public ViewManipulator.RotateListener getRotateListener() {
        return this.rotateListener;
    }

    @Override
    public ViewManipulator.TranslateListener getTranslateListener() {
        return this.translateListener;
    }

    @Override
    public void setZoomListener(ViewManipulator.ZoomListener listener) {
        if (this.zoomListener != null) {
            this.removeMouseListener(this.zoomListener);
            this.removeMouseMotionListener(this.zoomListener);
            this.zoomListener = listener;
            if (this.zoomListener != null) {
                this.addMouseListener(this.zoomListener);
                this.addMouseMotionListener(this.zoomListener);
            }
        }
    }

    @Override
    public void setRotateListener(ViewManipulator.RotateListener listener) {
        if (this.rotateListener != null) {
            this.removeMouseListener(this.rotateListener);
            this.removeMouseMotionListener(this.rotateListener);
            this.rotateListener = listener;
            if (this.rotateListener != null) {
                this.addMouseListener(this.rotateListener);
                this.addMouseMotionListener(this.rotateListener);
            }
        }
    }

    @Override
    public void setTranslateListener(ViewManipulator.TranslateListener listener) {
        if (this.translateListener != null) {
            this.removeMouseListener(this.translateListener);
            this.removeMouseMotionListener(this.translateListener);
            this.translateListener = listener;
            if (this.translateListener != null) {
                this.addMouseListener(this.translateListener);
                this.addMouseMotionListener(this.translateListener);
            }
        }
    }

    public boolean getFog() {
        return this.fog;
    }

    public void setFog(boolean fog) {
        this.fog = fog;
        GLContext context = this.getContext();
        int result = context.makeCurrent();
        if (result == 1) {
            GL gl = context.getGL();
            if (fog) {
                gl.glEnable(2912);
            } else {
                gl.glDisable(2912);
            }
        }
        this.repaint();
    }

    @Override
    public void setGridSize(double gridSize) {
        super.setGridSize(gridSize);
        this.grid = PrimitiveFactory.generateSheet(Tools.Y_AXIS, 500.0, 500.0, (int)(500.0 / gridSize), (int)(500.0 / gridSize));
    }

    @Override
    public PerspectiveView getView() {
        return this.view;
    }

    public void setView(PerspectiveView view) {
        this.view = view;
        this.display();
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public Vector4D getCoordinates(Point p) {
        Vector4D ray = new Vector4D(0.0, 0.0, 0.0, 0.0);
        Vector4D origin = new Vector4D(0.0, 0.0, 0.0, 1.0);
        Tools.screenTo3DSpace(p, this, ray, origin);
        Vector4D offset = Tools.translate(this.getView().getViewLocation(), ray, 100.0);
        Vector4D normal = this.getView().getViewDirection().mul(-1.0);
        Vector4D collision = CollisionDetectionTools.linePlaneIntersection(ray, origin, normal, -1.0 * offset.dot(normal));
        return collision;
    }

    public class PerspectiveDisplayRenderer
    implements GLEventListener {
        @Override
        public void display(GLAutoDrawable d) {
            GL gl = d.getGL();
            gl.glClear(16640);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            GLU glu = new GLU();
            Vector4D eye = PerspectiveDisplay.this.view.getViewLocation();
            Vector4D lookAt = PerspectiveDisplay.this.view.getViewDirection();
            Vector4D up = PerspectiveDisplay.this.view.getViewDirectionNormal();
            glu.gluLookAt(eye.getX(), eye.getY(), eye.getZ(), eye.getX() + lookAt.getX(), eye.getY() + lookAt.getY(), eye.getZ() + lookAt.getZ(), up.getX(), up.getY(), up.getZ());
            for (RenderableModel m : PerspectiveDisplay.this.getRenderables()) {
                m.render(gl);
            }
            if (PerspectiveDisplay.this.isGizmoEnabled()) {
                PerspectiveDisplay.this.getGizmo().render(gl);
            }
            if (PerspectiveDisplay.this.isRenderCoordinateAxis()) {
                gl.glLineWidth(1.0f);
                gl.glBegin(1);
                Material material = new Material(PerspectiveDisplay.this.getXAxisColor());
                Material.renderMaterial(gl, material);
                gl.glVertex3d(0.0, 0.0, 0.0);
                gl.glVertex3d(1.0, 0.0, 0.0);
                material = new Material(PerspectiveDisplay.this.getYAxisColor());
                Material.renderMaterial(gl, material);
                gl.glVertex3d(0.0, 0.0, 0.0);
                gl.glVertex3d(0.0, 1.0, 0.0);
                material = new Material(PerspectiveDisplay.this.getZAxisColor());
                Material.renderMaterial(gl, material);
                gl.glVertex3d(0.0, 0.0, 0.0);
                gl.glVertex3d(0.0, 0.0, 1.0);
                gl.glEnd();
            }
            if (PerspectiveDisplay.this.isGridVisible()) {
                gl.glLineWidth(0.5f);
                WireframeMeshRenderer renderer = new WireframeMeshRenderer(PerspectiveDisplay.this.grid);
                Material material = new Material(PerspectiveDisplay.this.getGridColor());
                Material.renderMaterial(gl, material);
                renderer.render(gl);
            }
        }

        @Override
        public void displayChanged(GLAutoDrawable d, boolean arg1, boolean arg2) {
        }

        @Override
        public void init(GLAutoDrawable d) {
            GL gl = d.getGL();
            if (PerspectiveDisplay.this.getLighting()) {
                float[] ambient = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
                float[] specular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
                float[] position = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
                float[] ambientModel = new float[]{0.1f, 0.1f, 0.1f, 0.1f};
                gl.glLightfv(16384, 4608, ambient, 0);
                gl.glLightfv(16384, 4610, specular, 0);
                gl.glLightfv(16384, 4611, position, 0);
                gl.glLightModelfv(2899, ambientModel, 0);
                gl.glEnable(16384);
                gl.glEnable(2896);
            }
            gl.glEnable(2929);
            Color bg = PerspectiveDisplay.this.getGLBackground();
            if (PerspectiveDisplay.this.getFog()) {
                gl.glEnable(2912);
                float[] fogColor = new float[]{(float)bg.getRed() / 255.0f, (float)bg.getGreen() / 255.0f, (float)bg.getBlue() / 255.0f, 1.0f};
                gl.glFogfv(2918, FloatBuffer.wrap(fogColor));
                gl.glFogf(2914, 0.002f);
                gl.glFogi(2917, 2049);
            }
            gl.glEnableClientState(32884);
            gl.glEnableClientState(32885);
            gl.glClearColor((float)bg.getRed() / 255.0f, (float)bg.getGreen() / 255.0f, (float)bg.getBlue() / 255.0f, 0.0f);
            gl.glShadeModel(7425);
            gl.glEnable(3042);
            gl.glEnable(2884);
            gl.glCullFace(1029);
            gl.glBlendEquation(32774);
        }

        @Override
        public void reshape(GLAutoDrawable d, int x, int y, int width, int height) {
            GL gl = d.getGL();
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            PerspectiveDisplay.this.angle = Math.atan(PerspectiveDisplay.this.viewSize / 2.0 / PerspectiveDisplay.this.getViewDistance()) * 2.0;
            PerspectiveDisplay.this.angle *= 57.29577951308232;
            GLU glu = new GLU();
            glu.gluPerspective(PerspectiveDisplay.this.angle, 1.0, PerspectiveDisplay.this.viewBegin, PerspectiveDisplay.this.getViewDistance());
            if (width > height) {
                gl.glViewport(0, -((width - height) / 2), width, width);
            } else {
                gl.glViewport(-((height - width) / 2), 0, height, height);
            }
        }
    }
}

