/*
 * Decompiled with CFR 0.152.
 */
package viewer.event;

import java.util.ArrayList;
import tools3d.Vector4D;
import viewer.event.ViewEvent;
import viewer.event.ViewListener;

public class ViewListenerManager {
    private ArrayList<ViewListener> listeners = new ArrayList();

    public void addViewListener(ViewListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeViewListener(ViewListener listener) {
        return this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void notifyViewTranslation(boolean local, Vector4D oldPosition, Vector4D newPosition) {
        for (ViewListener l : this.listeners) {
            l.viewChanged(new ViewEvent(1, local ? 0 : 1, oldPosition, newPosition));
        }
    }

    public void notifyViewZoom(boolean local, double oldZoom, double newZoom) {
        for (ViewListener l : this.listeners) {
            l.viewChanged(new ViewEvent(2, local ? 0 : 1, oldZoom, newZoom));
        }
    }

    public void notifyViewRotation(boolean local, Vector4D oldDirection, Vector4D oldNormal, Vector4D newDirection, Vector4D newNormal) {
        for (ViewListener l : this.listeners) {
            l.viewChanged(new ViewEvent(0, local ? 0 : 1, oldDirection, newDirection, oldNormal, newNormal));
        }
    }

    public void notifyViewChanged() {
        for (ViewListener l : this.listeners) {
            l.viewChanged(new ViewEvent());
        }
    }
}

