/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph.rna;

import rnadesign.rnamodel.Atom3D;
import tools3d.Vector4D;
import viewer.graph.rna.AtomRendererGraph;
import viewer.graphics.AdvancedMesh;
import viewer.graphics.AdvancedMeshTools;
import viewer.graphics.ColorModel;
import viewer.graphics.DefaultAdvancedMesh;
import viewer.graphics.Material;
import viewer.graphics.PrimitiveFactory;

public class SphericalAtomRendererGraph
extends AtomRendererGraph {
    private final DefaultAdvancedMesh COARSE_MESH = new DefaultAdvancedMesh();
    private final DefaultAdvancedMesh MEDIUM_MESH;
    private final DefaultAdvancedMesh FINE_MESH;

    public SphericalAtomRendererGraph(Atom3D atom) {
        super(atom);
        this.COARSE_MESH.add(new Vector4D(0.0, 0.0, 0.0, 1.0), new Vector4D(0.0, 0.0, -1.0, 0.0), new Material(this.getColorModel().getColor(this.getAtom())));
        int[] point = new int[]{0};
        this.COARSE_MESH.add(point);
        this.COARSE_MESH.setPointSize(5.0);
        this.MEDIUM_MESH = new DefaultAdvancedMesh();
        this.MEDIUM_MESH.add(PrimitiveFactory.generateSphere(0.5, 4, 4), this.getColorModel().getMaterial(this.getAtom()));
        this.FINE_MESH = new DefaultAdvancedMesh();
        this.FINE_MESH.add(PrimitiveFactory.generateSphere(0.5, 6, 6), this.getColorModel().getMaterial(this.getAtom()));
    }

    @Override
    public void setColorModel(ColorModel model) {
        int i;
        Material material = new Material(model.getColor(this.getAtom()), true);
        this.COARSE_MESH.setVertexMaterial(0, material);
        material = model.getMaterial(this.getAtom());
        for (i = 0; i < this.MEDIUM_MESH.getVertexCount(); ++i) {
            this.MEDIUM_MESH.setVertexMaterial(i, material);
        }
        for (i = 0; i < this.FINE_MESH.getVertexCount(); ++i) {
            this.FINE_MESH.setVertexMaterial(i, material);
        }
        super.setColorModel(model);
    }

    @Override
    public AdvancedMesh generateMesh() {
        AdvancedMesh mesh = null;
        switch (this.getRefinementLevel()) {
            case 1: {
                mesh = (AdvancedMesh)this.COARSE_MESH.clone();
                break;
            }
            case 2: {
                mesh = (AdvancedMesh)this.MEDIUM_MESH.clone();
                break;
            }
            case 3: {
                mesh = (AdvancedMesh)this.FINE_MESH.clone();
                break;
            }
            default: {
                mesh = (AdvancedMesh)this.MEDIUM_MESH.clone();
            }
        }
        if (this.getAtom().isSelected()) {
            Material material = new Material();
            material.setEmissive(1.0, 1.0, 0.0, 0.0);
            DefaultAdvancedMesh combo = new DefaultAdvancedMesh();
            combo.add(mesh);
            combo.add(AdvancedMeshTools.extractCage(mesh, material));
            return combo;
        }
        return mesh;
    }

    @Override
    public String getClassName() {
        return "SphericalAtomRendererGraph";
    }
}

