/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.opengl.GL;
import tools3d.Vector4D;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.MeshRenderer;

public class WireframeMeshRenderer
implements MeshRenderer {
    private Mesh mesh;
    private LinkedList<Vector4D> vertexArray;
    private LinkedList<Vector4D> normalArray;
    private LinkedList<Material> materialArray;
    private ArrayList<Mesh> meshes = new ArrayList();

    @Override
    public void addMesh(Mesh m) {
        this.meshes.add(m);
    }

    @Override
    public boolean removeMesh(Mesh m) {
        return this.meshes.remove(m);
    }

    public WireframeMeshRenderer(Mesh mesh) {
        this.meshes.add(mesh);
    }

    public WireframeMeshRenderer() {
    }

    @Override
    public void render(GL gl) {
        for (Mesh mesh : this.meshes) {
            this.renderMesh(gl, mesh);
        }
    }

    protected void renderMesh(GL gl, Mesh mesh) {
        this.vertexArray = new LinkedList();
        this.normalArray = new LinkedList();
        int[][] elements = mesh.getGeometryElements();
        for (int i = 0; i < elements.length; ++i) {
            int[] triangle = elements[i];
            for (int j = 0; j < triangle.length; ++j) {
                this.vertexArray.add(mesh.getVertex(triangle[j]));
                this.vertexArray.add(mesh.getVertex(triangle[(j + 1) % triangle.length]));
                this.normalArray.add(mesh.getNormal(triangle[j]));
                this.normalArray.add(mesh.getNormal(triangle[(j + 1) % triangle.length]));
            }
        }
        gl.glBegin(1);
        Iterator vertexIterator = this.vertexArray.iterator();
        Iterator normalIterator = this.normalArray.iterator();
        while (vertexIterator.hasNext()) {
            Vector4D v = (Vector4D)vertexIterator.next();
            Vector4D n = (Vector4D)normalIterator.next();
            gl.glNormal3d(n.getX(), n.getY(), n.getZ());
            gl.glVertex3d(v.getX(), v.getY(), v.getZ());
        }
        gl.glEnd();
    }

    @Override
    public Mesh getMesh() {
        return this.mesh;
    }
}

