/*
 * Decompiled with CFR 0.152.
 */
package viewer.rnadesign;

import commandtools.CommandApplication;
import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.RnaTools;
import tools3d.Vector4D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;
import viewer.commands.CenterOnMolecularMass;
import viewer.commands.DeselectObjects;
import viewer.commands.DisplayCommand;
import viewer.commands.FindObject;
import viewer.commands.GraphEditor;
import viewer.commands.ResetCamera;
import viewer.commands.TranslateObjects;
import viewer.deprecated.RNAModelRenderer;
import viewer.display.DefaultDecorator;
import viewer.display.Display;
import viewer.display.DisplayDecorator;
import viewer.display.DisplayFactory;
import viewer.display.MultiDisplayManager;
import viewer.event.DisplayEvent;
import viewer.event.DisplayLayoutListener;
import viewer.event.DisplayViewChangedListener;
import viewer.event.SelectionEvent;
import viewer.event.SelectionListener;
import viewer.graph.Object3DRenderableGraph;
import viewer.graph.rna.RenderableGraphFactory;
import viewer.graph.rna.RnaRendererGraphController;
import viewer.graphics.ColorModel;
import viewer.graphics.Colorable;
import viewer.graphics.Configurable;
import viewer.rnadesign.AvailableColorModels;
import viewer.rnadesign.AvailableRenderers;
import viewer.rnadesign.LinkRenderer;
import viewer.rnadesign.Object3DSelector;
import viewer.view.ViewOrientation;

public class GraphControllerDisplayManager
extends MultiDisplayManager
implements DisplayLayoutListener,
DisplayDecorator,
DisplayViewChangedListener,
SelectionListener,
ModelChangeListener {
    private JTextField xLocation;
    private JTextField yLocation;
    private JTextField zLocation;
    private JTextField chosenField;
    private JComboBox objectSelectionTypeBox;
    private JComboBox colorBox;
    private JButton linkButton;
    public String objectSelectionType;
    private final int COMBOBOX_WIDTH = 89;
    private final int COMBOBOX_HEIGHT = 10;
    private final String[] rnaClassNames = RnaTools.getRnaClassNames();
    private Object3DGraphController controller;
    private CommandApplication application;
    private LinkRenderer linkRenderer;
    private RnaRendererGraphController renderer;
    private Object3DSelector selector;
    private boolean objectSelectionEnabled = true;
    private boolean viewTranslationEnabled = true;

    public GraphControllerDisplayManager(Object3DGraphController controller) {
        this(controller, null);
    }

    public GraphControllerDisplayManager(Object3DGraphController controller, CommandApplication application) {
        this.addCommand(new ResetCamera());
        this.addCommand(new CenterOnMolecularMass(controller.getGraph()));
        this.addCommand(new DeselectObjects(this));
        this.addCommand(new TranslateObjects(this));
        this.addCommand(new FindObject(controller));
        this.addCommand(new GraphEditor(controller, this));
        this.controller = controller;
        this.application = application;
        DisplayFactory.setDecorator(this);
        this.setDisplay(DisplayFactory.PrefabricatedDisplays.Single.getDefaultDisplay());
        ColorModel colorModel = ((AvailableColorModels)((Object)this.colorBox.getSelectedItem())).getModel();
        this.linkRenderer = new LinkRenderer(controller, colorModel);
        this.linkRenderer.setRenderLinks(true);
        this.linkRenderer.addAllowedLink("Link");
        this.linkRenderer.addAllowedLink("SimpleLink");
        this.linkRenderer.addAllowedLink("SimpleHelixConstraintLink");
        this.getDisplay().addRenderable(this.linkRenderer);
        this.selector = new Object3DSelector(controller, this.getDisplay());
        this.selector.addSelectionListener(this);
        controller.addModelChangeListener(this);
        this.getDisplay().addDisplayViewChangedListener(this);
        this.addDisplayLayoutListener(this);
        this.attachSelectionListeners();
        RnaRendererGraphController rc = RenderableGraphFactory.generate(controller, AvailableRenderers.values()[0]);
        rc.setColorModel(AvailableColorModels.values()[0].getModel());
        rc.setMeshCached(true);
        rc.setRefinementLevel(1);
        this.renderer = rc;
        this.getDisplay().setModelClones(this.renderer);
        this.refreshCommands();
        this.objectSelectionTypeBox = new JComboBox<String>(RnaTools.getRnaClassNames());
        this.objectSelectionTypeBox.setEditable(false);
        this.objectSelectionTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphControllerDisplayManager.this.objectSelectionType = (String)GraphControllerDisplayManager.this.objectSelectionTypeBox.getSelectedItem();
                GraphControllerDisplayManager.this.objectSelectionTypeBox.setSelectedItem(GraphControllerDisplayManager.this.objectSelectionType);
                System.out.println("Selection Type: " + GraphControllerDisplayManager.this.objectSelectionType);
            }
        });
        this.objectSelectionType = (String)this.objectSelectionTypeBox.getSelectedItem();
        this.xLocation = new JTextField(5);
        this.yLocation = new JTextField(5);
        this.zLocation = new JTextField(5);
        this.xLocation.setEditable(false);
        this.yLocation.setEditable(false);
        this.zLocation.setEditable(false);
        this.chosenField = new JTextField(40);
        this.chosenField.setEditable(false);
        this.linkButton = new JButton("Find Links");
        this.linkButton.addActionListener(new LinkListener());
        JPanel bottomPanel = new JPanel();
        JPanel bottom = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(Box.createHorizontalGlue());
        bottom.add(new JLabel("Selection Type: "));
        bottom.add(this.objectSelectionTypeBox);
        bottom.add(Box.createHorizontalStrut(20));
        bottom.add(new JLabel("Selected: "));
        bottom.add(this.chosenField);
        bottom.add(Box.createHorizontalStrut(30));
        bottom.add(new JLabel("X"));
        bottom.add(this.xLocation);
        bottom.add(new JLabel("Y"));
        bottom.add(this.yLocation);
        bottom.add(new JLabel("Z"));
        bottom.add(this.zLocation);
        bottom.add(this.linkButton);
        bottomPanel.add(bottom);
        bottomPanel.add(Box.createHorizontalGlue());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (event.getAncestor().isShowing()) {
                    GraphControllerDisplayManager.this.attachLocationListeners();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.add((Component)bottomPanel, "South");
    }

    public Object3DSelector getSelector() {
        return this.selector;
    }

    public boolean isObjectSelectionEnabled() {
        return this.objectSelectionEnabled;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        System.out.println("GraphControllerDisplayManager.Called modelChanged!");
        this.updateModel();
    }

    public void setObjectSelectionEnabled(boolean objectSelectionEnabled) {
        if (this.objectSelectionEnabled != objectSelectionEnabled) {
            this.objectSelectionEnabled = objectSelectionEnabled;
            if (objectSelectionEnabled) {
                this.attachSelectionListeners();
            } else {
                this.detachSelectionListeners();
            }
        }
    }

    public boolean isViewTranslationEnabled() {
        return this.viewTranslationEnabled;
    }

    public void setViewTranslationEnabled(boolean viewTranslationEnabled) {
        this.viewTranslationEnabled = viewTranslationEnabled;
        for (Display d : this.getDisplay().getDisplays()) {
            d.setMouseTranslationEnabled(viewTranslationEnabled);
        }
    }

    private void attachSelectionListeners() {
        for (Display d : this.getDisplay().getDisplays()) {
            d.addMouseListener(this.selector);
        }
    }

    private void detachSelectionListeners() {
        for (Display d : this.getDisplay().getDisplays()) {
            d.removeMouseListener(this.selector);
        }
    }

    @Override
    public void displayLayoutChanged(DisplayEvent e) {
        this.attachSelectionListeners();
        this.getDisplay().setModelClones(this.renderer);
        this.getDisplay().addDisplayViewChangedListener(this);
        this.selector.setDisplay(this.getDisplay());
        this.attachLocationListeners();
    }

    private void attachLocationListeners() {
        for (Display d : this.getDisplay().getDisplays()) {
            d.addMouseMotionListener(new LocationListener(d));
            d.addMouseListener(new LODTranslationListener(d));
        }
    }

    @Override
    public void displayChanged(DisplayEvent e) {
        super.displayChanged(e);
        if (e.getId() == 1) {
            e.getDisplay().addMouseListener(this.selector);
            e.getDisplay().addMouseMotionListener(new LocationListener(e.getDisplay()));
            e.getDisplay().addMouseListener(new LODTranslationListener(e.getDisplay()));
        }
    }

    @Override
    public JPanel decorateDisplay(Display display, ViewOrientation orientation) {
        DefaultDecorator decorator = new DefaultDecorator();
        final JPanel panel = decorator.decorateDisplay(display, orientation);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        JLabel label = new JLabel("Mode");
        bottomPanel.add(label);
        Object[] objects = new Object[]{"Solid", "Wireframe"};
        final JComboBox<Object> modeBox = new JComboBox<Object>(objects);
        modeBox.setPreferredSize(new Dimension(89, 10));
        modeBox.setEditable(false);
        modeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display display = (Display)((BorderLayout)panel.getLayout()).getLayoutComponent("Center");
                RnaRendererGraphController renderer = (RnaRendererGraphController)display.getModel();
                if (modeBox.getSelectedItem().equals("Solid")) {
                    renderer.setWireframeMode(false);
                } else {
                    renderer.setWireframeMode(true);
                }
                display.repaint();
            }
        });
        bottomPanel.add(Box.createHorizontalStrut(5));
        bottomPanel.add(modeBox);
        final JComboBox<AvailableRenderers> rendererBox = new JComboBox<AvailableRenderers>(AvailableRenderers.values());
        rendererBox.setPreferredSize(new Dimension(89, 10));
        this.colorBox = new JComboBox<AvailableColorModels>(AvailableColorModels.values());
        this.colorBox.setPreferredSize(new Dimension(89, 10));
        JButton rendererModelConfigureButton = new JButton("...");
        rendererModelConfigureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display display = (Display)((BorderLayout)panel.getLayout()).getLayoutComponent("Center");
                RNAModelRenderer renderer = (RNAModelRenderer)display.getModel();
                if (renderer instanceof Configurable) {
                    ((Configurable)((Object)renderer)).launchConfigurationGUI();
                }
                display.display();
            }
        });
        rendererModelConfigureButton.setEnabled(false);
        rendererBox.setEditable(false);
        rendererBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display display = (Display)((BorderLayout)panel.getLayout()).getLayoutComponent("Center");
                RnaRendererGraphController oldRc = (RnaRendererGraphController)display.getModel();
                RnaRendererGraphController rc = RenderableGraphFactory.generate(GraphControllerDisplayManager.this.controller, (AvailableRenderers)((Object)rendererBox.getSelectedItem()));
                rc.loadState(oldRc);
                display.setModel(rc);
                display.display();
            }
        });
        final JButton colorModelConfigureButton = new JButton("...");
        colorModelConfigureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display display = (Display)((BorderLayout)panel.getLayout()).getLayoutComponent("Center");
                RnaRendererGraphController c = (RnaRendererGraphController)display.getModel();
                AvailableColorModels cm = (AvailableColorModels)((Object)GraphControllerDisplayManager.this.colorBox.getSelectedItem());
                if (cm.getModel() instanceof Configurable) {
                    ((Configurable)((Object)cm.getModel())).launchConfigurationGUI();
                }
                c.setColorModel(cm.getModel());
                c.updateMeshes();
                display.repaint();
            }
        });
        colorModelConfigureButton.setEnabled(false);
        label = new JLabel("Renderer");
        bottomPanel.add(label);
        bottomPanel.add(Box.createHorizontalStrut(5));
        bottomPanel.add(rendererBox);
        bottomPanel.add(rendererModelConfigureButton);
        this.colorBox.setEditable(false);
        this.colorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display display = (Display)((BorderLayout)panel.getLayout()).getLayoutComponent("Center");
                Colorable c = (Colorable)((Object)display.getModel());
                AvailableColorModels cm = (AvailableColorModels)((Object)GraphControllerDisplayManager.this.colorBox.getSelectedItem());
                c.setColorModel(cm.getModel());
                if (cm.getModel() instanceof Configurable) {
                    colorModelConfigureButton.setEnabled(true);
                } else {
                    colorModelConfigureButton.setEnabled(false);
                }
                display.repaint();
            }
        });
        label = new JLabel("Color Model");
        bottomPanel.add(label);
        bottomPanel.add(Box.createHorizontalStrut(5));
        bottomPanel.add(this.colorBox);
        bottomPanel.add(colorModelConfigureButton);
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(Box.createHorizontalGlue());
        for (DisplayCommand c : this.getCommands()) {
            bottomPanel.add(c.component(display));
        }
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    public void updateModel() {
        for (Display d : this.getDisplay().getDisplays()) {
            RnaRendererGraphController oldRc = (RnaRendererGraphController)d.getModel();
            RnaRendererGraphController rc = RenderableGraphFactory.generate(this.controller, oldRc.getRenderer());
            rc.loadState(oldRc);
            d.setModel(rc);
            d.display();
        }
        Object3D selected = this.controller.getGraph().getSelectionRoot();
        if (selected != null) {
            this.chosenField.setText(Object3DTools.getFullName(selected));
        }
    }

    public LinkRenderer getLinkRenderer() {
        return this.linkRenderer;
    }

    @Override
    public void objectDeselected(SelectionEvent e) {
        this.handleSelection(e);
    }

    @Override
    public void objectSelected(SelectionEvent e) {
        this.handleSelection(e);
    }

    private void handleSelection(SelectionEvent e) {
        Object3D object = e.getSelectedObject();
        if ((object = this.getObjectOfSelectionType(object)) != null) {
            e.setSelectedObject(this.application, object);
        } else {
            e.setSelectedObject(null);
        }
        object = e.getSelectedObject();
        if (object != null) {
            this.chosenField.setText(Object3DTools.getFullName(object));
        } else {
            this.chosenField.setText("Object of type " + this.objectSelectionType + " not found");
        }
        Object3DRenderableGraph graph = this.renderer.getGraph(object);
        if (graph == null) {
            return;
        }
        graph.update();
        if (!e.isSelectionAdjusting()) {
            this.display();
        }
    }

    private Object3D getObjectOfSelectionType(Object3D object) {
        return Object3DTools.findClosestByClassName(Object3DTools.findRoot(object), object.getPosition(), this.objectSelectionType);
    }

    public RnaRendererGraphController getRenderer() {
        return this.renderer;
    }

    private class LODTranslationListener
    extends MouseAdapter {
        private Display d;
        private int lod;

        public LODTranslationListener(Display d) {
            this.d = d;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            RnaRendererGraphController rc = (RnaRendererGraphController)this.d.getModel();
            if (GraphControllerDisplayManager.this.isViewTranslationEnabled() && rc.getRefinementLevel() != 1) {
                this.lod = rc.getRefinementLevel();
                rc.setRefinementLevel(1);
                rc.updateMeshes();
            } else {
                this.lod = -1;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (GraphControllerDisplayManager.this.isViewTranslationEnabled() && this.lod != -1) {
                RnaRendererGraphController rc = (RnaRendererGraphController)this.d.getModel();
                rc.setRefinementLevel(this.lod);
                rc.updateMeshes();
                this.d.display();
            }
        }
    }

    private class LocationListener
    extends MouseMotionAdapter {
        private Display d;

        public LocationListener(Display d) {
            this.d = d;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Vector4D point = this.d.getCoordinates(e.getPoint());
            if (point == null) {
                return;
            }
            DecimalFormat fmt = new DecimalFormat("###.000");
            GraphControllerDisplayManager.this.xLocation.setText(fmt.format(point.getX()));
            GraphControllerDisplayManager.this.yLocation.setText(fmt.format(point.getY()));
            GraphControllerDisplayManager.this.zLocation.setText(fmt.format(point.getZ()));
        }
    }

    private final class LinkListener
    implements ActionListener {
        private LinkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphControllerDisplayManager.this.controller.addMissingLinks();
        }
    }

    public class GraphConfiguration
    extends MultiDisplayManager.Configuration {
        private JColorChooser colorChooser;

        public GraphConfiguration(String title) {
            super(title);
        }
    }
}

