/*
 * Decompiled with CFR 0.152.
 */
package viewer.rnadesign;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.BoundingVolume;
import tools3d.GeometryTools;
import tools3d.Vector3D;
import tools3d.Vector4D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleObject3DSet;
import viewer.display.Display;
import viewer.display.MultiDisplay;
import viewer.event.SelectionEvent;
import viewer.event.SelectionListener;

public class Object3DSelector
extends MouseAdapter {
    private Object3DGraphController controller;
    private MultiDisplay display;
    private Set<Object3D> selected = new HashSet<Object3D>();
    private Set<String> disallowedSelections = new HashSet<String>();
    private ArrayList<SelectionListener> listeners = new ArrayList();
    private int maxNumberSimultaneousSelections = Integer.MAX_VALUE;

    public Object3DSelector(Object3DGraphController controller) {
        this.controller = controller;
    }

    public Object3DSelector(Object3DGraphController controller, MultiDisplay display) {
        this.controller = controller;
        this.display = display;
    }

    public int getMaxNumberSimultaneousSelections() {
        return this.maxNumberSimultaneousSelections;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeSelectionListener(SelectionListener listener) {
        return this.listeners.remove(listener);
    }

    protected void notifyObjectSelected(Object3D selected) {
        for (SelectionListener l : this.listeners) {
            l.objectSelected(new SelectionEvent(selected, this));
        }
    }

    protected void notifyObjectDeselected(Object3D deselected) {
        for (SelectionListener l : this.listeners) {
            l.objectDeselected(new SelectionEvent(deselected, this));
        }
    }

    protected void notifyObjectDeselected(Object3D deselected, boolean adjusting) {
        for (SelectionListener l : this.listeners) {
            l.objectDeselected(new SelectionEvent(deselected, this, adjusting));
        }
    }

    protected void notifyObjectSelected(Object3D selected, boolean adjusting) {
        for (SelectionListener l : this.listeners) {
            l.objectSelected(new SelectionEvent(selected, this, adjusting));
        }
    }

    public void setMaxNumberSimultaneousSelections(int maxNumberSimultaneousSelections) {
        if (maxNumberSimultaneousSelections < 0) {
            throw new IllegalArgumentException("Argument must be greater than -1");
        }
        this.maxNumberSimultaneousSelections = maxNumberSimultaneousSelections;
        if (this.selected.size() > maxNumberSimultaneousSelections) {
            this.deselectAll();
        }
    }

    public void disallowClassName(String className) {
        this.disallowedSelections.add(className);
    }

    public void allowClassName(String className) {
        this.disallowedSelections.remove(className);
    }

    public Object3D[] getSelected() {
        Object3D[] array = new Object3D[this.selected.size()];
        this.selected.toArray(array);
        return array;
    }

    public void deselectAll() {
        int count = 0;
        for (Object3D o : this.selected) {
            o.setSelected(false);
            this.notifyObjectDeselected(o, ++count != this.selected.size());
        }
        this.selected.clear();
    }

    public void select(Object3D object) {
        if (!this.selected.contains(object)) {
            this.selected.add(object);
        }
        object.setSelected(true);
        this.notifyObjectSelected(object);
    }

    public void deselect(Object3D object) {
        this.selected.remove(object);
        object.setSelected(false);
        this.notifyObjectDeselected(object);
    }

    public boolean isSelected(Object3D object) {
        return this.selected.contains(object);
    }

    public boolean isSelected() {
        return this.selected.size() != 0;
    }

    public Object3D findSelected(Vector4D ray, Vector4D offset, Object3D root) {
        System.out.println("Starting findSelected for node: " + root.getFullName());
        if (this.disallowedSelections.contains(root.getClassName())) {
            System.out.println("No selection possible (0)!");
            return null;
        }
        if (ray.length() == 0.0) {
            System.out.println("Internal error: view ray has zero length! No selection of objects is possible");
            return null;
        }
        BoundingVolume volume = root.getBoundingVolume();
        System.out.println("Using bounding volume: " + volume + " and ray: " + ray + " and offset: " + offset);
        Vector4D o = new Vector4D(offset);
        o.setW(0.0);
        Vector4D p = new Vector4D(root.getPosition());
        if (root.getParent() != null && root.getParent().isSelected()) {
            System.out.println("No selection possible (1a)!");
            return null;
        }
        if (!volume.intersectRay(ray, offset) && !volume.intersectRay(ray.mul(-1.0), offset)) {
            System.out.println("No selection possible (1b)!");
            return null;
        }
        if (root.size() == 0) {
            System.out.println("Selected leaf node!");
            return root;
        }
        double distance = Double.MAX_VALUE;
        int maxDepth = Integer.MIN_VALUE;
        Object3D found = null;
        for (int i = 0; i < root.size(); ++i) {
            Object3D pos = this.findSelected(ray, offset, root.getChild(i));
            if (pos == null) {
                System.out.println("No selection possible (2)!");
                continue;
            }
            double d = Math.abs(GeometryTools.distanceToLine(pos.getPosition(), new Vector3D(offset), new Vector3D(ray)));
            int depth = pos.getDepth();
            if (depth <= maxDepth && (depth != maxDepth || !(d < distance))) continue;
            distance = d;
            found = pos;
            maxDepth = depth;
        }
        if (found == null) {
            System.out.println("No selection possible (3)!");
            return root;
        }
        System.out.println("Found selection object: " + found.getFullName());
        return found;
    }

    public Object3D findSelected2(Vector4D ray, Vector4D offset, Object3D root) {
        if (this.disallowedSelections.contains(root.getClassName())) {
            System.out.println("No selection possible because of object class!");
            return null;
        }
        SimpleObject3DSet objectSet = new SimpleObject3DSet(root);
        double distance = Double.MAX_VALUE;
        int maxDepth = Integer.MIN_VALUE;
        Object3D found = null;
        for (int i = 0; i < objectSet.size(); ++i) {
            Object3D pos = objectSet.get(i);
            if (pos == null) {
                System.out.println("No selection possible, object is null!");
                continue;
            }
            Vector3D objectPos = pos.getPosition();
            double d = Math.abs(GeometryTools.distanceToLine(objectPos, new Vector3D(offset), new Vector3D(ray)));
            int depth = pos.getDepth();
            if (depth <= maxDepth && (depth != maxDepth || !(d < distance))) continue;
            distance = d;
            found = pos;
            maxDepth = depth;
        }
        if (found == null) {
            System.out.println("No selection found!");
            return root;
        }
        System.out.println("Found initial selection object: " + found.getFullName());
        return found;
    }

    public void setDisplay(MultiDisplay display) {
        this.display = display;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Display display = (Display)e.getSource();
        GLContext context = display.getContext();
        int result = context.makeCurrent();
        if (result == 0) {
            System.out.println("Could not make context current");
            return;
        }
        GL gl = context.getGL();
        GLU glu = new GLU();
        IntBuffer viewport = IntBuffer.allocate(4);
        DoubleBuffer projection = DoubleBuffer.allocate(16);
        DoubleBuffer modelview = DoubleBuffer.allocate(16);
        gl.glGetIntegerv(2978, viewport);
        gl.glGetDoublev(2983, projection);
        gl.glGetDoublev(2982, modelview);
        int y = display.getHeight() - e.getY() - 1;
        DoubleBuffer near = DoubleBuffer.allocate(4);
        DoubleBuffer far = DoubleBuffer.allocate(4);
        boolean check1 = glu.gluUnProject(e.getX(), y, 0.0, modelview, projection, viewport, near);
        boolean check2 = glu.gluUnProject(e.getX(), y, 1.0, modelview, projection, viewport, far);
        assert (check1);
        assert (check2);
        Vector4D n = new Vector4D(near.get(0), near.get(1), near.get(2), 0.0);
        Vector4D f = new Vector4D(far.get(0), far.get(1), far.get(2), 0.0);
        Vector4D v = f.minus(n);
        v.normalize();
        Object3D found = this.findSelected2(v, n, this.controller.getGraph().getGraph());
        if (found != null && !this.selected.contains(found)) {
            Iterator<Object3D> iter = this.selected.iterator();
            boolean removed = false;
            while (iter.hasNext()) {
                Object3D o = iter.next();
                if (!found.isAncestor(o)) continue;
                removed = true;
                o.setSelected(false);
                iter.remove();
            }
            if (removed || this.selected.size() < this.maxNumberSimultaneousSelections) {
                this.selected.add(found);
                found.setSelected(true);
                this.notifyObjectSelected(found);
            }
        } else if (found != null) {
            this.selected.remove(found);
            found.setSelected(false);
            this.notifyObjectDeselected(found);
        }
    }
}

