package rnadesign.rnamodel;

import tools3d.objects3d.LinkSet;
import tools3d.CoordinateSystem;
import java.util.*;
import java.io.InputStream;
import java.io.IOException;

public interface StrandJunctionDB {

    /** adds a new junction to database */
    public void addJunction(StrandJunction3D junction, LinkSet linkSet);

    /** returns set with indices of all junctions of this order, that are similar based on hash function */
    public Set<Integer> findSimilarJunctions(List<BranchDescriptor3D> branches);

    /** returns set with indices of all junctions of this order, that are similar based on hash function.
`     * Before query, all helix descriptors are transformed using the provided active transformations. */
    public Set<Integer> findSimilarJunctions(List<BranchDescriptor3D> branches, List<CoordinateSystem> activeTranforms);

    /** returns array with indices of all junctions of this order, that are similar based on hash function.
     * Before query, all helix descriptors are transformed using the provided active transformations. */
    public Map<Integer, Double> findAndScoreSimilarJunctions(List<BranchDescriptor3D> branches, List<CoordinateSystem> activeTransforms);

    /** returns array with indices of all junctions of this order, that are similar based on hash function.
     * Before query, all helix descriptors are transformed using the provided active transformations. */
    public Map<Integer, Double> findAndScoreSimilarJunctions(List<BranchDescriptor3D> branches);

    /** Returns name of junction database. Typical: junctionDB and kissingLoopDB */
    public String getName();
    
    /** returns array with indices of all junctions of this order.
     * Before query, all helix descriptors are transformed using the provided active transformations. */
    public List<Double> scoreAllJunctions(List<BranchDescriptor3D> branches, List<CoordinateSystem> activeTransforms);

    /** returns array with indices of all junctions of this order.
     * Before query, all helix descriptors are transformed using the provided active transformations. */
    public List<Double> scoreAllJunctions(List<BranchDescriptor3D> branches);

    /** returns array with similarity scores (0.0: identitical 3D transformations). 
     * The junctionIds are typically generated by function findSimilarJunctions. */
    // public double[] scoreSimilarJunctions(List<BranchDescriptor3D> branches, int[] junctionIds);

    /** returns add junctions of specified order. Example: for 3-way junctions the order is 3. */
    public StrandJunction3D[] getJunctions(int order);    

    /** returns n'th junctions of specified order. Example: for 3-way junctions the order is 3. */
    public StrandJunction3D getJunction(int order, int n);    

    /** returns link set correspdonding to this junction */
    public LinkSet getJunctionLinkSet(int order, int n);

    /** returns total number of defined junctions. */
    public int getJunctionCount();

    /** returns array with indices of all junctions of this order, that are 
     * superposable withing this DRMS cutoff */
    public int[] getSuperposableJunctions(int order, int n, double rmsLimit);

    /** provides simple human readable content information. */
    public String infoString();

    /** returns true if database is defined */
    public boolean isValid();

    /** ranks 2D junctions for interpolating loops */
    public List<Properties> rankLoopFits(BranchDescriptor3D b1, BranchDescriptor3D b2,
					 int n1Min, int n1Max, int n2Min, int n2Max);

    /** reads dababase from stream */
    public void read(InputStream is) throws IOException;

    /** Retrieves all database elements compatible with this descriptor as one list */
    public List<StrandJunction3D> retrieveJunctions(DBElementDescriptor dbe);

    /** Retrieves all database elements compatible as one list */
    public List<StrandJunction3D> retrieveAllJunctions();

    public void setName(String s);

    /** returns number of defined dimensions */
    public int size();

    /** returns number of entries for dimension n */
    public int size(int n);

}
