package sequence;

import java.util.Properties;
import java.io.InputStream;

public class SimpleResidue implements Residue {

    private LetterSymbol symbol;

    private int pos;

    private int assignedNumber;

    private String assignedName = "";

    private Object parentObject;

    private Properties properties;

    public SimpleResidue(LetterSymbol symbol, Object parentObject, int pos) {
	this.symbol = symbol;
	this.parentObject = parentObject;
	this.pos = pos;
	this.assignedNumber = 0;
    }

//     public SimpleResidue(Residue other) {
// 	this.symbol = getSymbol();
// 	this.parentObject = getSequence();
// 	this.pos = getPos();;
// 	this.assignedNumber = getAssignedNumber();	
//     }

    /** makes new copy with new symbol, however not new parent object */
    public Object cloneDeep() {
	Residue residue = new SimpleResidue(symbol, parentObject, pos);
	residue.setAssignedNumber(this.assignedNumber);
	residue.setAssignedName(new String(this.assignedName));
	return residue;
    }

    /** implements comparable interface. 
     * TODO: problem: if residues point to different strands, the comparison in meaningless */
//     public int compareTo(Residue other) {
// 	if (!isSameSequence(other)) {
// 	    return ((Comparable)getParentObject()).compareTo((Comparable)(other.getParentObject()));
// 	}
// 	int p1 = getPos();
// 	int p2 = other.getPos();
// 	if (p1 < p2) {
// 	    return -1;
// 	}
// 	else if (p2 > p1) {
// 	    return 1;
// 	}
// 	return 0; // must be equal
//     }

    public String getAssignedName() { return assignedName; }

    /** returns assigned number (like residue number occuring in PDB file */
    public int getAssignedNumber() { return assignedNumber; }

    public LetterSymbol getSymbol() { return symbol; }

    public Object getParentObject() { return this.parentObject; }

    public int getPos() { return pos; }

    public String getProperty(String key) {
	if (properties == null) {
	    return null;
	}
	return properties.getProperty(key);
    }

    public Properties getProperties() { return properties; }

    /** returns true if part of same sequence */
    public boolean isSameSequence(Residue other) {
	return (this.getParentObject() != null) && (this.getParentObject() == other.getParentObject());
    }

    public void read(InputStream is) {
	// TODO
	assert false;
    }

    /** sets assigned number (like residue number occuring in PDB file */
    public void setAssignedNumber(int number) { this.assignedNumber = number; }

    public void setAssignedName(String name) { this.assignedName = name; }

    public void setPos(int pos) { this.pos = pos; }

    public void setProperties(Properties prop) { this.properties = prop; }

    public void setProperty(String key, String value) {
	if (properties == null) {
	    properties = new Properties();
	}
	this.properties.setProperty(key, value);
    }

    public void setParentObject(Object parentObject) { this.parentObject = parentObject; }
    
    public void setSymbol(LetterSymbol symbol) { this.symbol = symbol; }

    public String infoString() { return toString(); }

    public String toString() {
	String s = new String(symbol.toString() + " " + pos);
	return s;
    }

}
