/*
 * Decompiled with CFR 0.152.
 */
package apple.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class KeychainStore
extends KeyStoreSpi {
    private Hashtable deletedEntries = new Hashtable();
    private Hashtable addedEntries = new Hashtable();
    private Hashtable entries = new Hashtable();
    private static final int[] keyBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 2};
    private static final int[] pbeWithSHAAnd3KeyTripleDESCBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 3};
    private static ObjectIdentifier PKCS8ShroudedKeyBag_OID;
    private static ObjectIdentifier pbeWithSHAAnd3KeyTripleDESCBC_OID;
    private static final int iterationCount = 1024;
    private static final int SALT_LEN = 20;
    private SecureRandom random;

    private static void permissionCheck() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("useKeychainStore"));
        }
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object v;
        KeychainStore.permissionCheck();
        if (cArray == null || cArray.length == 0) {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            cArray = Long.toString(this.random.nextLong()).toCharArray();
        }
        if ((v = this.entries.get(string.toLowerCase())) == null || !(v instanceof KeyEntry)) {
            return null;
        }
        byte[] byArray = this._getEncodedKeyData(((KeyEntry)v).keyRef, cArray);
        if (byArray == null) {
            return null;
        }
        PrivateKey privateKey = null;
        try {
            AlgorithmParameters algorithmParameters;
            ObjectIdentifier objectIdentifier;
            Object object;
            Object object2;
            byte[] byArray2;
            Object object3;
            byte[] byArray3 = this.fetchPrivateKeyFromBag(byArray);
            try {
                object3 = new EncryptedPrivateKeyInfo(byArray3);
                byArray2 = ((EncryptedPrivateKeyInfo)object3).getEncryptedData();
                object2 = new DerValue(((EncryptedPrivateKeyInfo)object3).getAlgorithm().encode());
                object = ((DerValue)object2).toDerInputStream();
                objectIdentifier = ((DerInputStream)object).getOID();
                algorithmParameters = this.parseAlgParameters((DerInputStream)object);
            }
            catch (IOException iOException) {
                UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo: " + iOException);
                unrecoverableKeyException.initCause(iOException);
                throw unrecoverableKeyException;
            }
            object3 = this.getPBEKey(cArray);
            object2 = Cipher.getInstance(objectIdentifier.toString());
            ((Cipher)object2).init(2, (Key)object3, algorithmParameters);
            object = ((Cipher)object2).doFinal(byArray2);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec((byte[])object);
            DerValue derValue = new DerValue((byte[])object);
            DerInputStream derInputStream = derValue.toDerInputStream();
            int n = derInputStream.getInteger();
            DerValue[] derValueArray = derInputStream.getSequence(2);
            AlgorithmId algorithmId = new AlgorithmId(derValueArray[0].getOID());
            String string2 = algorithmId.getName();
            KeyFactory keyFactory = KeyFactory.getInstance(string2);
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Get Key failed: " + exception.getMessage());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        return privateKey;
    }

    private native byte[] _getEncodedKeyData(long var1, char[] var3);

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        KeychainStore.permissionCheck();
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof KeyEntry) {
            if (((KeyEntry)v).chain == null) {
                return null;
            }
            return (Certificate[])((KeyEntry)v).chain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        KeychainStore.permissionCheck();
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                return ((TrustedCertEntry)v).cert;
            }
            if (((KeyEntry)v).chain == null) {
                return null;
            }
            return ((KeyEntry)v).chain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        KeychainStore.permissionCheck();
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                return new Date(((TrustedCertEntry)v).date.getTime());
            }
            return new Date(((KeyEntry)v).date.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        KeychainStore.permissionCheck();
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            try {
                String string2;
                KeyEntry keyEntry = new KeyEntry();
                keyEntry.date = new Date();
                if (key instanceof PrivateKey) {
                    if (!key.getFormat().equals("PKCS#8") && !key.getFormat().equals("PKCS8")) {
                        throw new KeyStoreException("Private key is not encoded as PKCS#8");
                    }
                } else {
                    throw new KeyStoreException("Key is not a PrivateKey");
                }
                keyEntry.protectedPrivKey = this.encryptPrivateKey(key.getEncoded(), cArray);
                keyEntry.password = (char[])cArray.clone();
                if (certificateArray != null) {
                    if (certificateArray.length > 1 && !this.validateChain(certificateArray)) {
                        throw new KeyStoreException("Certificate chain does not validate");
                    }
                    keyEntry.chain = (Certificate[])certificateArray.clone();
                    keyEntry.chainRefs = new long[keyEntry.chain.length];
                }
                if (this.entries.get(string2 = string.toLowerCase()) != null) {
                    this.deletedEntries.put(string2, this.entries.get(string2));
                }
                this.entries.put(string2, keyEntry);
                this.addedEntries.put(string2, keyEntry);
            }
            catch (Exception exception) {
                KeyStoreException keyStoreException = new KeyStoreException("Key protection algorithm not found: " + exception);
                keyStoreException.initCause(exception);
                throw keyStoreException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        KeychainStore.permissionCheck();
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            KeyEntry keyEntry = new KeyEntry();
            try {
                object = new EncryptedPrivateKeyInfo(byArray);
                keyEntry.protectedPrivKey = ((EncryptedPrivateKeyInfo)object).getEncoded();
            }
            catch (IOException iOException) {
                throw new KeyStoreException("key is not encoded as EncryptedPrivateKeyInfo");
            }
            keyEntry.date = new Date();
            if (certificateArray != null && certificateArray.length != 0) {
                keyEntry.chain = (Certificate[])certificateArray.clone();
                keyEntry.chainRefs = new long[keyEntry.chain.length];
            }
            if (this.entries.get(object = string.toLowerCase()) != null) {
                this.deletedEntries.put(object, this.entries.get(string));
            }
            this.entries.put(object, keyEntry);
            this.addedEntries.put(object, keyEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        KeychainStore.permissionCheck();
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object2;
            Object v = this.entries.get(string.toLowerCase());
            if (v != null && v instanceof KeyEntry) {
                throw new KeyStoreException("Cannot overwrite key entry with certificate");
            }
            Collection collection = this.entries.values();
            for (Object object2 : collection) {
                if (!(object2 instanceof TrustedCertEntry)) continue;
                TrustedCertEntry trustedCertEntry = (TrustedCertEntry)object2;
                if (!trustedCertEntry.cert.equals(certificate)) continue;
                throw new KeyStoreException("Keychain does not support mulitple copies of same certificate.");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = certificate;
            trustedCertEntry.date = new Date();
            object2 = string.toLowerCase();
            if (this.entries.get(object2) != null) {
                this.deletedEntries.put(object2, this.entries.get(object2));
            }
            this.entries.put(object2, trustedCertEntry);
            this.addedEntries.put(object2, trustedCertEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        KeychainStore.permissionCheck();
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object v = this.entries.remove(string.toLowerCase());
            this.deletedEntries.put(string.toLowerCase(), v);
        }
    }

    public Enumeration engineAliases() {
        KeychainStore.permissionCheck();
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        KeychainStore.permissionCheck();
        return this.entries.containsKey(string.toLowerCase());
    }

    @Override
    public int engineSize() {
        KeychainStore.permissionCheck();
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        KeychainStore.permissionCheck();
        Object v = this.entries.get(string.toLowerCase());
        return v != null && v instanceof KeyEntry;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        KeychainStore.permissionCheck();
        Object v = this.entries.get(string.toLowerCase());
        return v != null && v instanceof TrustedCertEntry;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        KeychainStore.permissionCheck();
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (v instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)v).cert;
            } else {
                if (((KeyEntry)v).chain == null) continue;
                certificate2 = ((KeyEntry)v).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object v;
        String string;
        KeychainStore.permissionCheck();
        Enumeration enumeration = this.deletedEntries.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            v = this.deletedEntries.get(string);
            if (v instanceof TrustedCertEntry) {
                if (((TrustedCertEntry)v).certRef == 0L) continue;
                this._removeItemFromKeychain(((TrustedCertEntry)v).certRef);
                this._releaseKeychainItemRef(((TrustedCertEntry)v).certRef);
                continue;
            }
            KeyEntry keyEntry = (KeyEntry)v;
            if (keyEntry.chain == null) continue;
            for (int i = 0; i < keyEntry.chain.length; ++i) {
                if (keyEntry.chainRefs[i] == 0L) continue;
                this._removeItemFromKeychain(keyEntry.chainRefs[i]);
                this._releaseKeychainItemRef(keyEntry.chainRefs[i]);
            }
            if (keyEntry.keyRef == 0L) continue;
            this._removeItemFromKeychain(keyEntry.keyRef);
            this._releaseKeychainItemRef(keyEntry.keyRef);
        }
        enumeration = this.addedEntries.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            string = (String)enumeration.nextElement();
            v = this.addedEntries.get(string);
            if (v instanceof TrustedCertEntry) {
                object = (TrustedCertEntry)v;
                Certificate certificate = ((TrustedCertEntry)object).cert;
                ((TrustedCertEntry)object).certRef = this.addCertificateToKeychain(string, certificate);
                continue;
            }
            object = (KeyEntry)v;
            if (((KeyEntry)object).chain == null) continue;
            for (int i = 0; i < ((KeyEntry)object).chain.length; ++i) {
                ((KeyEntry)object).chainRefs[i] = this.addCertificateToKeychain(string, ((KeyEntry)object).chain[i]);
            }
            ((KeyEntry)object).keyRef = this._addItemToKeychain(string, false, ((KeyEntry)object).protectedPrivKey, ((KeyEntry)object).password);
        }
        this.deletedEntries.clear();
        this.addedEntries.clear();
    }

    private long addCertificateToKeychain(String string, Certificate certificate) {
        byte[] byArray = null;
        long l = 0L;
        try {
            byArray = certificate.getEncoded();
            l = this._addItemToKeychain(string, true, byArray, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    private native long _addItemToKeychain(String var1, boolean var2, byte[] var3, char[] var4);

    private native int _removeItemFromKeychain(long var1);

    private native void _releaseKeychainItemRef(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        KeychainStore.permissionCheck();
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Enumeration enumeration = this.entries.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this.entries.get(string);
                if (v instanceof TrustedCertEntry) {
                    if (((TrustedCertEntry)v).certRef == 0L) continue;
                    this._releaseKeychainItemRef(((TrustedCertEntry)v).certRef);
                    continue;
                }
                KeyEntry keyEntry = (KeyEntry)v;
                if (keyEntry.chain == null) continue;
                for (int i = 0; i < keyEntry.chain.length; ++i) {
                    if (keyEntry.chainRefs[i] == 0L) continue;
                    this._releaseKeychainItemRef(keyEntry.chainRefs[i]);
                }
                if (keyEntry.keyRef == 0L) continue;
                this._releaseKeychainItemRef(keyEntry.keyRef);
            }
            this.entries.clear();
            this._scanKeychain();
        }
    }

    private native void _scanKeychain();

    private void createTrustedCertEntry(String string, long l, long l2, byte[] byArray) {
        TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            ((InputStream)byteArrayInputStream).close();
            trustedCertEntry.cert = x509Certificate;
            trustedCertEntry.certRef = l;
            trustedCertEntry.date = l2 != 0L ? new Date(l2) : new Date();
            int n = 1;
            String string2 = string;
            while (this.entries.containsKey(string.toLowerCase())) {
                string = string2 + " " + n;
                ++n;
            }
            this.entries.put(string.toLowerCase(), trustedCertEntry);
        }
        catch (Exception exception) {
            System.err.println("KeychainStore Ignored Exception: " + exception);
        }
    }

    private void createKeyEntry(String string, long l, long l2, long[] lArray, byte[][] byArray) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        int n;
        Object object2;
        Object[] objectArray;
        KeyEntry keyEntry = new KeyEntry();
        keyEntry.protectedPrivKey = null;
        keyEntry.keyRef = l2;
        keyEntry.date = l != 0L ? new Date(l) : new Date();
        ArrayList<CertKeychainItemPair> arrayList = new ArrayList<CertKeychainItemPair>();
        try {
            objectArray = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < byArray.length; ++i) {
                try {
                    object2 = new ByteArrayInputStream(byArray[i]);
                    X509Certificate x509Certificate = (X509Certificate)objectArray.generateCertificate((InputStream)object2);
                    ((InputStream)object2).close();
                    arrayList.add(new CertKeychainItemPair(lArray[i], x509Certificate));
                    continue;
                }
                catch (CertificateException certificateException) {
                    System.err.println("KeychainStore Ignored Exception: " + certificateException);
                }
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        objectArray = arrayList.toArray();
        Certificate[] certificateArray = new Certificate[objectArray.length];
        object2 = new long[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            object = (CertKeychainItemPair)objectArray[n];
            certificateArray[n] = ((CertKeychainItemPair)object).mCert;
            object2[n] = ((CertKeychainItemPair)object).mCertificateRef;
        }
        keyEntry.chain = certificateArray;
        keyEntry.chainRefs = (long[])object2;
        n = 1;
        object = string;
        while (this.entries.containsKey(string.toLowerCase())) {
            string = (String)object + " " + n;
            ++n;
        }
        this.entries.put(string.toLowerCase(), keyEntry);
    }

    private boolean validateChain(Certificate[] certificateArray) {
        for (int i = 0; i < certificateArray.length - 1; ++i) {
            X500Principal x500Principal;
            X500Principal x500Principal2 = ((X509Certificate)certificateArray[i]).getIssuerX500Principal();
            if (x500Principal2.equals(x500Principal = ((X509Certificate)certificateArray[i + 1]).getSubjectX500Principal())) continue;
            return false;
        }
        return true;
    }

    private byte[] fetchPrivateKeyFromBag(byte[] byArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        byte[] byArray2 = null;
        DerValue derValue = new DerValue(new ByteArrayInputStream(byArray));
        DerInputStream derInputStream = derValue.toDerInputStream();
        int n = derInputStream.getInteger();
        if (n != 3) {
            throw new IOException("PKCS12 keystore not in version 3 format");
        }
        ContentInfo contentInfo = new ContentInfo(derInputStream);
        ObjectIdentifier objectIdentifier = contentInfo.getContentType();
        if (!objectIdentifier.equals(ContentInfo.DATA_OID)) {
            throw new IOException("public key protected PKCS12 not supported");
        }
        byte[] byArray3 = contentInfo.getData();
        DerInputStream derInputStream2 = new DerInputStream(byArray3);
        DerValue[] derValueArray = derInputStream2.getSequence(2);
        int n2 = derValueArray.length;
        for (int i = 0; i < n2; ++i) {
            Object var16_16 = null;
            DerInputStream derInputStream3 = new DerInputStream(derValueArray[i].toByteArray());
            ContentInfo contentInfo2 = new ContentInfo(derInputStream3);
            objectIdentifier = contentInfo2.getContentType();
            byte[] byArray4 = null;
            if (!objectIdentifier.equals(ContentInfo.DATA_OID)) {
                if (objectIdentifier.equals(ContentInfo.ENCRYPTED_DATA_OID)) continue;
                throw new IOException("public key protected PKCS12 not supported");
            }
            byArray4 = contentInfo2.getData();
            DerInputStream derInputStream4 = new DerInputStream(byArray4);
            byArray2 = this.extractKeyData(derInputStream4);
        }
        return byArray2;
    }

    private byte[] extractKeyData(DerInputStream derInputStream) throws IOException, NoSuchAlgorithmException, CertificateException {
        byte[] byArray = null;
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n = derValueArray.length;
        for (int i = 0; i < n; ++i) {
            Object var9_9 = null;
            DerInputStream derInputStream2 = derValueArray[i].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream2.getOID();
            DerValue derValue = derInputStream2.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.tag);
            }
            derValue = derValue.data.getDerValue();
            if (objectIdentifier.equals(PKCS8ShroudedKeyBag_OID)) {
                byArray = derValue.toByteArray();
                continue;
            }
            System.out.println("Unsupported bag type '" + objectIdentifier + "'");
        }
        return byArray;
    }

    private AlgorithmParameters getAlgorithmParameters(String string) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.getSalt(), 1024);
        try {
            algorithmParameters = AlgorithmParameters.getInstance(string);
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getAlgorithmParameters failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return algorithmParameters;
    }

    private byte[] getSalt() {
        byte[] byArray = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byArray = this.random.generateSeed(20);
        return byArray;
    }

    private AlgorithmParameters parseAlgParameters(DerInputStream derInputStream) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        try {
            DerValue derValue;
            if (derInputStream.available() == 0) {
                derValue = null;
            } else {
                derValue = derInputStream.getDerValue();
                if (derValue.tag == 5) {
                    derValue = null;
                }
            }
            if (derValue != null) {
                algorithmParameters = AlgorithmParameters.getInstance("PBE");
                algorithmParameters.init(derValue.toByteArray());
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("parseAlgParameters failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return algorithmParameters;
    }

    private SecretKey getPBEKey(char[] cArray) throws IOException {
        SecretKey secretKey = null;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBE");
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getSecretKey failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return secretKey;
    }

    private byte[] encryptPrivateKey(byte[] byArray, char[] cArray) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] byArray2 = null;
        try {
            AlgorithmParameters algorithmParameters = this.getAlgorithmParameters("PBEWithSHA1AndDESede");
            SecretKey secretKey = this.getPBEKey(cArray);
            Cipher cipher = Cipher.getInstance("PBEWithSHA1AndDESede");
            cipher.init(1, (Key)secretKey, algorithmParameters);
            byte[] byArray3 = cipher.doFinal(byArray);
            AlgorithmId algorithmId = new AlgorithmId(pbeWithSHAAnd3KeyTripleDESCBC_OID, algorithmParameters);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(algorithmId, byArray3);
            byArray2 = encryptedPrivateKeyInfo.getEncoded();
        }
        catch (Exception exception) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Encrypt Private Key failed: " + exception.getMessage());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        return byArray2;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("osx");
                return null;
            }
        });
        try {
            PKCS8ShroudedKeyBag_OID = new ObjectIdentifier(keyBag);
            pbeWithSHAAnd3KeyTripleDESCBC_OID = new ObjectIdentifier(pbeWithSHAAnd3KeyTripleDESCBC);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class CertKeychainItemPair {
        long mCertificateRef;
        Certificate mCert;

        CertKeychainItemPair(long l, Certificate certificate) {
            this.mCertificateRef = l;
            this.mCert = certificate;
        }
    }

    class TrustedCertEntry {
        Date date;
        Certificate cert;
        long certRef;

        TrustedCertEntry() {
        }
    }

    class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        char[] password;
        long keyRef;
        Certificate[] chain;
        long[] chainRefs;

        KeyEntry() {
        }
    }
}

